/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.ForecasterJobAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.rest.RestJobAction;
import org.opensearch.timeseries.transport.JobRequest;
import org.opensearch.transport.client.node.NodeClient;
import org.owasp.encoder.Encode;

public class RestForecasterJobAction
extends RestJobAction {
    public static final String FORECAST_JOB_ACTION = "forecaster_job_action";

    public String getName() {
        return FORECAST_JOB_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            String forecasterId = request.param("forecasterID");
            String rawPath = request.rawPath();
            DateRange dateRange = this.parseInputDateRange(request);
            JobRequest forecasterJobRequest = new JobRequest(forecasterId, dateRange, false, rawPath);
            return channel -> client.execute((ActionType)ForecasterJobAction.INSTANCE, (ActionRequest)forecasterJobRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    @Override
    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_forecast/forecasters", "forecasterID", "_start")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_forecast/forecasters", "forecasterID", "_stop")));
    }
}

