/* preferences_dialog.c generated by valac 0.56.17, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2015-2022 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "pamac-gtk.h"
#include <pamac.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_PREFERENCES_WINDOW (pamac_preferences_window_get_type ())
#define PAMAC_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindow))
#define PAMAC_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindowClass))
#define PAMAC_IS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PREFERENCES_WINDOW))
#define PAMAC_IS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PREFERENCES_WINDOW))
#define PAMAC_PREFERENCES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindowClass))

typedef struct _PamacPreferencesWindow PamacPreferencesWindow;
typedef struct _PamacPreferencesWindowClass PamacPreferencesWindowClass;
typedef struct _PamacPreferencesWindowPrivate PamacPreferencesWindowPrivate;
enum  {
	PAMAC_PREFERENCES_WINDOW_0_PROPERTY,
	PAMAC_PREFERENCES_WINDOW_NUM_PROPERTIES
};
static GParamSpec* pamac_preferences_window_properties[PAMAC_PREFERENCES_WINDOW_NUM_PROPERTIES];

#define PAMAC_TYPE_MANAGER_WINDOW (pamac_manager_window_get_type ())
#define PAMAC_MANAGER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindow))
#define PAMAC_MANAGER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindowClass))
#define PAMAC_IS_MANAGER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_MANAGER_WINDOW))
#define PAMAC_IS_MANAGER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_MANAGER_WINDOW))
#define PAMAC_MANAGER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindowClass))

typedef struct _PamacManagerWindow PamacManagerWindow;
typedef struct _PamacManagerWindowClass PamacManagerWindowClass;
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _PamacManagerWindowPrivate PamacManagerWindowPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _PamacPreferencesWindowRefreshCleanCacheButtonData PamacPreferencesWindowRefreshCleanCacheButtonData;
typedef struct _PamacPreferencesWindowRefreshCleanBuildFilesButtonData PamacPreferencesWindowRefreshCleanBuildFilesButtonData;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

struct _PamacPreferencesWindow {
	HdyPreferencesWindow parent_instance;
	PamacPreferencesWindowPrivate * priv;
};

struct _PamacPreferencesWindowClass {
	HdyPreferencesWindowClass parent_class;
};

struct _PamacPreferencesWindowPrivate {
	HdyExpanderRow* check_updates_expander;
	HdyComboRow* refresh_period_comborow;
	GtkSwitch* no_update_hide_icon_button;
	GtkSwitch* download_updates_button;
	GtkSwitch* offline_upgrade_button;
	HdyComboRow* parallel_downloads_comborow;
	HdyPreferencesGroup* mirrors_preferences_group;
	HdyComboRow* mirrors_country_comborow;
	GtkButton* generate_mirrors_list_button;
	HdyComboRow* cache_keep_nb_comborow;
	GtkSwitch* cache_only_uninstalled_button;
	GtkLabel* clean_cache_label;
	GtkButton* clean_cache_button;
	HdyPreferencesPage* advanced_preferences_page;
	GtkSwitch* check_space_button;
	GtkSwitch* remove_unrequired_deps_button;
	GtkSwitch* simple_install_button;
	GtkSwitch* enable_downgrade_button;
	GtkListBox* ignorepkgs_listbox;
	HdyPreferencesPage* third_party_preferences_page;
	HdyPreferencesGroup* aur_preferences_group;
	HdyExpanderRow* enable_aur_expander;
	GtkButton* aur_build_dir_file_chooser;
	GtkSwitch* keep_built_pkgs_button;
	GtkSwitch* check_aur_updates_button;
	GtkSwitch* check_aur_vcs_updates_button;
	GtkButton* clean_build_files_button;
	GtkLabel* clean_build_files_label;
	HdyPreferencesGroup* flatpak_preferences_group;
	HdyExpanderRow* enable_flatpak_expander;
	GtkSwitch* check_flatpak_updates_button;
	HdyPreferencesGroup* snap_preferences_group;
	GtkSwitch* enable_snap_button;
	PamacLocalConfig* local_config;
	PamacConfig* config;
	PamacDatabase* database;
	PamacTransactionGtk* transaction;
	guint64 previous_refresh_period;
	gboolean transaction_running;
};

struct _Block1Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	GValue val;
};

struct _PamacManagerWindow {
	HdyApplicationWindow parent_instance;
	PamacManagerWindowPrivate * priv;
	GtkStack* main_stack;
	GtkButton* button_back;
	HdyLeaflet* packages_leaflet;
	GtkButton* search_button;
	GtkSearchEntry* search_entry;
	HdyFlap* browse_flap;
	GtkStack* view_stack;
	HdyViewSwitcherTitle* view_stack_switcher;
	GtkBox* main_details_box;
	GtkButton* details_button;
	GtkButton* apply_button;
	GtkRevealer* infobox_revealer;
	GQueue* display_package_queue;
	PamacTransactionGtk* transaction;
	PamacLocalConfig* local_config;
	gboolean important_details;
	gboolean transaction_running;
	gboolean generate_mirrors_list;
};

struct _PamacManagerWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GListStore* mirrors_store;
	gint index;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gchar* preferences_choosen_country;
};

struct _PamacPreferencesWindowRefreshCleanCacheButtonData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacPreferencesWindow* self;
	GHashTable* details;
	PamacDatabase* _tmp0_;
	GHashTable* _tmp1_;
	GHashTableIter iter;
	GHashTable* _tmp2_;
	guint64 total_size;
	guint files_nb;
	guint64* size;
	gconstpointer _tmp3_;
	gboolean _tmp4_;
	guint64* _tmp5_;
	guint64* _tmp6_;
	guint _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	guint _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
};

struct _PamacPreferencesWindowRefreshCleanBuildFilesButtonData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacPreferencesWindow* self;
	GHashTable* details;
	PamacDatabase* _tmp0_;
	GHashTable* _tmp1_;
	GHashTableIter iter;
	GHashTable* _tmp2_;
	guint64 total_size;
	guint files_nb;
	guint64* size;
	gconstpointer _tmp3_;
	gboolean _tmp4_;
	guint64* _tmp5_;
	guint64* _tmp6_;
	guint _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	guint _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
};

struct _Block4Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	GtkFileChooserDialog* chooser;
};

struct _Block5Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	GtkListBoxRow* row;
	gchar* pkgname;
};

struct _Block6Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	PamacChoosePkgsDialog* choose_pkgs_dialog;
};

struct _Block7Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	PamacManagerWindow* manager_window;
};

static gint PamacPreferencesWindow_private_offset;
static gpointer pamac_preferences_window_parent_class = NULL;

VALA_EXTERN GType pamac_preferences_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacPreferencesWindow, g_object_unref)
VALA_EXTERN GType pamac_manager_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacManagerWindow, g_object_unref)
VALA_EXTERN PamacPreferencesWindow* pamac_preferences_window_new (PamacManagerWindow* window,
                                                      PamacLocalConfig* local_config);
VALA_EXTERN PamacPreferencesWindow* pamac_preferences_window_construct (GType object_type,
                                                            PamacManagerWindow* window,
                                                            PamacLocalConfig* local_config);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar* __lambda84_ (PamacPreferencesWindow* self,
                    GObject* object);
static gchar* ___lambda84__hdy_combo_row_get_name_func (GObject* item,
                                                 gpointer self);
static void pamac_preferences_window_on_check_updates_expander_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_check_updates_expander_changed_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void pamac_preferences_window_on_refresh_period_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_refresh_period_comborow_changed_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self);
static gchar* __lambda85_ (PamacPreferencesWindow* self,
                    GObject* object);
static gchar* ___lambda85__hdy_combo_row_get_name_func (GObject* item,
                                                 gpointer self);
static void pamac_preferences_window_on_parallel_downloads_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_parallel_downloads_comborow_changed_g_object_notify (GObject* _sender,
                                                                                       GParamSpec* pspec,
                                                                                       gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda86_ (Block2Data* _data2_,
                   GObject* obj,
                   GAsyncResult* res);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda87_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void pamac_preferences_window_on_mirrors_country_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_mirrors_country_comborow_changed_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self);
static void ___lambda87__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ____lambda86__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gchar* ___lambda88_ (PamacPreferencesWindow* self,
                     GObject* object);
static gchar* ____lambda88__hdy_combo_row_get_name_func (GObject* item,
                                                  gpointer self);
static gchar* __lambda89_ (PamacPreferencesWindow* self,
                    GObject* object);
static gchar* ___lambda89__hdy_combo_row_get_name_func (GObject* item,
                                                 gpointer self);
static void pamac_preferences_window_on_cache_keep_nb_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_cache_keep_nb_comborow_changed_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void pamac_preferences_window_on_cache_only_uninstalled_button_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_cache_only_uninstalled_button_changed_g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self);
static void pamac_preferences_window_refresh_clean_cache_button (PamacPreferencesWindow* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void pamac_preferences_window_refresh_clean_cache_button_finish (PamacPreferencesWindow* self,
                                                                 GAsyncResult* _res_);
static void pamac_preferences_window_populate_ignorepkgs_list (PamacPreferencesWindow* self);
static void pamac_preferences_window_on_software_mode_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_software_mode_changed_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void pamac_preferences_window_refresh_clean_build_files_button (PamacPreferencesWindow* self,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static void pamac_preferences_window_refresh_clean_build_files_button_finish (PamacPreferencesWindow* self,
                                                                       GAsyncResult* _res_);
static void pamac_preferences_window_refresh_clean_cache_button_data_free (gpointer _data);
static gboolean pamac_preferences_window_refresh_clean_cache_button_co (PamacPreferencesWindowRefreshCleanCacheButtonData* _data_);
static void pamac_preferences_window_refresh_clean_cache_button_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static guint64* _uint64_dup (guint64* self);
static void pamac_preferences_window_refresh_clean_build_files_button_data_free (gpointer _data);
static gboolean pamac_preferences_window_refresh_clean_build_files_button_co (PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_);
static void pamac_preferences_window_on_aur_build_dir_file_chooser_clicked (PamacPreferencesWindow* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda93_ (Block4Data* _data4_,
                  gint response);
static void ___lambda93__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void _pamac_preferences_window_on_aur_build_dir_file_chooser_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                         gpointer self);
static void pamac_preferences_window_on_add_ignorepkgs_button_clicked (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_add_ignorepkgs_button_clicked_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                            GtkListBoxRow* row,
                                                                                            gpointer self);
static void pamac_preferences_window_add_ignorepkg (PamacPreferencesWindow* self,
                                             const gchar* pkgname);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda92_ (Block5Data* _data5_);
static void ___lambda92__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda90_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static void _g_free0_ (gpointer var);
static void __lambda91_ (Block6Data* _data6_,
                  gint response);
static void ___lambda91__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void ___lambda90__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void pamac_preferences_window_on_generate_mirrors_list_button_clicked (PamacPreferencesWindow* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda94_ (Block7Data* _data7_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda94__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _pamac_preferences_window_on_generate_mirrors_list_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                           gpointer self);
static void pamac_preferences_window_on_clean_cache_button_clicked (PamacPreferencesWindow* self);
static void __lambda95_ (PamacPreferencesWindow* self);
static void ___lambda95__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _pamac_preferences_window_on_clean_cache_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                 gpointer self);
static void pamac_preferences_window_on_clean_build_files_button_clicked (PamacPreferencesWindow* self);
static void __lambda96_ (PamacPreferencesWindow* self);
static void ___lambda96__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _pamac_preferences_window_on_clean_build_files_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                       gpointer self);
static void pamac_preferences_window_finalize (GObject * obj);
static GType pamac_preferences_window_get_type_once (void);

static inline gpointer
pamac_preferences_window_get_instance_private (PamacPreferencesWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PamacPreferencesWindow_private_offset);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data1_->self;
		G_IS_VALUE (&_data1_->val) ? (g_value_unset (&_data1_->val), NULL) : NULL;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar*
__lambda84_ (PamacPreferencesWindow* self,
             GObject* object)
{
	HdyValueObject* value_object = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (object != NULL, NULL);
	value_object = G_TYPE_CHECK_INSTANCE_TYPE (object, hdy_value_object_get_type ()) ? ((HdyValueObject*) object) : NULL;
	_tmp0_ = hdy_value_object_get_string (value_object);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
___lambda84__hdy_combo_row_get_name_func (GObject* item,
                                          gpointer self)
{
	gchar* result;
	result = __lambda84_ ((PamacPreferencesWindow*) self, item);
	return result;
}

static void
_pamac_preferences_window_on_check_updates_expander_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	pamac_preferences_window_on_check_updates_expander_changed ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_refresh_period_comborow_changed_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self)
{
	pamac_preferences_window_on_refresh_period_comborow_changed ((PamacPreferencesWindow*) self);
}

static gchar*
__lambda85_ (PamacPreferencesWindow* self,
             GObject* object)
{
	HdyValueObject* value_object = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (object != NULL, NULL);
	value_object = G_TYPE_CHECK_INSTANCE_TYPE (object, hdy_value_object_get_type ()) ? ((HdyValueObject*) object) : NULL;
	_tmp0_ = hdy_value_object_get_string (value_object);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
___lambda85__hdy_combo_row_get_name_func (GObject* item,
                                          gpointer self)
{
	gchar* result;
	result = __lambda85_ ((PamacPreferencesWindow*) self, item);
	return result;
}

static void
_pamac_preferences_window_on_parallel_downloads_comborow_changed_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self)
{
	pamac_preferences_window_on_parallel_downloads_comborow_changed ((PamacPreferencesWindow*) self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->mirrors_store);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data3_->_data2_->_data1_->self;
		_g_free0 (_data3_->preferences_choosen_country);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
_pamac_preferences_window_on_mirrors_country_comborow_changed_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self)
{
	pamac_preferences_window_on_mirrors_country_comborow_changed ((PamacPreferencesWindow*) self);
}

static void
__lambda87_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	Block2Data* _data2_;
	Block1Data* _data1_;
	PamacPreferencesWindow* self;
	GPtrArray* countries = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	HdyComboRow* _tmp11_;
	_data2_ = _data3_->_data2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_mirrors_countries_finish (_tmp0_, res);
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	countries = _tmp2_;
	_tmp3_ = countries;
	{
		GPtrArray* country_collection = NULL;
		guint country_index = 0U;
		country_collection = _tmp3_;
		for (country_index = 0; country_index < country_collection->len; country_index = country_index + 1) {
			const gchar* country = NULL;
			country = (const gchar*) g_ptr_array_index (country_collection, country_index);
			{
				const gchar* _tmp4_;
				GListStore* _tmp5_;
				GValue _tmp6_;
				HdyValueObject* _tmp7_;
				HdyValueObject* _tmp8_;
				const gchar* _tmp9_;
				_tmp4_ = country;
				g_value_set_string (&_data1_->val, _tmp4_);
				_tmp5_ = _data2_->mirrors_store;
				_tmp6_ = _data1_->val;
				_tmp7_ = hdy_value_object_new (&_tmp6_);
				_tmp8_ = _tmp7_;
				g_list_store_append (_tmp5_, (GObject*) _tmp8_);
				_g_object_unref0 (_tmp8_);
				_tmp9_ = country;
				if (g_strcmp0 (_tmp9_, _data3_->preferences_choosen_country) == 0) {
					HdyComboRow* _tmp10_;
					_tmp10_ = self->priv->mirrors_country_comborow;
					hdy_combo_row_set_selected_index (_tmp10_, _data2_->index);
				}
				_data2_->index += 1;
			}
		}
	}
	_tmp11_ = self->priv->mirrors_country_comborow;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::selected-index", (GCallback) _pamac_preferences_window_on_mirrors_country_comborow_changed_g_object_notify, self, 0);
	_g_ptr_array_unref0 (countries);
}

static void
___lambda87__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda87_ (self, source_object, res);
	block3_data_unref (self);
}

static void
___lambda86_ (Block2Data* _data2_,
              GObject* obj,
              GAsyncResult* res)
{
	Block1Data* _data1_;
	PamacPreferencesWindow* self;
	Block3Data* _data3_;
	PamacDatabase* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	PamacDatabase* _tmp3_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->_data2_ = block2_data_ref (_data2_);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_mirrors_choosen_country_finish (_tmp0_, res);
	_tmp2_ = g_strdup (_tmp1_);
	_data3_->preferences_choosen_country = _tmp2_;
	_tmp3_ = self->priv->database;
	pamac_database_get_mirrors_countries_async (_tmp3_, ___lambda87__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
____lambda86__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda86_ (self, source_object, res);
	block2_data_unref (self);
}

static gchar*
___lambda88_ (PamacPreferencesWindow* self,
              GObject* object)
{
	HdyValueObject* value_object = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (object != NULL, NULL);
	value_object = G_TYPE_CHECK_INSTANCE_TYPE (object, hdy_value_object_get_type ()) ? ((HdyValueObject*) object) : NULL;
	_tmp0_ = hdy_value_object_get_string (value_object);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
____lambda88__hdy_combo_row_get_name_func (GObject* item,
                                           gpointer self)
{
	gchar* result;
	result = ___lambda88_ ((PamacPreferencesWindow*) self, item);
	return result;
}

static gchar*
__lambda89_ (PamacPreferencesWindow* self,
             GObject* object)
{
	HdyValueObject* value_object = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (object != NULL, NULL);
	value_object = G_TYPE_CHECK_INSTANCE_TYPE (object, hdy_value_object_get_type ()) ? ((HdyValueObject*) object) : NULL;
	_tmp0_ = hdy_value_object_get_string (value_object);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
___lambda89__hdy_combo_row_get_name_func (GObject* item,
                                          gpointer self)
{
	gchar* result;
	result = __lambda89_ ((PamacPreferencesWindow*) self, item);
	return result;
}

static void
_pamac_preferences_window_on_cache_keep_nb_comborow_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	pamac_preferences_window_on_cache_keep_nb_comborow_changed ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_cache_only_uninstalled_button_changed_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self)
{
	pamac_preferences_window_on_cache_only_uninstalled_button_changed ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_software_mode_changed_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	pamac_preferences_window_on_software_mode_changed ((PamacPreferencesWindow*) self);
}

PamacPreferencesWindow*
pamac_preferences_window_construct (GType object_type,
                                    PamacManagerWindow* window,
                                    PamacLocalConfig* local_config)
{
	PamacPreferencesWindow * self = NULL;
	Block1Data* _data1_;
	PamacTransactionGtk* _tmp0_;
	PamacTransactionGtk* _tmp1_;
	PamacDatabase* _tmp2_;
	PamacDatabase* _tmp3_;
	PamacDatabase* _tmp4_;
	PamacConfig* _tmp5_;
	PamacConfig* _tmp6_;
	PamacLocalConfig* _tmp7_;
	GListStore* store = NULL;
	GListStore* _tmp8_;
	GValue _tmp9_ = {0};
	gchar* str = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GListStore* _tmp12_;
	GValue _tmp13_;
	HdyValueObject* _tmp14_;
	HdyValueObject* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GListStore* _tmp18_;
	GValue _tmp19_;
	HdyValueObject* _tmp20_;
	HdyValueObject* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	GListStore* _tmp24_;
	GValue _tmp25_;
	HdyValueObject* _tmp26_;
	HdyValueObject* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	GListStore* _tmp30_;
	GValue _tmp31_;
	HdyValueObject* _tmp32_;
	HdyValueObject* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	GListStore* _tmp36_;
	GValue _tmp37_;
	HdyValueObject* _tmp38_;
	HdyValueObject* _tmp39_;
	HdyComboRow* _tmp40_;
	GListStore* _tmp41_;
	PamacConfig* _tmp42_;
	guint64 _tmp43_;
	guint64 _tmp44_;
	HdyExpanderRow* _tmp58_;
	HdyComboRow* _tmp59_;
	PamacConfig* _tmp60_;
	GtkSwitch* _tmp61_;
	PamacConfig* _tmp62_;
	GtkSwitch* _tmp63_;
	PamacConfig* _tmp64_;
	GtkSwitch* _tmp65_;
	PamacConfig* _tmp66_;
	GtkSwitch* _tmp67_;
	GListStore* _tmp68_;
	gchar* _tmp69_;
	const gchar* _tmp70_;
	GListStore* _tmp71_;
	GValue _tmp72_;
	HdyValueObject* _tmp73_;
	HdyValueObject* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	GListStore* _tmp77_;
	GValue _tmp78_;
	HdyValueObject* _tmp79_;
	HdyValueObject* _tmp80_;
	gchar* _tmp81_;
	const gchar* _tmp82_;
	GListStore* _tmp83_;
	GValue _tmp84_;
	HdyValueObject* _tmp85_;
	HdyValueObject* _tmp86_;
	gchar* _tmp87_;
	const gchar* _tmp88_;
	GListStore* _tmp89_;
	GValue _tmp90_;
	HdyValueObject* _tmp91_;
	HdyValueObject* _tmp92_;
	gchar* _tmp93_;
	const gchar* _tmp94_;
	GListStore* _tmp95_;
	GValue _tmp96_;
	HdyValueObject* _tmp97_;
	HdyValueObject* _tmp98_;
	gchar* _tmp99_;
	const gchar* _tmp100_;
	GListStore* _tmp101_;
	GValue _tmp102_;
	HdyValueObject* _tmp103_;
	HdyValueObject* _tmp104_;
	HdyComboRow* _tmp105_;
	GListStore* _tmp106_;
	guint64 max_parallel_downloads = 0ULL;
	PamacConfig* _tmp107_;
	guint64 _tmp108_;
	guint64 _tmp109_;
	HdyComboRow* _tmp116_;
	PamacDatabase* _tmp117_;
	GListStore* _tmp129_;
	gchar* _tmp130_;
	const gchar* _tmp131_;
	GListStore* _tmp132_;
	GValue _tmp133_;
	HdyValueObject* _tmp134_;
	HdyValueObject* _tmp135_;
	gchar* _tmp136_;
	const gchar* _tmp137_;
	GListStore* _tmp138_;
	GValue _tmp139_;
	HdyValueObject* _tmp140_;
	HdyValueObject* _tmp141_;
	gchar* _tmp142_;
	const gchar* _tmp143_;
	GListStore* _tmp144_;
	GValue _tmp145_;
	HdyValueObject* _tmp146_;
	HdyValueObject* _tmp147_;
	gchar* _tmp148_;
	const gchar* _tmp149_;
	GListStore* _tmp150_;
	GValue _tmp151_;
	HdyValueObject* _tmp152_;
	HdyValueObject* _tmp153_;
	gchar* _tmp154_;
	const gchar* _tmp155_;
	GListStore* _tmp156_;
	GValue _tmp157_;
	HdyValueObject* _tmp158_;
	HdyValueObject* _tmp159_;
	gchar* _tmp160_;
	const gchar* _tmp161_;
	GListStore* _tmp162_;
	GValue _tmp163_;
	HdyValueObject* _tmp164_;
	HdyValueObject* _tmp165_;
	HdyComboRow* _tmp166_;
	GListStore* _tmp167_;
	guint64 keep_num_pkgs = 0ULL;
	PamacConfig* _tmp168_;
	guint64 _tmp169_;
	guint64 _tmp170_;
	HdyComboRow* _tmp173_;
	PamacConfig* _tmp174_;
	GtkSwitch* _tmp175_;
	GtkSwitch* _tmp176_;
	HdyPreferencesPage* _tmp177_;
	PamacConfig* _tmp178_;
	GtkSwitch* _tmp179_;
	PamacConfig* _tmp180_;
	GtkSwitch* _tmp181_;
	PamacConfig* _tmp182_;
	GtkSwitch* _tmp183_;
	PamacConfig* _tmp184_;
	GtkSwitch* _tmp185_;
	gboolean _tmp186_ = FALSE;
	gboolean _tmp187_ = FALSE;
	gboolean _tmp188_;
	gboolean _tmp189_;
	HdyPreferencesPage* _tmp196_;
	HdyPreferencesGroup* _tmp197_;
	PamacConfig* _tmp198_;
	HdyExpanderRow* _tmp199_;
	PamacConfig* _tmp200_;
	HdyExpanderRow* _tmp201_;
	PamacConfig* _tmp202_;
	GtkSwitch* _tmp203_;
	PamacConfig* _tmp204_;
	GtkSwitch* _tmp205_;
	PamacConfig* _tmp206_;
	GtkSwitch* _tmp207_;
	PamacConfig* _tmp208_;
	GtkSwitch* _tmp209_;
	GtkButton* _tmp210_;
	PamacConfig* _tmp211_;
	const gchar* _tmp212_;
	const gchar* _tmp213_;
	gchar* _tmp214_;
	gchar* _tmp215_;
	PamacConfig* _tmp216_;
	HdyPreferencesGroup* _tmp217_;
	PamacConfig* _tmp218_;
	HdyExpanderRow* _tmp219_;
	PamacConfig* _tmp220_;
	HdyExpanderRow* _tmp221_;
	PamacConfig* _tmp222_;
	GtkSwitch* _tmp223_;
	PamacConfig* _tmp224_;
	HdyPreferencesGroup* _tmp225_;
	PamacConfig* _tmp226_;
	GtkSwitch* _tmp227_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (local_config != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (PamacPreferencesWindow*) g_object_new (object_type, "transient-for", window, NULL);
	_data1_->self = g_object_ref (self);
	_tmp0_ = window->transaction;
	self->priv->transaction = _tmp0_;
	_tmp1_ = self->priv->transaction;
	_tmp2_ = pamac_transaction_get_database ((PamacTransaction*) _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->database = _tmp3_;
	_tmp4_ = self->priv->database;
	_tmp5_ = pamac_database_get_config (_tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->config = _tmp6_;
	_tmp7_ = window->local_config;
	local_config = _tmp7_;
	_tmp8_ = g_list_store_new (hdy_value_object_get_type ());
	store = _tmp8_;
	g_value_init (&_tmp9_, G_TYPE_STRING);
	_data1_->val = _tmp9_;
	_tmp10_ = g_strdup (g_dgettext (NULL, "every 3 hours"));
	str = _tmp10_;
	_tmp11_ = str;
	g_value_set_string (&_data1_->val, _tmp11_);
	_tmp12_ = store;
	_tmp13_ = _data1_->val;
	_tmp14_ = hdy_value_object_new (&_tmp13_);
	_tmp15_ = _tmp14_;
	g_list_store_append (_tmp12_, (GObject*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = g_strdup (g_dgettext (NULL, "every 6 hours"));
	_g_free0 (str);
	str = _tmp16_;
	_tmp17_ = str;
	g_value_set_string (&_data1_->val, _tmp17_);
	_tmp18_ = store;
	_tmp19_ = _data1_->val;
	_tmp20_ = hdy_value_object_new (&_tmp19_);
	_tmp21_ = _tmp20_;
	g_list_store_append (_tmp18_, (GObject*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = g_strdup (g_dgettext (NULL, "every 12 hours"));
	_g_free0 (str);
	str = _tmp22_;
	_tmp23_ = str;
	g_value_set_string (&_data1_->val, _tmp23_);
	_tmp24_ = store;
	_tmp25_ = _data1_->val;
	_tmp26_ = hdy_value_object_new (&_tmp25_);
	_tmp27_ = _tmp26_;
	g_list_store_append (_tmp24_, (GObject*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = g_strdup (g_dgettext (NULL, "every day"));
	_g_free0 (str);
	str = _tmp28_;
	_tmp29_ = str;
	g_value_set_string (&_data1_->val, _tmp29_);
	_tmp30_ = store;
	_tmp31_ = _data1_->val;
	_tmp32_ = hdy_value_object_new (&_tmp31_);
	_tmp33_ = _tmp32_;
	g_list_store_append (_tmp30_, (GObject*) _tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = g_strdup (g_dgettext (NULL, "every week"));
	_g_free0 (str);
	str = _tmp34_;
	_tmp35_ = str;
	g_value_set_string (&_data1_->val, _tmp35_);
	_tmp36_ = store;
	_tmp37_ = _data1_->val;
	_tmp38_ = hdy_value_object_new (&_tmp37_);
	_tmp39_ = _tmp38_;
	g_list_store_append (_tmp36_, (GObject*) _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = self->priv->refresh_period_comborow;
	_tmp41_ = store;
	hdy_combo_row_bind_name_model (_tmp40_, (GListModel*) _tmp41_, ___lambda84__hdy_combo_row_get_name_func, g_object_ref (self), g_object_unref);
	_tmp42_ = self->priv->config;
	_tmp43_ = pamac_config_get_refresh_period (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ == ((guint64) 0)) {
		HdyExpanderRow* _tmp45_;
		HdyExpanderRow* _tmp46_;
		HdyComboRow* _tmp47_;
		_tmp45_ = self->priv->check_updates_expander;
		hdy_expander_row_set_enable_expansion (_tmp45_, FALSE);
		_tmp46_ = self->priv->check_updates_expander;
		hdy_expander_row_set_expanded (_tmp46_, FALSE);
		_tmp47_ = self->priv->refresh_period_comborow;
		hdy_combo_row_set_selected_index (_tmp47_, 1);
		self->priv->previous_refresh_period = (guint64) 6;
	} else {
		HdyExpanderRow* _tmp48_;
		HdyExpanderRow* _tmp49_;
		guint64 refresh_period = 0ULL;
		PamacConfig* _tmp50_;
		guint64 _tmp51_;
		guint64 _tmp52_;
		_tmp48_ = self->priv->check_updates_expander;
		hdy_expander_row_set_enable_expansion (_tmp48_, TRUE);
		_tmp49_ = self->priv->check_updates_expander;
		hdy_expander_row_set_expanded (_tmp49_, TRUE);
		_tmp50_ = self->priv->config;
		_tmp51_ = pamac_config_get_refresh_period (_tmp50_);
		_tmp52_ = _tmp51_;
		refresh_period = _tmp52_;
		if (refresh_period <= ((guint64) 3)) {
			HdyComboRow* _tmp53_;
			_tmp53_ = self->priv->refresh_period_comborow;
			hdy_combo_row_set_selected_index (_tmp53_, 0);
		} else {
			if (refresh_period <= ((guint64) 6)) {
				HdyComboRow* _tmp54_;
				_tmp54_ = self->priv->refresh_period_comborow;
				hdy_combo_row_set_selected_index (_tmp54_, 1);
			} else {
				if (refresh_period <= ((guint64) 12)) {
					HdyComboRow* _tmp55_;
					_tmp55_ = self->priv->refresh_period_comborow;
					hdy_combo_row_set_selected_index (_tmp55_, 2);
				} else {
					if (refresh_period <= ((guint64) 24)) {
						HdyComboRow* _tmp56_;
						_tmp56_ = self->priv->refresh_period_comborow;
						hdy_combo_row_set_selected_index (_tmp56_, 3);
					} else {
						HdyComboRow* _tmp57_;
						_tmp57_ = self->priv->refresh_period_comborow;
						hdy_combo_row_set_selected_index (_tmp57_, 4);
					}
				}
			}
		}
	}
	_tmp58_ = self->priv->check_updates_expander;
	g_signal_connect_object ((GObject*) _tmp58_, "notify::enable-expansion", (GCallback) _pamac_preferences_window_on_check_updates_expander_changed_g_object_notify, self, 0);
	_tmp59_ = self->priv->refresh_period_comborow;
	g_signal_connect_object ((GObject*) _tmp59_, "notify::selected-index", (GCallback) _pamac_preferences_window_on_refresh_period_comborow_changed_g_object_notify, self, 0);
	_tmp60_ = self->priv->config;
	_tmp61_ = self->priv->download_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp60_, "download_updates", (GObject*) _tmp61_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp62_ = self->priv->config;
	_tmp63_ = self->priv->offline_upgrade_button;
	g_object_bind_property_with_closures ((GObject*) _tmp62_, "offline_upgrade", (GObject*) _tmp63_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp64_ = self->priv->config;
	_tmp65_ = self->priv->offline_upgrade_button;
	g_object_bind_property_with_closures ((GObject*) _tmp64_, "download_updates", (GObject*) _tmp65_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp66_ = self->priv->config;
	_tmp67_ = self->priv->no_update_hide_icon_button;
	g_object_bind_property_with_closures ((GObject*) _tmp66_, "no_update_hide_icon", (GObject*) _tmp67_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp68_ = g_list_store_new (hdy_value_object_get_type ());
	_g_object_unref0 (store);
	store = _tmp68_;
	_tmp69_ = g_strdup (g_dgettext (NULL, "1"));
	_g_free0 (str);
	str = _tmp69_;
	_tmp70_ = str;
	g_value_set_string (&_data1_->val, _tmp70_);
	_tmp71_ = store;
	_tmp72_ = _data1_->val;
	_tmp73_ = hdy_value_object_new (&_tmp72_);
	_tmp74_ = _tmp73_;
	g_list_store_append (_tmp71_, (GObject*) _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = g_strdup (g_dgettext (NULL, "2"));
	_g_free0 (str);
	str = _tmp75_;
	_tmp76_ = str;
	g_value_set_string (&_data1_->val, _tmp76_);
	_tmp77_ = store;
	_tmp78_ = _data1_->val;
	_tmp79_ = hdy_value_object_new (&_tmp78_);
	_tmp80_ = _tmp79_;
	g_list_store_append (_tmp77_, (GObject*) _tmp80_);
	_g_object_unref0 (_tmp80_);
	_tmp81_ = g_strdup (g_dgettext (NULL, "4"));
	_g_free0 (str);
	str = _tmp81_;
	_tmp82_ = str;
	g_value_set_string (&_data1_->val, _tmp82_);
	_tmp83_ = store;
	_tmp84_ = _data1_->val;
	_tmp85_ = hdy_value_object_new (&_tmp84_);
	_tmp86_ = _tmp85_;
	g_list_store_append (_tmp83_, (GObject*) _tmp86_);
	_g_object_unref0 (_tmp86_);
	_tmp87_ = g_strdup (g_dgettext (NULL, "6"));
	_g_free0 (str);
	str = _tmp87_;
	_tmp88_ = str;
	g_value_set_string (&_data1_->val, _tmp88_);
	_tmp89_ = store;
	_tmp90_ = _data1_->val;
	_tmp91_ = hdy_value_object_new (&_tmp90_);
	_tmp92_ = _tmp91_;
	g_list_store_append (_tmp89_, (GObject*) _tmp92_);
	_g_object_unref0 (_tmp92_);
	_tmp93_ = g_strdup (g_dgettext (NULL, "8"));
	_g_free0 (str);
	str = _tmp93_;
	_tmp94_ = str;
	g_value_set_string (&_data1_->val, _tmp94_);
	_tmp95_ = store;
	_tmp96_ = _data1_->val;
	_tmp97_ = hdy_value_object_new (&_tmp96_);
	_tmp98_ = _tmp97_;
	g_list_store_append (_tmp95_, (GObject*) _tmp98_);
	_g_object_unref0 (_tmp98_);
	_tmp99_ = g_strdup (g_dgettext (NULL, "10"));
	_g_free0 (str);
	str = _tmp99_;
	_tmp100_ = str;
	g_value_set_string (&_data1_->val, _tmp100_);
	_tmp101_ = store;
	_tmp102_ = _data1_->val;
	_tmp103_ = hdy_value_object_new (&_tmp102_);
	_tmp104_ = _tmp103_;
	g_list_store_append (_tmp101_, (GObject*) _tmp104_);
	_g_object_unref0 (_tmp104_);
	_tmp105_ = self->priv->parallel_downloads_comborow;
	_tmp106_ = store;
	hdy_combo_row_bind_name_model (_tmp105_, (GListModel*) _tmp106_, ___lambda85__hdy_combo_row_get_name_func, g_object_ref (self), g_object_unref);
	_tmp107_ = self->priv->config;
	_tmp108_ = pamac_config_get_max_parallel_downloads (_tmp107_);
	_tmp109_ = _tmp108_;
	max_parallel_downloads = _tmp109_;
	if (max_parallel_downloads <= ((guint64) 1)) {
		HdyComboRow* _tmp110_;
		_tmp110_ = self->priv->parallel_downloads_comborow;
		hdy_combo_row_set_selected_index (_tmp110_, 0);
	} else {
		if (max_parallel_downloads <= ((guint64) 2)) {
			HdyComboRow* _tmp111_;
			_tmp111_ = self->priv->parallel_downloads_comborow;
			hdy_combo_row_set_selected_index (_tmp111_, 1);
		} else {
			if (max_parallel_downloads <= ((guint64) 4)) {
				HdyComboRow* _tmp112_;
				_tmp112_ = self->priv->parallel_downloads_comborow;
				hdy_combo_row_set_selected_index (_tmp112_, 2);
			} else {
				if (max_parallel_downloads <= ((guint64) 6)) {
					HdyComboRow* _tmp113_;
					_tmp113_ = self->priv->parallel_downloads_comborow;
					hdy_combo_row_set_selected_index (_tmp113_, 3);
				} else {
					if (max_parallel_downloads <= ((guint64) 8)) {
						HdyComboRow* _tmp114_;
						_tmp114_ = self->priv->parallel_downloads_comborow;
						hdy_combo_row_set_selected_index (_tmp114_, 4);
					} else {
						HdyComboRow* _tmp115_;
						_tmp115_ = self->priv->parallel_downloads_comborow;
						hdy_combo_row_set_selected_index (_tmp115_, 5);
					}
				}
			}
		}
	}
	_tmp116_ = self->priv->parallel_downloads_comborow;
	g_signal_connect_object ((GObject*) _tmp116_, "notify::selected-index", (GCallback) _pamac_preferences_window_on_parallel_downloads_comborow_changed_g_object_notify, self, 0);
	_tmp117_ = self->priv->database;
	if (pamac_database_has_installed_satisfier (_tmp117_, "pacman-mirrors")) {
		Block2Data* _data2_;
		GListStore* _tmp118_;
		gchar* _tmp119_;
		const gchar* _tmp120_;
		GListStore* _tmp121_;
		GValue _tmp122_;
		HdyValueObject* _tmp123_;
		HdyValueObject* _tmp124_;
		PamacDatabase* _tmp125_;
		HdyComboRow* _tmp126_;
		GListStore* _tmp127_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp118_ = g_list_store_new (hdy_value_object_get_type ());
		_data2_->mirrors_store = _tmp118_;
		_tmp119_ = g_strdup (g_dgettext (NULL, "Worldwide"));
		_g_free0 (str);
		str = _tmp119_;
		_tmp120_ = str;
		g_value_set_string (&_data1_->val, _tmp120_);
		_tmp121_ = _data2_->mirrors_store;
		_tmp122_ = _data1_->val;
		_tmp123_ = hdy_value_object_new (&_tmp122_);
		_tmp124_ = _tmp123_;
		g_list_store_append (_tmp121_, (GObject*) _tmp124_);
		_g_object_unref0 (_tmp124_);
		_data2_->index = 1;
		_tmp125_ = self->priv->database;
		pamac_database_get_mirrors_choosen_country_async (_tmp125_, ____lambda86__gasync_ready_callback, block2_data_ref (_data2_));
		_tmp126_ = self->priv->mirrors_country_comborow;
		_tmp127_ = _data2_->mirrors_store;
		hdy_combo_row_bind_name_model (_tmp126_, (GListModel*) _tmp127_, ____lambda88__hdy_combo_row_get_name_func, g_object_ref (self), g_object_unref);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	} else {
		HdyPreferencesGroup* _tmp128_;
		_tmp128_ = self->priv->mirrors_preferences_group;
		gtk_widget_set_visible ((GtkWidget*) _tmp128_, FALSE);
	}
	_tmp129_ = g_list_store_new (hdy_value_object_get_type ());
	_g_object_unref0 (store);
	store = _tmp129_;
	_tmp130_ = g_strdup (g_dgettext (NULL, "0"));
	_g_free0 (str);
	str = _tmp130_;
	_tmp131_ = str;
	g_value_set_string (&_data1_->val, _tmp131_);
	_tmp132_ = store;
	_tmp133_ = _data1_->val;
	_tmp134_ = hdy_value_object_new (&_tmp133_);
	_tmp135_ = _tmp134_;
	g_list_store_append (_tmp132_, (GObject*) _tmp135_);
	_g_object_unref0 (_tmp135_);
	_tmp136_ = g_strdup (g_dgettext (NULL, "1"));
	_g_free0 (str);
	str = _tmp136_;
	_tmp137_ = str;
	g_value_set_string (&_data1_->val, _tmp137_);
	_tmp138_ = store;
	_tmp139_ = _data1_->val;
	_tmp140_ = hdy_value_object_new (&_tmp139_);
	_tmp141_ = _tmp140_;
	g_list_store_append (_tmp138_, (GObject*) _tmp141_);
	_g_object_unref0 (_tmp141_);
	_tmp142_ = g_strdup (g_dgettext (NULL, "2"));
	_g_free0 (str);
	str = _tmp142_;
	_tmp143_ = str;
	g_value_set_string (&_data1_->val, _tmp143_);
	_tmp144_ = store;
	_tmp145_ = _data1_->val;
	_tmp146_ = hdy_value_object_new (&_tmp145_);
	_tmp147_ = _tmp146_;
	g_list_store_append (_tmp144_, (GObject*) _tmp147_);
	_g_object_unref0 (_tmp147_);
	_tmp148_ = g_strdup (g_dgettext (NULL, "3"));
	_g_free0 (str);
	str = _tmp148_;
	_tmp149_ = str;
	g_value_set_string (&_data1_->val, _tmp149_);
	_tmp150_ = store;
	_tmp151_ = _data1_->val;
	_tmp152_ = hdy_value_object_new (&_tmp151_);
	_tmp153_ = _tmp152_;
	g_list_store_append (_tmp150_, (GObject*) _tmp153_);
	_g_object_unref0 (_tmp153_);
	_tmp154_ = g_strdup (g_dgettext (NULL, "4"));
	_g_free0 (str);
	str = _tmp154_;
	_tmp155_ = str;
	g_value_set_string (&_data1_->val, _tmp155_);
	_tmp156_ = store;
	_tmp157_ = _data1_->val;
	_tmp158_ = hdy_value_object_new (&_tmp157_);
	_tmp159_ = _tmp158_;
	g_list_store_append (_tmp156_, (GObject*) _tmp159_);
	_g_object_unref0 (_tmp159_);
	_tmp160_ = g_strdup (g_dgettext (NULL, "5"));
	_g_free0 (str);
	str = _tmp160_;
	_tmp161_ = str;
	g_value_set_string (&_data1_->val, _tmp161_);
	_tmp162_ = store;
	_tmp163_ = _data1_->val;
	_tmp164_ = hdy_value_object_new (&_tmp163_);
	_tmp165_ = _tmp164_;
	g_list_store_append (_tmp162_, (GObject*) _tmp165_);
	_g_object_unref0 (_tmp165_);
	_tmp166_ = self->priv->cache_keep_nb_comborow;
	_tmp167_ = store;
	hdy_combo_row_bind_name_model (_tmp166_, (GListModel*) _tmp167_, ___lambda89__hdy_combo_row_get_name_func, g_object_ref (self), g_object_unref);
	_tmp168_ = self->priv->config;
	_tmp169_ = pamac_config_get_clean_keep_num_pkgs (_tmp168_);
	_tmp170_ = _tmp169_;
	keep_num_pkgs = _tmp170_;
	if (keep_num_pkgs < ((guint64) 6)) {
		HdyComboRow* _tmp171_;
		_tmp171_ = self->priv->cache_keep_nb_comborow;
		hdy_combo_row_set_selected_index (_tmp171_, (gint) keep_num_pkgs);
	} else {
		HdyComboRow* _tmp172_;
		_tmp172_ = self->priv->cache_keep_nb_comborow;
		hdy_combo_row_set_selected_index (_tmp172_, 5);
	}
	_tmp173_ = self->priv->cache_keep_nb_comborow;
	g_signal_connect_object ((GObject*) _tmp173_, "notify::selected-index", (GCallback) _pamac_preferences_window_on_cache_keep_nb_comborow_changed_g_object_notify, self, 0);
	_tmp174_ = self->priv->config;
	_tmp175_ = self->priv->cache_only_uninstalled_button;
	g_object_bind_property_with_closures ((GObject*) _tmp174_, "clean_rm_only_uninstalled", (GObject*) _tmp175_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp176_ = self->priv->cache_only_uninstalled_button;
	g_signal_connect_object ((GObject*) _tmp176_, "notify::active", (GCallback) _pamac_preferences_window_on_cache_only_uninstalled_button_changed_g_object_notify, self, 0);
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
	_tmp177_ = self->priv->advanced_preferences_page;
	g_object_bind_property_with_closures ((GObject*) local_config, "software_mode", (GObject*) _tmp177_, "visible", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp178_ = self->priv->config;
	_tmp179_ = self->priv->check_space_button;
	g_object_bind_property_with_closures ((GObject*) _tmp178_, "checkspace", (GObject*) _tmp179_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp180_ = self->priv->config;
	_tmp181_ = self->priv->remove_unrequired_deps_button;
	g_object_bind_property_with_closures ((GObject*) _tmp180_, "recurse", (GObject*) _tmp181_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp182_ = self->priv->config;
	_tmp183_ = self->priv->simple_install_button;
	g_object_bind_property_with_closures ((GObject*) _tmp182_, "simple_install", (GObject*) _tmp183_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp184_ = self->priv->config;
	_tmp185_ = self->priv->enable_downgrade_button;
	g_object_bind_property_with_closures ((GObject*) _tmp184_, "enable_downgrade", (GObject*) _tmp185_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	pamac_preferences_window_populate_ignorepkgs_list (self);
	_tmp188_ = pamac_local_config_get_software_mode (local_config);
	_tmp189_ = _tmp188_;
	if (!_tmp189_) {
		_tmp187_ = TRUE;
	} else {
		PamacConfig* _tmp190_;
		gboolean _tmp191_;
		gboolean _tmp192_;
		_tmp190_ = self->priv->config;
		_tmp191_ = pamac_config_get_support_flatpak (_tmp190_);
		_tmp192_ = _tmp191_;
		_tmp187_ = _tmp192_;
	}
	if (_tmp187_) {
		_tmp186_ = TRUE;
	} else {
		PamacConfig* _tmp193_;
		gboolean _tmp194_;
		gboolean _tmp195_;
		_tmp193_ = self->priv->config;
		_tmp194_ = pamac_config_get_support_snap (_tmp193_);
		_tmp195_ = _tmp194_;
		_tmp186_ = _tmp195_;
	}
	_tmp196_ = self->priv->third_party_preferences_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp196_, _tmp186_);
	g_signal_connect_object ((GObject*) local_config, "notify::software-mode", (GCallback) _pamac_preferences_window_on_software_mode_changed_g_object_notify, self, 0);
	_tmp197_ = self->priv->aur_preferences_group;
	g_object_bind_property_with_closures ((GObject*) local_config, "software_mode", (GObject*) _tmp197_, "visible", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp198_ = self->priv->config;
	_tmp199_ = self->priv->enable_aur_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp198_, "enable_aur", (GObject*) _tmp199_, "enable_expansion", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp200_ = self->priv->config;
	_tmp201_ = self->priv->enable_aur_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp200_, "enable_aur", (GObject*) _tmp201_, "expanded", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp202_ = self->priv->config;
	_tmp203_ = self->priv->keep_built_pkgs_button;
	g_object_bind_property_with_closures ((GObject*) _tmp202_, "keep_built_pkgs", (GObject*) _tmp203_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp204_ = self->priv->config;
	_tmp205_ = self->priv->check_aur_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp204_, "check_aur_updates", (GObject*) _tmp205_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp206_ = self->priv->config;
	_tmp207_ = self->priv->check_aur_vcs_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp206_, "check_aur_vcs_updates", (GObject*) _tmp207_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp208_ = self->priv->config;
	_tmp209_ = self->priv->check_aur_vcs_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp208_, "check_aur_updates", (GObject*) _tmp209_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp210_ = self->priv->aur_build_dir_file_chooser;
	_tmp211_ = self->priv->config;
	_tmp212_ = pamac_config_get_aur_build_dir (_tmp211_);
	_tmp213_ = _tmp212_;
	_tmp214_ = g_path_get_basename (_tmp213_);
	_tmp215_ = _tmp214_;
	gtk_button_set_label (_tmp210_, _tmp215_);
	_g_free0 (_tmp215_);
	pamac_preferences_window_refresh_clean_build_files_button (self, NULL, NULL);
	_tmp216_ = self->priv->config;
	_tmp217_ = self->priv->flatpak_preferences_group;
	g_object_bind_property_with_closures ((GObject*) _tmp216_, "support_flatpak", (GObject*) _tmp217_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp218_ = self->priv->config;
	_tmp219_ = self->priv->enable_flatpak_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp218_, "enable_flatpak", (GObject*) _tmp219_, "enable_expansion", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp220_ = self->priv->config;
	_tmp221_ = self->priv->enable_flatpak_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp220_, "enable_flatpak", (GObject*) _tmp221_, "expanded", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp222_ = self->priv->config;
	_tmp223_ = self->priv->check_flatpak_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp222_, "check_flatpak_updates", (GObject*) _tmp223_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp224_ = self->priv->config;
	_tmp225_ = self->priv->snap_preferences_group;
	g_object_bind_property_with_closures ((GObject*) _tmp224_, "support_snap", (GObject*) _tmp225_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp226_ = self->priv->config;
	_tmp227_ = self->priv->enable_snap_button;
	g_object_bind_property_with_closures ((GObject*) _tmp226_, "enable_snap", (GObject*) _tmp227_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_free0 (str);
	_g_object_unref0 (store);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

PamacPreferencesWindow*
pamac_preferences_window_new (PamacManagerWindow* window,
                              PamacLocalConfig* local_config)
{
	return pamac_preferences_window_construct (PAMAC_TYPE_PREFERENCES_WINDOW, window, local_config);
}

static void
pamac_preferences_window_refresh_clean_cache_button_data_free (gpointer _data)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacPreferencesWindowRefreshCleanCacheButtonData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pamac_preferences_window_refresh_clean_cache_button (PamacPreferencesWindow* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	PamacPreferencesWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PamacPreferencesWindowRefreshCleanCacheButtonData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_preferences_window_refresh_clean_cache_button_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pamac_preferences_window_refresh_clean_cache_button_co (_data_);
}

static void
pamac_preferences_window_refresh_clean_cache_button_finish (PamacPreferencesWindow* self,
                                                            GAsyncResult* _res_)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
pamac_preferences_window_refresh_clean_cache_button_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pamac_preferences_window_refresh_clean_cache_button_co (_data_);
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

static gboolean
pamac_preferences_window_refresh_clean_cache_button_co (PamacPreferencesWindowRefreshCleanCacheButtonData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->database;
	_data_->_state_ = 1;
	pamac_database_get_clean_cache_details_async (_data_->_tmp0_, pamac_preferences_window_refresh_clean_cache_button_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = pamac_database_get_clean_cache_details_finish (_data_->_tmp0_, _data_->_res_);
	_data_->details = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->details;
	g_hash_table_iter_init (&_data_->iter, _data_->_tmp2_);
	_data_->total_size = (guint64) 0;
	_data_->files_nb = (guint) 0;
	while (TRUE) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp4_ = g_hash_table_iter_next (&_data_->iter, (gpointer*) NULL, (gpointer*) (&_data_->_tmp3_));
		_g_free0 (_data_->size);
		_data_->_tmp5_ = __uint64_dup0 ((guint64*) _data_->_tmp3_);
		_data_->size = _data_->_tmp5_;
		if (!_data_->_tmp4_) {
			break;
		}
		_data_->_tmp6_ = _data_->size;
		_data_->total_size += *_data_->_tmp6_;
		_data_->_tmp7_ = _data_->files_nb;
		_data_->files_nb = _data_->_tmp7_ + 1;
	}
	_data_->_tmp8_ = _data_->self->priv->clean_cache_label;
	_data_->_tmp9_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) _data_->files_nb), _data_->files_nb);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_format_size_full (_data_->total_size, G_FORMAT_SIZE_DEFAULT);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("<b>%s:  %s  (%s)</b>", g_dgettext (NULL, "To delete"), _data_->_tmp10_, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	gtk_label_set_markup (_data_->_tmp8_, _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp16_ = _data_->files_nb;
	_data_->files_nb = _data_->_tmp16_ + 1;
	if (_data_->_tmp16_ > ((guint) 0)) {
		_data_->_tmp15_ = !_data_->self->priv->transaction_running;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp17_ = _data_->self->priv->clean_cache_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp17_, TRUE);
	} else {
		_data_->_tmp18_ = _data_->self->priv->clean_cache_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp18_, FALSE);
	}
	_g_free0 (_data_->size);
	_g_hash_table_unref0 (_data_->details);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_preferences_window_refresh_clean_build_files_button_data_free (gpointer _data)
{
	PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacPreferencesWindowRefreshCleanBuildFilesButtonData, _data_);
}

static void
pamac_preferences_window_refresh_clean_build_files_button (PamacPreferencesWindow* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_;
	PamacPreferencesWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PamacPreferencesWindowRefreshCleanBuildFilesButtonData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_preferences_window_refresh_clean_build_files_button_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pamac_preferences_window_refresh_clean_build_files_button_co (_data_);
}

static void
pamac_preferences_window_refresh_clean_build_files_button_finish (PamacPreferencesWindow* self,
                                                                  GAsyncResult* _res_)
{
	PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
pamac_preferences_window_refresh_clean_build_files_button_co (PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->database;
	_data_->_tmp1_ = pamac_database_get_build_files_details (_data_->_tmp0_);
	_data_->details = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->details;
	g_hash_table_iter_init (&_data_->iter, _data_->_tmp2_);
	_data_->total_size = (guint64) 0;
	_data_->files_nb = (guint) 0;
	while (TRUE) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp4_ = g_hash_table_iter_next (&_data_->iter, (gpointer*) NULL, (gpointer*) (&_data_->_tmp3_));
		_g_free0 (_data_->size);
		_data_->_tmp5_ = __uint64_dup0 ((guint64*) _data_->_tmp3_);
		_data_->size = _data_->_tmp5_;
		if (!_data_->_tmp4_) {
			break;
		}
		_data_->_tmp6_ = _data_->size;
		_data_->total_size += *_data_->_tmp6_;
		_data_->_tmp7_ = _data_->files_nb;
		_data_->files_nb = _data_->_tmp7_ + 1;
	}
	_data_->_tmp8_ = _data_->self->priv->clean_build_files_label;
	_data_->_tmp9_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) _data_->files_nb), _data_->files_nb);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_format_size_full (_data_->total_size, G_FORMAT_SIZE_DEFAULT);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("<b>%s:  %s  (%s)</b>", g_dgettext (NULL, "To delete"), _data_->_tmp10_, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	gtk_label_set_markup (_data_->_tmp8_, _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp16_ = _data_->files_nb;
	_data_->files_nb = _data_->_tmp16_ + 1;
	if (_data_->_tmp16_ > ((guint) 0)) {
		_data_->_tmp15_ = !_data_->self->priv->transaction_running;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp17_ = _data_->self->priv->clean_build_files_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp17_, TRUE);
	} else {
		_data_->_tmp18_ = _data_->self->priv->clean_build_files_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp18_, FALSE);
	}
	_g_free0 (_data_->size);
	_g_hash_table_unref0 (_data_->details);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_preferences_window_on_check_updates_expander_changed (PamacPreferencesWindow* self)
{
	HdyExpanderRow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->check_updates_expander;
	_tmp1_ = hdy_expander_row_get_enable_expansion (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PamacConfig* _tmp3_;
		_tmp3_ = self->priv->config;
		pamac_config_set_refresh_period (_tmp3_, self->priv->previous_refresh_period);
	} else {
		PamacConfig* _tmp4_;
		guint64 _tmp5_;
		guint64 _tmp6_;
		PamacConfig* _tmp7_;
		_tmp4_ = self->priv->config;
		_tmp5_ = pamac_config_get_refresh_period (_tmp4_);
		_tmp6_ = _tmp5_;
		self->priv->previous_refresh_period = _tmp6_;
		_tmp7_ = self->priv->config;
		pamac_config_set_refresh_period (_tmp7_, (guint64) 0);
	}
}

static void
pamac_preferences_window_on_refresh_period_comborow_changed (PamacPreferencesWindow* self)
{
	gint index = 0;
	HdyComboRow* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->refresh_period_comborow;
	_tmp1_ = hdy_combo_row_get_selected_index (_tmp0_);
	_tmp2_ = _tmp1_;
	index = _tmp2_;
	if (index == 0) {
		PamacConfig* _tmp3_;
		_tmp3_ = self->priv->config;
		pamac_config_set_refresh_period (_tmp3_, (guint64) 3);
	} else {
		if (index == 1) {
			PamacConfig* _tmp4_;
			_tmp4_ = self->priv->config;
			pamac_config_set_refresh_period (_tmp4_, (guint64) 6);
		} else {
			if (index == 2) {
				PamacConfig* _tmp5_;
				_tmp5_ = self->priv->config;
				pamac_config_set_refresh_period (_tmp5_, (guint64) 12);
			} else {
				if (index == 3) {
					PamacConfig* _tmp6_;
					_tmp6_ = self->priv->config;
					pamac_config_set_refresh_period (_tmp6_, (guint64) 24);
				} else {
					PamacConfig* _tmp7_;
					_tmp7_ = self->priv->config;
					pamac_config_set_refresh_period (_tmp7_, (guint64) 168);
				}
			}
		}
	}
}

static void
pamac_preferences_window_on_parallel_downloads_comborow_changed (PamacPreferencesWindow* self)
{
	gint index = 0;
	HdyComboRow* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parallel_downloads_comborow;
	_tmp1_ = hdy_combo_row_get_selected_index (_tmp0_);
	_tmp2_ = _tmp1_;
	index = _tmp2_;
	if (index == 0) {
		PamacConfig* _tmp3_;
		_tmp3_ = self->priv->config;
		pamac_config_set_max_parallel_downloads (_tmp3_, (guint64) 1);
	} else {
		if (index == 1) {
			PamacConfig* _tmp4_;
			_tmp4_ = self->priv->config;
			pamac_config_set_max_parallel_downloads (_tmp4_, (guint64) 2);
		} else {
			if (index == 2) {
				PamacConfig* _tmp5_;
				_tmp5_ = self->priv->config;
				pamac_config_set_max_parallel_downloads (_tmp5_, (guint64) 4);
			} else {
				if (index == 3) {
					PamacConfig* _tmp6_;
					_tmp6_ = self->priv->config;
					pamac_config_set_max_parallel_downloads (_tmp6_, (guint64) 6);
				} else {
					if (index == 4) {
						PamacConfig* _tmp7_;
						_tmp7_ = self->priv->config;
						pamac_config_set_max_parallel_downloads (_tmp7_, (guint64) 8);
					} else {
						PamacConfig* _tmp8_;
						_tmp8_ = self->priv->config;
						pamac_config_set_max_parallel_downloads (_tmp8_, (guint64) 10);
					}
				}
			}
		}
	}
}

static void
pamac_preferences_window_on_cache_keep_nb_comborow_changed (PamacPreferencesWindow* self)
{
	PamacConfig* _tmp0_;
	HdyComboRow* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->config;
	_tmp1_ = self->priv->cache_keep_nb_comborow;
	_tmp2_ = hdy_combo_row_get_selected_index (_tmp1_);
	_tmp3_ = _tmp2_;
	pamac_config_set_clean_keep_num_pkgs (_tmp0_, (guint64) _tmp3_);
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
}

static void
pamac_preferences_window_on_cache_only_uninstalled_button_changed (PamacPreferencesWindow* self)
{
	g_return_if_fail (self != NULL);
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
}

static void
pamac_preferences_window_on_software_mode_changed (PamacPreferencesWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	PamacLocalConfig* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	HdyPreferencesPage* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->local_config;
	_tmp3_ = pamac_local_config_get_software_mode (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		PamacConfig* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->config;
		_tmp6_ = pamac_config_get_support_flatpak (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		PamacConfig* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->config;
		_tmp9_ = pamac_config_get_support_snap (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	}
	_tmp11_ = self->priv->third_party_preferences_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, _tmp0_);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda93_ (Block4Data* _data4_,
             gint response)
{
	PamacPreferencesWindow* self;
	GtkFileChooserDialog* _tmp10_;
	self = _data4_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile* choosen_dir = NULL;
		GtkFileChooserDialog* _tmp0_;
		GFile* _tmp1_;
		GtkButton* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		PamacConfig* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp0_ = _data4_->chooser;
		_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
		choosen_dir = _tmp1_;
		_tmp2_ = self->priv->aur_build_dir_file_chooser;
		_tmp3_ = choosen_dir;
		_tmp4_ = g_file_get_basename (_tmp3_);
		_tmp5_ = _tmp4_;
		gtk_button_set_label (_tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->config;
		_tmp7_ = choosen_dir;
		_tmp8_ = g_file_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		pamac_config_set_aur_build_dir (_tmp6_, _tmp9_);
		_g_free0 (_tmp9_);
		pamac_preferences_window_refresh_clean_build_files_button (self, NULL, NULL);
		_g_object_unref0 (choosen_dir);
	}
	_tmp10_ = _data4_->chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	gtk_widget_show ((GtkWidget*) self);
}

static void
___lambda93__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda93_ (self, response_id);
}

static void
pamac_preferences_window_on_aur_build_dir_file_chooser_clicked (PamacPreferencesWindow* self)
{
	Block4Data* _data4_;
	GtkFileChooserDialog* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	gchar* default_build_dir = NULL;
	gchar* _tmp2_;
	const gchar* config_build_dir = NULL;
	PamacConfig* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkFileChooserDialog* _tmp16_;
	GtkFileChooserDialog* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (g_dgettext (NULL, "Select Build Directory"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, g_dgettext (NULL, "_Cancel"), GTK_RESPONSE_CANCEL, g_dgettext (NULL, "_Choose"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp0_);
	_data4_->chooser = _tmp0_;
	_tmp1_ = _data4_->chooser;
	gtk_window_set_icon_name ((GtkWindow*) _tmp1_, "system-software-install");
	_tmp2_ = g_strdup ("/var/tmp");
	default_build_dir = _tmp2_;
	_tmp3_ = self->priv->config;
	_tmp4_ = pamac_config_get_aur_build_dir (_tmp3_);
	_tmp5_ = _tmp4_;
	config_build_dir = _tmp5_;
	{
		GtkFileChooserDialog* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GtkFileChooserDialog* _tmp12_;
		const gchar* _tmp13_;
		_tmp6_ = _data4_->chooser;
		_tmp7_ = default_build_dir;
		gtk_file_chooser_add_shortcut_folder ((GtkFileChooser*) _tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = config_build_dir;
		_tmp9_ = default_build_dir;
		if (g_strcmp0 (_tmp8_, _tmp9_) != 0) {
			GtkFileChooserDialog* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = _data4_->chooser;
			_tmp11_ = config_build_dir;
			gtk_file_chooser_add_shortcut_folder ((GtkFileChooser*) _tmp10_, _tmp11_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_tmp12_ = _data4_->chooser;
		_tmp13_ = config_build_dir;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp12_, _tmp13_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("preferences_dialog.vala:392: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (default_build_dir);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp16_ = _data4_->chooser;
	g_signal_connect_data ((GtkDialog*) _tmp16_, "response", (GCallback) ___lambda93__gtk_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp17_ = _data4_->chooser;
	gtk_widget_show ((GtkWidget*) _tmp17_);
	_g_free0 (default_build_dir);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
_pamac_preferences_window_on_aur_build_dir_file_chooser_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                    gpointer self)
{
	pamac_preferences_window_on_aur_build_dir_file_chooser_clicked ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_add_ignorepkgs_button_clicked_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                       GtkListBoxRow* row,
                                                                                       gpointer self)
{
	pamac_preferences_window_on_add_ignorepkgs_button_clicked ((PamacPreferencesWindow*) self);
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
pamac_preferences_window_populate_ignorepkgs_list (PamacPreferencesWindow* self)
{
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkListBox* _tmp7_;
	GtkImage* _tmp8_;
	GtkListBox* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = image;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = image;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp2_, 12);
	_tmp3_ = image;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 12);
	_tmp4_ = image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 12);
	_tmp5_ = image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 12);
	_tmp6_ = image;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	_tmp7_ = self->priv->ignorepkgs_listbox;
	_tmp8_ = image;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->ignorepkgs_listbox;
	g_signal_connect_object (_tmp9_, "row-activated", (GCallback) _pamac_preferences_window_on_add_ignorepkgs_button_clicked_gtk_list_box_row_activated, self, 0);
	{
		GHashTableIter _ignorepkg_it = {0};
		PamacConfig* _tmp10_;
		GHashTable* _tmp11_;
		GHashTable* _tmp12_;
		GHashTableIter _tmp13_ = {0};
		const gchar* ignorepkg = NULL;
		_tmp10_ = self->priv->config;
		_tmp11_ = pamac_config_get_ignorepkgs (_tmp10_);
		_tmp12_ = _tmp11_;
		g_hash_table_iter_init (&_tmp13_, _tmp12_);
		_ignorepkg_it = _tmp13_;
		while (TRUE) {
			gconstpointer _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp14_ = _vala_hash_set_next_value (&_ignorepkg_it);
			ignorepkg = (const gchar*) _tmp14_;
			_tmp15_ = ignorepkg;
			if (!(_tmp15_ != NULL)) {
				break;
			}
			_tmp16_ = ignorepkg;
			pamac_preferences_window_add_ignorepkg (self, _tmp16_);
		}
	}
	_g_object_unref0 (image);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->row);
		_g_free0 (_data5_->pkgname);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda92_ (Block5Data* _data5_)
{
	PamacPreferencesWindow* self;
	PamacConfig* _tmp0_;
	self = _data5_->self;
	gtk_widget_destroy ((GtkWidget*) _data5_->row);
	_tmp0_ = self->priv->config;
	pamac_config_remove_ignorepkg (_tmp0_, _data5_->pkgname);
}

static void
___lambda92__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda92_ (self);
}

static void
pamac_preferences_window_add_ignorepkg (PamacPreferencesWindow* self,
                                        const gchar* pkgname)
{
	Block5Data* _data5_;
	gchar* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkBox* box = NULL;
	GtkBox* _tmp2_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp3_;
	GtkButton* button = NULL;
	GtkButton* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkListBox* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgname != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_strdup (pkgname);
	_g_free0 (_data5_->pkgname);
	_data5_->pkgname = _tmp0_;
	_tmp1_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp1_);
	_data5_->row = _tmp1_;
	gtk_widget_set_visible ((GtkWidget*) _data5_->row, TRUE);
	gtk_list_box_row_set_activatable (_data5_->row, FALSE);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp2_);
	box = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) box, TRUE);
	_tmp3_ = (GtkLabel*) gtk_label_new (_data5_->pkgname);
	g_object_ref_sink (_tmp3_);
	label = _tmp3_;
	gtk_widget_set_visible ((GtkWidget*) label, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) label, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 12);
	gtk_widget_set_margin_start ((GtkWidget*) label, 12);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) label, TRUE);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) label);
	_tmp4_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp4_);
	button = _tmp4_;
	gtk_widget_set_visible ((GtkWidget*) button, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) button, 12);
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	gtk_widget_set_valign ((GtkWidget*) button, GTK_ALIGN_CENTER);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("list-remove-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_button_set_image (button, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	g_signal_connect_data (button, "clicked", (GCallback) ___lambda92__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) button);
	gtk_container_add ((GtkContainer*) _data5_->row, (GtkWidget*) box);
	_tmp7_ = self->priv->ignorepkgs_listbox;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _data5_->row);
	_g_object_unref0 (button);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->choose_pkgs_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
__lambda91_ (Block6Data* _data6_,
             gint response)
{
	PamacPreferencesWindow* self;
	self = _data6_->self;
	if (response == ((gint) GTK_RESPONSE_OK)) {
		GPtrArray* _tmp0_;
		_tmp0_ = pamac_choose_pkgs_dialog_get_selected_pkgs (_data6_->choose_pkgs_dialog);
		{
			GPtrArray* pkgname_collection = NULL;
			guint pkgname_index = 0U;
			pkgname_collection = _tmp0_;
			for (pkgname_index = 0; pkgname_index < pkgname_collection->len; pkgname_index = pkgname_index + 1) {
				const gchar* pkgname = NULL;
				pkgname = (const gchar*) g_ptr_array_index (pkgname_collection, pkgname_index);
				{
					PamacConfig* _tmp1_;
					const gchar* _tmp2_;
					const gchar* _tmp3_;
					_tmp1_ = self->priv->config;
					_tmp2_ = pkgname;
					pamac_config_add_ignorepkg (_tmp1_, _tmp2_);
					_tmp3_ = pkgname;
					pamac_preferences_window_add_ignorepkg (self, _tmp3_);
				}
			}
			_g_ptr_array_unref0 (pkgname_collection);
		}
	}
	gtk_widget_destroy ((GtkWidget*) _data6_->choose_pkgs_dialog);
}

static void
___lambda91__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda91_ (self, response_id);
}

static void
__lambda90_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacPreferencesWindow* self;
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	GHashTable* ignorepkgs_unique = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GPtrArray* _tmp5_;
	GtkButton* _tmp19_;
	GdkWindow* _tmp20_;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_installed_pkgs_finish (_tmp0_, res);
	pkgs = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_free0_);
	ignorepkgs_unique = _tmp4_;
	_tmp5_ = pkgs;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = _tmp5_;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacPackage* pkg = NULL;
			pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
			{
				const gchar* pkgname = NULL;
				PamacPackage* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GHashTable* _tmp9_;
				const gchar* _tmp10_;
				PamacConfig* _tmp11_;
				GHashTable* _tmp12_;
				GHashTable* _tmp13_;
				const gchar* _tmp14_;
				GHashTable* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp6_ = pkg;
				_tmp7_ = pamac_package_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				pkgname = _tmp8_;
				_tmp9_ = ignorepkgs_unique;
				_tmp10_ = pkgname;
				if (g_hash_table_contains (_tmp9_, _tmp10_)) {
					continue;
				}
				_tmp11_ = self->priv->config;
				_tmp12_ = pamac_config_get_ignorepkgs (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = pkgname;
				if (g_hash_table_contains (_tmp13_, _tmp14_)) {
					continue;
				}
				_tmp15_ = ignorepkgs_unique;
				_tmp16_ = pkgname;
				_tmp17_ = g_strdup (_tmp16_);
				g_hash_table_add (_tmp15_, _tmp17_);
				_tmp18_ = pkgname;
				pamac_choose_pkgs_dialog_add_pkg (_data6_->choose_pkgs_dialog, _tmp18_);
			}
		}
	}
	_tmp19_ = _data6_->choose_pkgs_dialog->cancel_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
	_tmp20_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp20_, NULL);
	g_signal_connect_data ((GtkDialog*) _data6_->choose_pkgs_dialog, "response", (GCallback) ___lambda91__gtk_dialog_response, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	pamac_choose_pkgs_dialog_enable_search (_data6_->choose_pkgs_dialog);
	gtk_widget_show ((GtkWidget*) _data6_->choose_pkgs_dialog);
	_g_hash_table_unref0 (ignorepkgs_unique);
	_g_ptr_array_unref0 (pkgs);
}

static void
___lambda90__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda90_ (self, source_object, res);
	block6_data_unref (self);
}

static void
pamac_preferences_window_on_add_ignorepkgs_button_clicked (PamacPreferencesWindow* self)
{
	Block6Data* _data6_;
	PamacTransactionGtk* _tmp0_;
	PamacChoosePkgsDialog* _tmp1_;
	GdkWindow* _tmp2_;
	GdkDisplay* _tmp3_;
	GdkCursor* _tmp4_;
	GdkCursor* _tmp5_;
	PamacDatabase* _tmp6_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->priv->transaction;
	_tmp1_ = pamac_transaction_gtk_create_choose_pkgs_dialog (_tmp0_);
	_data6_->choose_pkgs_dialog = _tmp1_;
	gtk_window_set_title ((GtkWindow*) _data6_->choose_pkgs_dialog, g_dgettext (NULL, "Choose Ignored Upgrades"));
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp3_ = gdk_display_get_default ();
	_tmp4_ = gdk_cursor_new_for_display (_tmp3_, GDK_WATCH);
	_tmp5_ = _tmp4_;
	gdk_window_set_cursor (_tmp2_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->database;
	pamac_database_get_installed_pkgs_async (_tmp6_, ___lambda90__gasync_ready_callback, block6_data_ref (_data6_));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
pamac_preferences_window_on_mirrors_country_comborow_changed (PamacPreferencesWindow* self)
{
	GtkButton* _tmp0_;
	GtkStyleContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->generate_mirrors_list_button;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda94_ (Block7Data* _data7_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacPreferencesWindow* self;
	PamacManagerWindow* _tmp0_;
	PamacTransactionGtk* _tmp1_;
	GtkButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	self = _data7_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data7_->manager_window;
	_tmp0_->generate_mirrors_list = FALSE;
	_tmp1_ = self->priv->transaction;
	pamac_transaction_gtk_reset_progress_box (_tmp1_);
	_tmp2_ = self->priv->generate_mirrors_list_button;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
}

static void
___lambda94__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda94_ (self, source_object, res);
	block7_data_unref (self);
}

static void
pamac_preferences_window_on_generate_mirrors_list_button_clicked (PamacPreferencesWindow* self)
{
	Block7Data* _data7_;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	PamacManagerWindow* _tmp3_;
	GListModel* model = NULL;
	HdyComboRow* _tmp5_;
	GListModel* _tmp6_;
	GObject* object = NULL;
	GListModel* _tmp7_;
	HdyComboRow* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GObject* _tmp11_;
	HdyValueObject* value_object = NULL;
	GObject* _tmp12_;
	gchar* preferences_choosen_country = NULL;
	HdyValueObject* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	PamacTransactionGtk* _tmp17_;
	PamacManagerWindow* _tmp18_;
	PamacManagerWindow* _tmp19_;
	PamacManagerWindow* _tmp20_;
	GtkButton* _tmp21_;
	PamacManagerWindow* _tmp22_;
	GtkButton* _tmp23_;
	PamacManagerWindow* _tmp24_;
	GtkRevealer* _tmp25_;
	PamacTransactionGtk* _tmp26_;
	const gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = gtk_window_get_transient_for ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_data7_->manager_window = PAMAC_IS_MANAGER_WINDOW (_tmp1_) ? ((PamacManagerWindow*) _tmp1_) : NULL;
	_tmp3_ = _data7_->manager_window;
	if (_tmp3_->transaction_running) {
		_tmp2_ = TRUE;
	} else {
		PamacManagerWindow* _tmp4_;
		_tmp4_ = _data7_->manager_window;
		_tmp2_ = _tmp4_->generate_mirrors_list;
	}
	if (_tmp2_) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp5_ = self->priv->mirrors_country_comborow;
	_tmp6_ = hdy_combo_row_get_model (_tmp5_);
	model = _tmp6_;
	_tmp7_ = model;
	_tmp8_ = self->priv->mirrors_country_comborow;
	_tmp9_ = hdy_combo_row_get_selected_index (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_list_model_get_item (_tmp7_, (guint) _tmp10_);
	object = _tmp11_;
	_tmp12_ = object;
	value_object = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, hdy_value_object_get_type ()) ? ((HdyValueObject*) _tmp12_) : NULL;
	_tmp13_ = value_object;
	_tmp14_ = hdy_value_object_dup_string (_tmp13_);
	preferences_choosen_country = _tmp14_;
	_tmp15_ = preferences_choosen_country;
	if (g_strcmp0 (_tmp15_, g_dgettext (NULL, "Worldwide")) == 0) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("all");
		_g_free0 (preferences_choosen_country);
		preferences_choosen_country = _tmp16_;
	}
	_tmp17_ = self->priv->transaction;
	pamac_transaction_gtk_start_progressbar_pulse (_tmp17_);
	_tmp18_ = _data7_->manager_window;
	_tmp18_->important_details = TRUE;
	_tmp19_ = _data7_->manager_window;
	_tmp19_->generate_mirrors_list = TRUE;
	_tmp20_ = _data7_->manager_window;
	_tmp21_ = _tmp20_->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, FALSE);
	_tmp22_ = _data7_->manager_window;
	_tmp23_ = _tmp22_->details_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = _data7_->manager_window;
	_tmp25_ = _tmp24_->infobox_revealer;
	gtk_revealer_set_reveal_child (_tmp25_, TRUE);
	_tmp26_ = self->priv->transaction;
	_tmp27_ = preferences_choosen_country;
	pamac_transaction_generate_mirrors_list_async ((PamacTransaction*) _tmp26_, _tmp27_, ___lambda94__gasync_ready_callback, block7_data_ref (_data7_));
	_g_free0 (preferences_choosen_country);
	_g_object_unref0 (object);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
_pamac_preferences_window_on_generate_mirrors_list_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                      gpointer self)
{
	pamac_preferences_window_on_generate_mirrors_list_button_clicked ((PamacPreferencesWindow*) self);
}

static void
__lambda95_ (PamacPreferencesWindow* self)
{
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
}

static void
___lambda95__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda95_ ((PamacPreferencesWindow*) self);
	g_object_unref (self);
}

static void
pamac_preferences_window_on_clean_cache_button_clicked (PamacPreferencesWindow* self)
{
	PamacTransactionGtk* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->transaction;
	pamac_transaction_clean_cache_async ((PamacTransaction*) _tmp0_, ___lambda95__gasync_ready_callback, g_object_ref (self));
}

static void
_pamac_preferences_window_on_clean_cache_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self)
{
	pamac_preferences_window_on_clean_cache_button_clicked ((PamacPreferencesWindow*) self);
}

static void
__lambda96_ (PamacPreferencesWindow* self)
{
	pamac_preferences_window_refresh_clean_build_files_button (self, NULL, NULL);
}

static void
___lambda96__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda96_ ((PamacPreferencesWindow*) self);
	g_object_unref (self);
}

static void
pamac_preferences_window_on_clean_build_files_button_clicked (PamacPreferencesWindow* self)
{
	PamacTransactionGtk* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->transaction;
	pamac_transaction_clean_build_files_async ((PamacTransaction*) _tmp0_, ___lambda96__gasync_ready_callback, g_object_ref (self));
}

static void
_pamac_preferences_window_on_clean_build_files_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self)
{
	pamac_preferences_window_on_clean_build_files_button_clicked ((PamacPreferencesWindow*) self);
}

static void
pamac_preferences_window_class_init (PamacPreferencesWindowClass * klass,
                                     gpointer klass_data)
{
	pamac_preferences_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacPreferencesWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_preferences_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/manjaro/pamac/preferences/preferences_dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_updates_expander", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_updates_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "refresh_period_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, refresh_period_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "no_update_hide_icon_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, no_update_hide_icon_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "download_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, download_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "offline_upgrade_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, offline_upgrade_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "parallel_downloads_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, parallel_downloads_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mirrors_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, mirrors_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mirrors_country_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, mirrors_country_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "generate_mirrors_list_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, generate_mirrors_list_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cache_keep_nb_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, cache_keep_nb_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cache_only_uninstalled_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, cache_only_uninstalled_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_cache_label", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_cache_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_cache_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_cache_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "advanced_preferences_page", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, advanced_preferences_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_space_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_space_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_unrequired_deps_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, remove_unrequired_deps_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "simple_install_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, simple_install_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_downgrade_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_downgrade_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ignorepkgs_listbox", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, ignorepkgs_listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "third_party_preferences_page", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, third_party_preferences_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aur_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, aur_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_aur_expander", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_aur_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aur_build_dir_file_chooser", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, aur_build_dir_file_chooser));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "keep_built_pkgs_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, keep_built_pkgs_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_aur_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_aur_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_aur_vcs_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_aur_vcs_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_build_files_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_build_files_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_build_files_label", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_build_files_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "flatpak_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, flatpak_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_flatpak_expander", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_flatpak_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_flatpak_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_flatpak_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "snap_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, snap_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_snap_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_snap_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_aur_build_dir_file_chooser_clicked", G_CALLBACK(_pamac_preferences_window_on_aur_build_dir_file_chooser_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_generate_mirrors_list_button_clicked", G_CALLBACK(_pamac_preferences_window_on_generate_mirrors_list_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clean_cache_button_clicked", G_CALLBACK(_pamac_preferences_window_on_clean_cache_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clean_build_files_button_clicked", G_CALLBACK(_pamac_preferences_window_on_clean_build_files_button_clicked_gtk_button_clicked));
}

static void
pamac_preferences_window_instance_init (PamacPreferencesWindow * self,
                                        gpointer klass)
{
	self->priv = pamac_preferences_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pamac_preferences_window_finalize (GObject * obj)
{
	PamacPreferencesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindow);
	G_OBJECT_CLASS (pamac_preferences_window_parent_class)->finalize (obj);
}

static GType
pamac_preferences_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacPreferencesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_preferences_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacPreferencesWindow), 0, (GInstanceInitFunc) pamac_preferences_window_instance_init, NULL };
	GType pamac_preferences_window_type_id;
	pamac_preferences_window_type_id = g_type_register_static (hdy_preferences_window_get_type (), "PamacPreferencesWindow", &g_define_type_info, 0);
	PamacPreferencesWindow_private_offset = g_type_add_instance_private (pamac_preferences_window_type_id, sizeof (PamacPreferencesWindowPrivate));
	return pamac_preferences_window_type_id;
}

GType
pamac_preferences_window_get_type (void)
{
	static volatile gsize pamac_preferences_window_type_id__once = 0;
	if (g_once_init_enter (&pamac_preferences_window_type_id__once)) {
		GType pamac_preferences_window_type_id;
		pamac_preferences_window_type_id = pamac_preferences_window_get_type_once ();
		g_once_init_leave (&pamac_preferences_window_type_id__once, pamac_preferences_window_type_id);
	}
	return pamac_preferences_window_type_id__once;
}

