/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.zopfli;

import net.sourceforge.plantuml.zopfli.Cookie;

class Katajainen {
    Katajainen() {
    }

    static void lengthLimitedCodeLengths(Cookie cookie, int[] frequencies, int maxBits, int[] bitLengths) {
        cookie.resetPool();
        int n = frequencies.length;
        int nn = 0;
        Cookie.Node[] leaves = cookie.leaves1;
        for (int i = 0; i < n; ++i) {
            if (frequencies[i] == 0) continue;
            leaves[nn] = cookie.node(frequencies[i], i, null);
            ++nn;
        }
        if (nn == 0) {
            return;
        }
        if (nn == 1) {
            bitLengths[leaves[0].count] = 1;
            return;
        }
        Cookie.Node[] leaves2 = cookie.leaves2;
        System.arraycopy(leaves, 0, leaves2, 0, nn);
        Katajainen.sort(leaves2, leaves, 0, nn);
        Cookie.Node[] list0 = cookie.list0;
        Cookie.Node node0 = cookie.node(leaves[0].weight, 1, null);
        Cookie.Node[] list1 = cookie.list1;
        Cookie.Node node1 = cookie.node(leaves[1].weight, 2, null);
        for (int i = 0; i < maxBits; ++i) {
            list0[i] = node0;
            list1[i] = node1;
        }
        int numBoundaryPmRuns = 2 * nn - 4;
        for (int i = 0; i < numBoundaryPmRuns; ++i) {
            boolean last = i == numBoundaryPmRuns - 1;
            Katajainen.boundaryPm(cookie, leaves, list0, list1, nn, maxBits - 1, last);
        }
        Cookie.Node node = list1[maxBits - 1];
        while (node != null) {
            for (int i = node.count - 1; i >= 0; --i) {
                int n2 = leaves[i].count;
                bitLengths[n2] = bitLengths[n2] + 1;
            }
            node = node.tail;
        }
    }

    private static void boundaryPm(Cookie cookie, Cookie.Node[] leaves, Cookie.Node[] list0, Cookie.Node[] list1, int numSymbols, int index, boolean last) {
        int lastCount = list1[index].count;
        if (index == 0 && lastCount >= numSymbols) {
            return;
        }
        list0[index] = list1[index];
        if (index == 0) {
            list1[index] = cookie.node(leaves[lastCount].weight, lastCount + 1, null);
        } else {
            int sum = list0[index - 1].weight + list1[index - 1].weight;
            if (lastCount < numSymbols && sum > leaves[lastCount].weight) {
                list1[index] = cookie.node(leaves[lastCount].weight, lastCount + 1, list1[index].tail);
            } else {
                list1[index] = cookie.node(sum, lastCount, list1[index - 1]);
                if (!last) {
                    Katajainen.boundaryPm(cookie, leaves, list0, list1, numSymbols, index - 1, false);
                    Katajainen.boundaryPm(cookie, leaves, list0, list1, numSymbols, index - 1, false);
                }
            }
        }
    }

    private static void sort(Cookie.Node[] src, Cookie.Node[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low + 1; i < high; ++i) {
                int j = i;
                int k = i - 1;
                while (j > low && dest[k].weight > dest[j].weight) {
                    Cookie.Node t2 = dest[j];
                    dest[j] = dest[k];
                    dest[k] = t2;
                    --j;
                    --k;
                }
            }
            return;
        }
        int mid = low + high >>> 1;
        Katajainen.sort(dest, src, low, mid);
        Katajainen.sort(dest, src, mid, high);
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p].weight <= src[q].weight ? src[p++] : src[q++];
        }
    }
}

