// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const process = require('node:process');

// Each code must be unique.
const CODES = {
	COMMONJS_PLUGINS: '001',
	COMMONJS_NODEJS_API: '002',
	RESULT_OUTPUT_PROPERTY: '003',
	GITHUB_FORMATTER: '004',
	CONTEXT_FIX: '005',
	RULE: '006', // either removal or renaming
	REPORT_AMBIGUOUS_POSITION: '007',
};

const emittedWarnings = new Set();

/**
 * Use this function for deprecation warnings, instead of `process.emitWarning()`.
 *
 * @param {string} message
 * @param {keyof CODES} codeKey
 * @param {string} detail
 * @returns {void}
 */
function emitDeprecationWarning(message, codeKey, detail) {
	const code = CODES[codeKey];

	const key = JSON.stringify({
		message,
		options: { type: 'DeprecationWarning', code: `stylelint:${code}`, detail },
	});

	if (emittedWarnings.has(key)) return;

	emittedWarnings.add(key);

	process.emitWarning(message, { type: 'DeprecationWarning', code: `stylelint:${code}`, detail });
}

/**
 * Clear the already emitted deprecation warnings.
 * Only useful in tests.
 *
 * @private
 */
function clearEmittedDeprecationWarnings() {
	emittedWarnings.clear();
}

exports.clearEmittedDeprecationWarnings = clearEmittedDeprecationWarnings;
exports.default = emitDeprecationWarning;
