/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JavaCompiler
extends Compiler {
    private final Log log = LogFactory.getLog(JavaCompiler.class);

    @Override
    protected void generateClass(Map<String, SmapStratum> map) throws JasperException, IOException {
        JavacErrorDetail[] javacErrorDetailArray;
        long l = 0L;
        if (this.log.isDebugEnabled()) {
            l = System.currentTimeMillis();
        }
        javax.tools.JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(diagnosticCollector, null, Charset.forName(this.ctxt.getOptions().getJavaEncoding()));
        ArrayList<File> arrayList = new ArrayList<File>(1);
        arrayList.add(new File(this.ctxt.getServletJavaFileName()));
        Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(Collections.unmodifiableList(arrayList));
        ArrayList<String> arrayList2 = new ArrayList<String>(6);
        arrayList2.add("-classpath");
        arrayList2.add(this.ctxt.getClassPath());
        arrayList2.add("-source");
        arrayList2.add(this.ctxt.getOptions().getCompilerSourceVM());
        arrayList2.add("-target");
        arrayList2.add(this.ctxt.getOptions().getCompilerTargetVM());
        List<String> list = Collections.unmodifiableList(arrayList2);
        Boolean bl = javaCompiler.getTask(null, standardJavaFileManager, diagnosticCollector, list, null, iterable).call();
        ArrayList<JavacErrorDetail> arrayList3 = new ArrayList<JavacErrorDetail>();
        if (!bl.booleanValue()) {
            javacErrorDetailArray = diagnosticCollector.getDiagnostics().iterator();
            while (javacErrorDetailArray.hasNext()) {
                Diagnostic diagnostic = javacErrorDetailArray.next();
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                try {
                    arrayList3.add(ErrorDispatcher.createJavacError(((JavaFileObject)diagnostic.getSource()).getName(), this.pageNodes, new StringBuilder(diagnostic.getMessage(Locale.getDefault())), (int)diagnostic.getLineNumber(), this.ctxt));
                }
                catch (JasperException jasperException) {
                    this.log.error((Object)Localizer.getMessage("jsp.error.compilation.jdtProblemError"), (Throwable)((Object)jasperException));
                }
            }
        }
        if (!this.ctxt.keepGenerated() && !(javacErrorDetailArray = new File(this.ctxt.getServletJavaFileName())).delete()) {
            throw new JasperException(Localizer.getMessage("jsp.warning.compiler.javafile.delete.fail", new Object[]{javacErrorDetailArray}));
        }
        if (!arrayList3.isEmpty()) {
            javacErrorDetailArray = arrayList3.toArray(new JavacErrorDetail[0]);
            this.errDispatcher.javacError(javacErrorDetailArray);
        }
        if (this.log.isDebugEnabled()) {
            long l2 = System.currentTimeMillis();
            this.log.debug((Object)Localizer.getMessage("jsp.compiled", this.ctxt.getServletJavaFileName(), l2 - l));
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(map);
        }
    }
}

