# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoComment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'url': 'str',
        'text': 'str',
        'thread_id': 'int',
        'in_reply_to_comment_id': 'int',
        'video_id': 'int',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'total_replies_from_video_author': 'int',
        'total_replies': 'int',
        'account': 'Account'
    }

    attribute_map = {
        'id': 'id',
        'url': 'url',
        'text': 'text',
        'thread_id': 'threadId',
        'in_reply_to_comment_id': 'inReplyToCommentId',
        'video_id': 'videoId',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'total_replies_from_video_author': 'totalRepliesFromVideoAuthor',
        'total_replies': 'totalReplies',
        'account': 'account'
    }

    def __init__(self, id=None, url=None, text=None, thread_id=None, in_reply_to_comment_id=None, video_id=None, created_at=None, updated_at=None, total_replies_from_video_author=None, total_replies=None, account=None, local_vars_configuration=None):  # noqa: E501
        """VideoComment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._url = None
        self._text = None
        self._thread_id = None
        self._in_reply_to_comment_id = None
        self._video_id = None
        self._created_at = None
        self._updated_at = None
        self._total_replies_from_video_author = None
        self._total_replies = None
        self._account = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if url is not None:
            self.url = url
        if text is not None:
            self.text = text
        if thread_id is not None:
            self.thread_id = thread_id
        if in_reply_to_comment_id is not None:
            self.in_reply_to_comment_id = in_reply_to_comment_id
        if video_id is not None:
            self.video_id = video_id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if total_replies_from_video_author is not None:
            self.total_replies_from_video_author = total_replies_from_video_author
        if total_replies is not None:
            self.total_replies = total_replies
        if account is not None:
            self.account = account

    @property
    def id(self):
        """Gets the id of this VideoComment.  # noqa: E501


        :return: The id of this VideoComment.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VideoComment.


        :param id: The id of this VideoComment.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def url(self):
        """Gets the url of this VideoComment.  # noqa: E501


        :return: The url of this VideoComment.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this VideoComment.


        :param url: The url of this VideoComment.  # noqa: E501
        :type url: str
        """

        self._url = url

    @property
    def text(self):
        """Gets the text of this VideoComment.  # noqa: E501


        :return: The text of this VideoComment.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this VideoComment.


        :param text: The text of this VideoComment.  # noqa: E501
        :type text: str
        """

        self._text = text

    @property
    def thread_id(self):
        """Gets the thread_id of this VideoComment.  # noqa: E501


        :return: The thread_id of this VideoComment.  # noqa: E501
        :rtype: int
        """
        return self._thread_id

    @thread_id.setter
    def thread_id(self, thread_id):
        """Sets the thread_id of this VideoComment.


        :param thread_id: The thread_id of this VideoComment.  # noqa: E501
        :type thread_id: int
        """

        self._thread_id = thread_id

    @property
    def in_reply_to_comment_id(self):
        """Gets the in_reply_to_comment_id of this VideoComment.  # noqa: E501


        :return: The in_reply_to_comment_id of this VideoComment.  # noqa: E501
        :rtype: int
        """
        return self._in_reply_to_comment_id

    @in_reply_to_comment_id.setter
    def in_reply_to_comment_id(self, in_reply_to_comment_id):
        """Sets the in_reply_to_comment_id of this VideoComment.


        :param in_reply_to_comment_id: The in_reply_to_comment_id of this VideoComment.  # noqa: E501
        :type in_reply_to_comment_id: int
        """

        self._in_reply_to_comment_id = in_reply_to_comment_id

    @property
    def video_id(self):
        """Gets the video_id of this VideoComment.  # noqa: E501


        :return: The video_id of this VideoComment.  # noqa: E501
        :rtype: int
        """
        return self._video_id

    @video_id.setter
    def video_id(self, video_id):
        """Sets the video_id of this VideoComment.


        :param video_id: The video_id of this VideoComment.  # noqa: E501
        :type video_id: int
        """

        self._video_id = video_id

    @property
    def created_at(self):
        """Gets the created_at of this VideoComment.  # noqa: E501


        :return: The created_at of this VideoComment.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this VideoComment.


        :param created_at: The created_at of this VideoComment.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this VideoComment.  # noqa: E501


        :return: The updated_at of this VideoComment.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this VideoComment.


        :param updated_at: The updated_at of this VideoComment.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def total_replies_from_video_author(self):
        """Gets the total_replies_from_video_author of this VideoComment.  # noqa: E501


        :return: The total_replies_from_video_author of this VideoComment.  # noqa: E501
        :rtype: int
        """
        return self._total_replies_from_video_author

    @total_replies_from_video_author.setter
    def total_replies_from_video_author(self, total_replies_from_video_author):
        """Sets the total_replies_from_video_author of this VideoComment.


        :param total_replies_from_video_author: The total_replies_from_video_author of this VideoComment.  # noqa: E501
        :type total_replies_from_video_author: int
        """

        self._total_replies_from_video_author = total_replies_from_video_author

    @property
    def total_replies(self):
        """Gets the total_replies of this VideoComment.  # noqa: E501


        :return: The total_replies of this VideoComment.  # noqa: E501
        :rtype: int
        """
        return self._total_replies

    @total_replies.setter
    def total_replies(self, total_replies):
        """Sets the total_replies of this VideoComment.


        :param total_replies: The total_replies of this VideoComment.  # noqa: E501
        :type total_replies: int
        """

        self._total_replies = total_replies

    @property
    def account(self):
        """Gets the account of this VideoComment.  # noqa: E501


        :return: The account of this VideoComment.  # noqa: E501
        :rtype: Account
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this VideoComment.


        :param account: The account of this VideoComment.  # noqa: E501
        :type account: Account
        """

        self._account = account

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoComment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoComment):
            return True

        return self.to_dict() != other.to_dict()
