# toggle_row.py
#
# Copyright 2025 Hari Rana / TheEvilSkeleton <theevilskeleton@riseup.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Gtk, GObject

from refine.widgets.action_row import ActionRow


class ToggleRow(ActionRow):
    __gtype_name__ = "ToggleRow"

    active = GObject.Property(type=bool, default=False)
    is_default = GObject.Property(type=bool, default=True)

    def _update_accessible_state(self) -> None:
        self.update_state(
            *zip(  # type: ignore [arg-type]
                (Gtk.AccessibleState.CHECKED, int(self.active)),
            )
        )

    def do_setup(self) -> None:
        self.props.accessible_role = Gtk.AccessibleRole.SWITCH
        self._update_accessible_state()

    def do_update(self) -> None:
        self._update_accessible_state()
