/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.VersionHelper;
import cc.arduino.contributions.libraries.ContributedLibraryDependency;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import processing.app.I18n;
import processing.app.packages.UserLibrary;

public class ContributedLibrary
extends DownloadableContribution {
    private String url;
    private String version;
    private String checksum;
    private long size;
    private String archiveFileName;
    private String name;
    private String maintainer;
    private String author;
    private String website;
    private String category;
    private String licence;
    private String paragraph;
    private String sentence;
    private ArrayList<String> architectures;
    private ArrayList<String> types;
    private ArrayList<ContributedLibraryDependency> dependencies;
    private ArrayList<String> providesIncludes;
    public static final Comparator<ContributedLibrary> CASE_INSENSITIVE_ORDER = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    private Optional<UserLibrary> installedLib = Optional.empty();

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public String getName() {
        return this.name;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getLicense() {
        return this.licence;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public String getSentence() {
        return this.sentence;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<ContributedLibraryDependency> getDependencies() {
        return this.dependencies;
    }

    public List<String> getProvidesIncludes() {
        return this.providesIncludes;
    }

    public Optional<UserLibrary> getInstalledLibrary() {
        return this.installedLib;
    }

    public boolean isLibraryInstalled() {
        return this.installedLib.isPresent();
    }

    public void setInstalledUserLibrary(UserLibrary installed) {
        this.installedLib = Optional.of(installed);
    }

    public void unsetInstalledUserLibrary() {
        this.installedLib = Optional.empty();
    }

    public boolean isIDEBuiltIn() {
        if (!this.installedLib.isPresent()) {
            return false;
        }
        return this.installedLib.get().isIDEBuiltIn();
    }

    public boolean supportsArchitecture(String reqArch) {
        return this.getArchitectures().contains(reqArch) || this.getArchitectures().contains("*");
    }

    public boolean supportsArchitecture(List<String> reqArchs) {
        if (reqArchs.contains("*")) {
            return true;
        }
        for (String reqArch : reqArchs) {
            if (!this.supportsArchitecture(reqArch)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return I18n.format(I18n.tr("Version {0}"), this.getParsedVersion());
    }

    public String info() {
        String res = "";
        res = res + "  ContributedLibrary : " + this.getName() + "\n";
        res = res + "              author : " + this.getAuthor() + "\n";
        res = res + "          maintainer : " + this.getMaintainer() + "\n";
        res = res + "             version : " + this.getParsedVersion() + "\n";
        res = res + "             website : " + this.getUrl() + "\n";
        res = res + "            category : " + this.getCategory() + "\n";
        res = res + "             license : " + this.getLicense() + "\n";
        res = res + "             descrip : " + this.getSentence() + "\n";
        if (this.getParagraph() != null && !this.getParagraph().isEmpty()) {
            res = res + "                       " + this.getParagraph() + "\n";
        }
        res = res + "       architectures : ";
        if (this.getArchitectures() != null) {
            for (String a : this.getArchitectures()) {
                res = res + a + ",";
            }
        }
        res = res + "\n";
        res = res + "            requires :\n";
        if (this.getDependencies() != null) {
            for (ContributedLibraryDependency r : this.getDependencies()) {
                res = res + "                       " + r;
            }
        }
        res = res + "\n";
        res = res + super.toString();
        return res;
    }

    public boolean equals(Object obj) {
        boolean versionEquals;
        if (!(obj instanceof ContributedLibrary)) {
            return false;
        }
        ContributedLibrary other = (ContributedLibrary)obj;
        String thisVersion = this.getParsedVersion();
        String otherVersion = other.getParsedVersion();
        boolean bl = versionEquals = thisVersion != null && thisVersion.equals(otherVersion);
        if (thisVersion == null && otherVersion == null) {
            versionEquals = true;
        }
        String thisName = this.getName();
        String otherName = other.getName();
        boolean nameEquals = thisName != null && thisName.equals(otherName);
        return versionEquals && nameEquals;
    }

    public boolean isBefore(ContributedLibrary other) {
        return VersionHelper.compare(this.getVersion(), other.getVersion()) < 0;
    }

    public int hashCode() {
        String hashingData = "CONTRIBUTEDLIB" + this.getName() + this.getVersion();
        return hashingData.hashCode();
    }
}

