/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class NationSummaryMessage
extends ObjectMessage {
    public static final String TAG = "nationSummary";
    private static final String PLAYER_TAG = "player";

    public NationSummaryMessage(Player player, NationSummary nationSummary) {
        super(TAG, PLAYER_TAG, player.getId());
        this.appendChild(nationSummary);
    }

    public NationSummaryMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG);
        NationSummary ns = null;
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if (TAG.equals(tag)) {
                if (ns == null) {
                    ns = xr.readFreeColObject(game, NationSummary.class);
                } else {
                    this.expected(TAG, tag);
                }
            } else {
                this.expected(TAG, tag);
            }
            xr.expectTag(tag);
        }
        xr.expectTag(TAG);
        this.appendChild(ns);
    }

    private Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }

    private NationSummary getNationSummary() {
        return this.getChild(0, NationSummary.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        Player other = this.getPlayer(freeColServer.getGame());
        NationSummary ns = this.getNationSummary();
        aiPlayer.nationSummaryHandler(other, ns);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player other = this.getPlayer(game);
        NationSummary ns = this.getNationSummary();
        this.igc(freeColClient).nationSummaryHandler(other, ns);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        ServerGame game = freeColServer.getGame();
        Player player = this.getPlayer(game);
        if (player == null) {
            return serverPlayer.clientError("Not a player: " + this.getStringAttribute(PLAYER_TAG));
        }
        if (player.isIndian() && !serverPlayer.hasContacted(player)) {
            return null;
        }
        return this.igc(freeColServer).nationSummary(serverPlayer, player);
    }
}

