/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.EnumToStringMapper;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class NodeTextWritingDirectionControlGroup
implements ControlGroup {
    static final String TEXT_DIRECTION = "textdirection";
    private static final String[] TEXT_DIRECTIONS = EnumToStringMapper.getStringValuesOf(TextWritingDirection.class);
    private RevertingProperty mSetNodeTextDirection;
    private ComboProperty mNodeTextDirection;
    private NodeTextDirectionChangeListener propertyChangeListener;

    NodeTextWritingDirectionControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeTextDirection = new RevertingProperty();
        this.mNodeTextDirection = ComboProperty.of((String)TEXT_DIRECTION, TextWritingDirection.class);
        this.propertyChangeListener = new NodeTextDirectionChangeListener(this.mSetNodeTextDirection, new IPropertyControl[]{this.mNodeTextDirection});
        this.mSetNodeTextDirection.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeTextDirection.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeTextDirection.appendToForm(formBuilder);
        this.mSetNodeTextDirection.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class NodeTextDirectionChangeListener
    extends ControlGroupChangeListener {
        public NodeTextDirectionChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setTextWritingDirection(node, enabled ? TextWritingDirection.valueOf((String)NodeTextWritingDirectionControlGroup.this.mNodeTextDirection.getValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            TextWritingDirection style = NodeStyleModel.getTextWritingDirection((NodeModel)node);
            TextWritingDirection viewStyle = styleController.getTextWritingDirection(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            NodeTextWritingDirectionControlGroup.this.mSetNodeTextDirection.setValue(style != null);
            NodeTextWritingDirectionControlGroup.this.mNodeTextDirection.setValue(viewStyle.name());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, NodeTextWritingDirectionControlGroup.this.mSetNodeTextDirection);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeTextWritingDirectionControlGroup.this.mNodeTextDirection);
        }
    }
}

