/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.calendar;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.components.calendar.JDayChooser;
import org.freeplane.core.ui.components.calendar.JMonthChooser;
import org.freeplane.core.ui.components.calendar.JTimeChooser;
import org.freeplane.core.ui.components.calendar.JYearChooser;

public class JCalendar
extends JPanel
implements PropertyChangeListener,
MouseListener {
    public static final String DATE_PROPERTY = "date";
    private static final long serialVersionUID = 1L;
    private Calendar calendar;
    private JPopupMenu calendarPopupMenu;
    private final JTimeChooser timeChooser;
    private final JDayChooser dayChooser;
    private boolean initialized = false;
    private Locale locale;
    private final JMonthChooser monthChooser;
    private final JPanel monthYearPanel;
    private final JYearChooser yearChooser;

    public static void main(String[] s) {
        JFrame frame = new JFrame("JCalendar");
        JCalendar jcalendar = new JCalendar();
        frame.getContentPane().add(jcalendar);
        frame.pack();
        frame.setVisible(true);
    }

    public JCalendar() {
        this(null, null, true, true, true);
    }

    public JCalendar(boolean monthSpinner) {
        this(null, null, monthSpinner, true, false);
    }

    public JCalendar(Calendar calendar) {
        this(null, null, true, true, false);
        this.setCalendar(calendar);
    }

    public JCalendar(Date date) {
        this(date, null, true, true, false);
    }

    public JCalendar(Date date, boolean monthSpinner) {
        this(date, null, monthSpinner, true, false);
    }

    public JCalendar(Date date, Locale locale) {
        this(date, locale, true, true, false);
    }

    public JCalendar(Date date, Locale locale, boolean monthSpinner, boolean weekOfYearVisible, boolean timeVisible) {
        this.setName("JCalendar");
        this.locale = locale;
        if (locale == null) {
            this.locale = Locale.getDefault();
        }
        this.calendar = Calendar.getInstance();
        this.setLayout(new BorderLayout());
        this.monthYearPanel = new JPanel();
        this.monthYearPanel.setLayout(new BorderLayout());
        this.monthChooser = new JMonthChooser(monthSpinner);
        this.yearChooser = new JYearChooser();
        this.monthChooser.setYearChooser(this.yearChooser);
        this.monthYearPanel.add((Component)this.monthChooser, "West");
        this.monthYearPanel.add((Component)this.yearChooser, "Center");
        this.monthYearPanel.setBorder(BorderFactory.createEmptyBorder());
        this.dayChooser = new JDayChooser(weekOfYearVisible);
        this.dayChooser.addPropertyChangeListener(this);
        this.dayChooser.addMouseListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener(this);
        this.dayChooser.setYearChooser(this.yearChooser);
        this.dayChooser.setMonthChooser(this.monthChooser);
        this.add((Component)this.monthYearPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        if (timeVisible) {
            this.timeChooser = new JTimeChooser();
            this.add((Component)this.timeChooser, "South");
        } else {
            this.timeChooser = null;
        }
        if (date != null) {
            this.calendar.setTime(date);
        }
        this.initialized = true;
        this.setCalendar(this.calendar);
    }

    public JCalendar(Locale locale) {
        this(null, locale, true, true, true);
    }

    public JCalendar(Locale locale, boolean monthSpinner) {
        this(null, locale, monthSpinner, true, false);
    }

    public JPopupMenu createPopupMenu() {
        if (this.calendarPopupMenu != null) {
            return this.calendarPopupMenu;
        }
        this.calendarPopupMenu = new JCalendarPopupMenu();
        this.calendarPopupMenu.add(this);
        return this.calendarPopupMenu;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Date getDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public JDayChooser getDayChooser() {
        return this.dayChooser;
    }

    public Color getDecorationBackgroundColor() {
        return this.dayChooser.getDecorationBackgroundColor();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public int getMaxDayCharacters() {
        return this.dayChooser.getMaxDayCharacters();
    }

    public Date getMaxSelectableDate() {
        return this.dayChooser.getMaxSelectableDate();
    }

    public Date getMinSelectableDate() {
        return this.dayChooser.getMinSelectableDate();
    }

    public JMonthChooser getMonthChooser() {
        return this.monthChooser;
    }

    public Color getSundayForeground() {
        return this.dayChooser.getSundayForeground();
    }

    public Color getWeekdayForeground() {
        return this.dayChooser.getWeekdayForeground();
    }

    public JYearChooser getYearChooser() {
        return this.yearChooser;
    }

    public boolean isDecorationBackgroundVisible() {
        return this.dayChooser.isDecorationBackgroundVisible();
    }

    public boolean isDecorationBordersVisible() {
        return this.dayChooser.isDecorationBordersVisible();
    }

    public boolean isWeekOfYearVisible() {
        return this.dayChooser.isWeekOfYearVisible();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.processMouseEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.processMouseEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendar != null) {
            if (evt.getPropertyName().equals("day")) {
                this.calendar.set(5, (Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("month")) {
                this.calendar.set(2, (Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("year")) {
                this.calendar.set(1, (Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals(DATE_PROPERTY)) {
                this.calendar.setTime((Date)evt.getNewValue());
            }
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(bg);
        }
    }

    public void setCalendar(Calendar c) {
        if (c == null) {
            this.setDate(null);
        }
        Calendar oldCalendar = this.calendar;
        this.calendar = c;
        this.yearChooser.setYear(c.get(1));
        this.monthChooser.setMonth(c.get(2));
        this.dayChooser.setDay(c.get(5));
        if (this.timeChooser != null) {
            this.timeChooser.setCalendar(this.calendar);
        }
        this.firePropertyChange("calendar", oldCalendar, this.calendar);
    }

    public void setDate(Date date) {
        Date oldDate = this.calendar.getTime();
        this.calendar.setTime(date);
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int day = this.calendar.get(5);
        this.yearChooser.setYear(year);
        this.monthChooser.setMonth(month);
        this.dayChooser.setCalendar(this.calendar);
        this.dayChooser.setDay(day);
        this.firePropertyChange(DATE_PROPERTY, oldDate, date);
    }

    public void setDecorationBackgroundColor(Color decorationBackgroundColor) {
        this.dayChooser.setDecorationBackgroundColor(decorationBackgroundColor);
    }

    public void setDecorationBackgroundVisible(boolean decorationBackgroundVisible) {
        this.dayChooser.setDecorationBackgroundVisible(decorationBackgroundVisible);
        this.setLocale(this.locale);
    }

    public void setDecorationBordersVisible(boolean decorationBordersVisible) {
        this.dayChooser.setDecorationBordersVisible(decorationBordersVisible);
        this.setLocale(this.locale);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dayChooser != null) {
            this.dayChooser.setEnabled(enabled);
            this.monthChooser.setEnabled(enabled);
            this.yearChooser.setEnabled(enabled);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(fg);
            this.monthChooser.setForeground(fg);
            this.yearChooser.setForeground(fg);
        }
    }

    @Override
    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            Locale oldLocale = this.locale;
            this.locale = l;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.firePropertyChange("locale", oldLocale, this.locale);
        }
    }

    public void setMaxDayCharacters(int maxDayCharacters) {
        this.dayChooser.setMaxDayCharacters(maxDayCharacters);
    }

    public void setMaxSelectableDate(Date max) {
        this.dayChooser.setMaxSelectableDate(max);
    }

    public void setMinSelectableDate(Date min) {
        this.dayChooser.setMinSelectableDate(min);
    }

    public void setSelectableDateRange(Date min, Date max) {
        this.dayChooser.setSelectableDateRange(min, max);
    }

    public void setSundayForeground(Color sundayForeground) {
        this.dayChooser.setSundayForeground(sundayForeground);
    }

    public void setTodayBackground(Color todayBackground) {
        this.dayChooser.setTodayBackground(todayBackground);
    }

    public void setWeekdayForeground(Color weekdayForeground) {
        this.dayChooser.setWeekdayForeground(weekdayForeground);
    }

    public void setWeekOfYearVisible(boolean weekOfYearVisible) {
        this.dayChooser.setWeekOfYearVisible(weekOfYearVisible);
        this.setLocale(this.locale);
    }

    public boolean isTimeVisible() {
        return this.timeChooser != null;
    }

    private final class JCalendarPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        private JCalendarPopupMenu() {
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
            Object source;
            AWTEvent currentEvent;
            if (!isIncluded && (currentEvent = EventQueue.getCurrentEvent()) != null && (source = currentEvent.getSource()) instanceof Component) {
                Component c = (Component)source;
                isIncluded = SwingUtilities.isDescendingFrom(c, this);
            }
            super.menuSelectionChanged(isIncluded);
        }
    }
}

