/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.StringTransformer;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class StringConditionAdapter
extends ASelectableCondition {
    public static final String MATCH_CASE = "MATCH_CASE";
    public static final String MATCH_APPROXIMATELY = "MATCH_APPROXIMATELY";
    public static final String IGNORE_DIACRITICS = "IGNORE_DIACRITICS";
    private transient String normalizedValue;
    protected final boolean matchCase;
    protected final boolean matchApproximately;
    protected final boolean ignoreDiacritics;

    public StringConditionAdapter(boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        this.matchCase = matchCase;
        this.matchApproximately = matchApproximately;
        this.ignoreDiacritics = ignoreDiacritics;
    }

    protected String normalizedValue() {
        if (this.normalizedValue == null) {
            this.normalizedValue = this.normalize(this.conditionValue());
        }
        return this.normalizedValue;
    }

    protected abstract Object conditionValue();

    protected String normalize(Object value) {
        return StringTransformer.transform(value.toString(), !this.matchCase, this.ignoreDiacritics);
    }

    @Override
    protected void fillXML(XMLElement element) {
        super.fillXML(element);
        if (this.matchCase) {
            element.setAttribute(MATCH_CASE, "true");
        }
        if (this.matchApproximately) {
            element.setAttribute(MATCH_APPROXIMATELY, "true");
        }
        if (this.ignoreDiacritics) {
            element.setAttribute(IGNORE_DIACRITICS, "true");
        }
    }

    protected String createDescription(String attribute, String simpleCondition, String value) {
        return ConditionFactory.createDescription(attribute, simpleCondition, value, this.matchCase, this.matchApproximately, this.ignoreDiacritics);
    }
}

