/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.plugin.codeexplorer.graph.GraphNodeSort;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DistinctTargetDependencyFilter;
import org.freeplane.plugin.codeexplorer.map.PackageNode;
import org.freeplane.plugin.codeexplorer.map.SubgroupComparator;
import org.freeplane.plugin.codeexplorer.map.SubprojectFinder;
import org.freeplane.plugin.codeexplorer.task.DirectoryMatcher;

class ProjectRootNode
extends CodeNode
implements SubprojectFinder {
    static final String UI_ICON_NAME = "code_project";
    private static final Map.Entry<Integer, String> UNKNOWN;
    private final JavaPackage rootPackage;
    private final Map<String, Map.Entry<Integer, String>> subprojectsByLocation;
    private final Set<String> badLocations;
    private JavaClasses classes;
    private DirectoryMatcher directoryMatcher;

    static ProjectRootNode asMapRoot(String projectName, CodeMap map, JavaClasses classes, DirectoryMatcher directoryMatcher) {
        ProjectRootNode projectRootNode = new ProjectRootNode(projectName, map, classes, directoryMatcher);
        map.setRoot(projectRootNode);
        if (projectRootNode.getChildCount() > 20) {
            projectRootNode.getChildren().forEach(node -> ((CodeNode)((Object)node)).memoizeCodeDependencies());
        }
        return projectRootNode;
    }

    private ProjectRootNode(String projectName, CodeMap map, JavaClasses classes, DirectoryMatcher directoryMatcher) {
        super(map, 0);
        this.classes = classes;
        this.directoryMatcher = directoryMatcher;
        this.rootPackage = classes.getDefaultPackage();
        this.setID("projectRoot");
        this.setText(projectName);
        this.subprojectsByLocation = new LinkedHashMap<String, Map.Entry<Integer, String>>();
        classes.stream().map(CodeNode::classSourceLocationOf).map(directoryMatcher::coreLocationPath).filter(Optional::isPresent).map(Optional::get).forEach(location -> this.subprojectsByLocation.computeIfAbsent((String)location, key -> new AbstractMap.SimpleEntry<Integer, String>(this.subprojectsByLocation.size(), ProjectRootNode.toSubprojectName(location))));
        this.badLocations = new HashSet<String>();
        map.setSubprojectFinder(this);
        this.initializeChildNodes();
    }

    private static String toSubprojectName(String location) {
        Pattern projectName = Pattern.compile("/([^/]+?)!?/(?:(?:bin|build|target)/.*)*$");
        Matcher matcher = projectName.matcher(location);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return location;
    }

    private void initializeChildNodes() {
        List children = super.getChildrenInternal();
        List<PackageNode> nodes = ((Stream)this.subprojectsByLocation.values().stream().parallel()).map(e -> new PackageNode(this.rootPackage, this.getMap(), (String)e.getValue(), (Integer)e.getKey(), true)).collect(Collectors.toList());
        GraphNodeSort childNodes = new GraphNodeSort();
        nodes.forEach(node -> {
            childNodes.addNode(node.subprojectIndex);
            DistinctTargetDependencyFilter filter = new DistinctTargetDependencyFilter();
            Map<Integer, Long> referencedSubprojects = node.getOutgoingDependenciesWithKnownTargets().map(filter::knownDependency).map(Dependency::getTargetClass).collect(Collectors.groupingBy(this::subprojectIndexOf, Collectors.counting()));
            referencedSubprojects.entrySet().forEach(e -> childNodes.addEdge(node.subprojectIndex, (Integer)e.getKey(), ((Long)e.getValue()).longValue()));
        });
        Comparator<Set> comparingByReversedClassCount = Comparator.comparing(indices -> -indices.stream().map(nodes::get).mapToLong(PackageNode::getClassCount).sum());
        List orderedPackages = childNodes.sortNodes(comparingByReversedClassCount.thenComparing(SubgroupComparator.comparingByName(i -> ((PackageNode)((Object)((Object)nodes.get((int)i)))).getText())));
        for (int subgroupIndex = 0; subgroupIndex < orderedPackages.size(); ++subgroupIndex) {
            for (Integer subprojectIndex : orderedPackages.get(subgroupIndex)) {
                CodeNode node2 = (CodeNode)((Object)nodes.get(subprojectIndex));
                children.add(node2);
                node2.setParent(this);
            }
        }
    }

    @Override
    HasName getCodeElement() {
        return () -> "root";
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        return Stream.empty();
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        return Stream.empty();
    }

    @Override
    String getUIIconName() {
        return UI_ICON_NAME;
    }

    @Override
    public int subprojectIndexOf(JavaClass javaClass) {
        Optional<String> classSourceLocation = CodeNode.classSourceLocationOf(javaClass).map(this.directoryMatcher::coreLocationPath);
        Optional<Map.Entry> subprojectEntry = classSourceLocation.map(s -> this.subprojectsByLocation.getOrDefault(s, UNKNOWN));
        if (subprojectEntry.filter(UNKNOWN::equals).isPresent() && this.badLocations.add(classSourceLocation.get())) {
            LogUtils.info((String)("Unknown class source location " + ((Source)javaClass.getSource().get()).getUri()));
        }
        return subprojectEntry.orElse(UNKNOWN).getKey();
    }

    @Override
    public Stream<JavaClass> allClasses() {
        return this.classes.stream();
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(UI_ICON_NAME, "code/homeFolder.svg");
        UNKNOWN = new AbstractMap.SimpleEntry<Integer, String>(-1, ":unknown:");
    }
}

