/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.PackageMatcher;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.core.importer.Location;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class ClassMatcher
implements ImportOption {
    private static final Pattern CLASS_LOCATION_PATTERN = Pattern.compile("/[\\w\\$/]+(?=\\.class$)");
    private static final Pattern ANONYMOUS_CLASS_PATTERN = Pattern.compile("\\$\\d+$");
    private final List<PackageMatcher> matchers;
    private final List<String> patterns;

    public ClassMatcher(List<String> patterns) {
        this.patterns = patterns;
        this.matchers = patterns.stream().map(s -> s.startsWith("..") ? s : ".." + s).map(PackageMatcher::of).collect(Collectors.toList());
    }

    public boolean anyMatch(Location location) {
        String locationString = location.asURI().toString();
        if (locationString.endsWith("/package-info.class")) {
            return true;
        }
        Matcher matcher = CLASS_LOCATION_PATTERN.matcher(locationString);
        if (matcher.find()) {
            String fullClassName = matcher.group().replace('/', '.');
            Matcher classNameMatcher = ANONYMOUS_CLASS_PATTERN.matcher(fullClassName);
            String namedClass = classNameMatcher.find() ? fullClassName.substring(1, classNameMatcher.start()) : fullClassName.substring(1);
            return this.anyMatch(namedClass.replace('$', '.'));
        }
        return false;
    }

    public boolean anyMatch(String name) {
        return this.matchers.stream().anyMatch((? super T m) -> m.matches(name));
    }

    public int hashCode() {
        return Objects.hash(this.patterns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMatcher other = (ClassMatcher)obj;
        return Objects.equals(this.patterns, other.patterns);
    }

    public boolean includes(Location location) {
        return this.matchers.isEmpty() ? true : !this.anyMatch(location);
    }
}

