/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.google.gson.annotations.SerializedName;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.codeexplorer.task.ConfigurationChange;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;
import org.freeplane.plugin.codeexplorer.task.DirectoryMatcher;
import org.freeplane.plugin.codeexplorer.task.ParsedConfiguration;

public class CodeExplorerConfiguration {
    @SerializedName(value="projectName")
    private String projectName;
    @SerializedName(value="locations")
    private Set<File> projectLocations;
    @SerializedName(value="configurationRules", alternate={"dependencyJudgeRules"})
    private String configurationRules;
    private transient ParsedConfiguration parsedConfiguration;

    public CodeExplorerConfiguration() {
        this("", new ArrayList<File>(), "");
    }

    @VisibleForTesting
    CodeExplorerConfiguration(String projectName, List<File> locations, String dependencyJudgeRules) {
        this.projectName = projectName;
        this.projectLocations = locations.stream().map(File::getAbsolutePath).map(File::new).collect(Collectors.toCollection(LinkedHashSet::new));
        this.applyConfigurationRules("");
        if (!dependencyJudgeRules.isEmpty()) {
            try {
                this.applyConfigurationRules(dependencyJudgeRules);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void removeAllLocations() {
        this.projectLocations.clear();
    }

    public String getConfigurationRules() {
        return this.configurationRules;
    }

    void applyConfigurationRules() {
        try {
            this.applyConfigurationRules(this.configurationRules);
        }
        catch (Exception e) {
            this.configurationRules = "";
        }
    }

    public ConfigurationChange applyConfigurationRules(String configurationRules) {
        ParsedConfiguration newConfiguration = new ParsedConfiguration(configurationRules);
        ConfigurationChange status = newConfiguration.configurationChange(this.parsedConfiguration);
        this.configurationRules = configurationRules;
        this.parsedConfiguration = newConfiguration;
        return status;
    }

    public DependencyJudge getDependencyJudge() {
        return this.parsedConfiguration.judge();
    }

    public JavaClasses importClasses() {
        DirectoryMatcher directoryMatcher = this.createDirectoryMatcher();
        Collection locations = directoryMatcher.getImportedLocations().stream().map(File::toURI).map(Location::of).collect(Collectors.toList());
        ClassFileImporter classFileImporter = new ClassFileImporter().withImportOption(this.parsedConfiguration.importOption());
        LogUtils.info((String)("Starting import from " + locations.size() + " locations"));
        JavaClasses importedClasses = classFileImporter.importLocations(locations);
        LogUtils.info((String)"Import done");
        return importedClasses;
    }

    public DirectoryMatcher createDirectoryMatcher() {
        return this.parsedConfiguration.directoryMatcher(this.projectLocations);
    }

    public void addLocation(File file) {
        this.projectLocations.add(new File(file.getAbsolutePath()));
    }

    public void addLocation(String path) {
        this.addLocation(new File(path));
    }

    public int countLocations() {
        return this.projectLocations.size();
    }

    public boolean containsLocation(String path) {
        return this.projectLocations.contains(new File(path).getAbsoluteFile());
    }

    public boolean removeLocation(String path) {
        return this.projectLocations.remove(new File(path).getAbsoluteFile());
    }

    public Collection<File> getLocations() {
        return this.projectLocations;
    }
}

