/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.net.URL;
import java.util.Vector;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.FormulaUtils;
import org.freeplane.plugin.script.dependencies.RelatedElements;

public class NodeScript {
    final NodeModel node;
    final String script;

    public NodeScript(NodeModel node, String script) {
        this.node = node;
        this.script = script;
    }

    String format(NodeScript nodeScriptToHighlight) {
        return (nodeScriptToHighlight.equals(this) ? "* " : "") + this.node.createID() + " " + this.limitLength(this.toPlainText(this.node.getText()), 30) + " -> " + this.limitLength(this.script, 60);
    }

    private String toPlainText(String string) {
        return HtmlUtils.htmlToPlain((String)string).replaceAll("\\s+", " ");
    }

    private String limitLength(String string, int maxLenght) {
        if (string == null || maxLenght >= string.length()) {
            return string;
        }
        maxLenght = maxLenght > 3 ? maxLenght - 3 : maxLenght;
        return string.substring(0, maxLenght) + "...";
    }

    MapModel getMap() {
        return this.node.getMap();
    }

    public URL getBaseUrl() {
        return this.getMap().getURL();
    }

    public RelatedElements containingElements() {
        NodeAttributeTableModel attributeTableModel;
        RelatedElements elements = new RelatedElements(this.node);
        Object userObject = this.node.getUserObject();
        if (this.scriptIsContainedIn(userObject)) {
            elements.relateNode(this.node);
        }
        if ((attributeTableModel = (NodeAttributeTableModel)this.node.getExtension(NodeAttributeTableModel.class)) != null) {
            Vector attributes = attributeTableModel.getAttributes();
            attributes.stream().filter(a -> this.scriptIsContainedIn(a.getValue())).forEach(a -> elements.relateAttribute(this.node, (Attribute)a));
        }
        return elements;
    }

    public boolean scriptIsContainedIn(Object userObject) {
        return FormulaUtils.containsFormula(userObject) && this.script.equals(FormulaUtils.scriptOf((String)userObject));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeScript other = (NodeScript)obj;
        if (this.node != other.node) {
            return false;
        }
        if (this.script == null && other.script != null) {
            return false;
        }
        return this.script.equals(other.script);
    }

    public String toString() {
        return this.node + "[" + this.script + "]";
    }
}

