/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.JSVGComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.filepreview.ViewerLayoutManager;
import org.freeplane.view.swing.map.MapView;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGSVGElement;

public class SvgViewerFactory
implements IViewerFactory {
    public boolean accept(URI uri) {
        String path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getRawPath();
        return path.toLowerCase().endsWith(".svg");
    }

    public String getDescription() {
        return TextUtils.getText((String)"svg");
    }

    public ViewerComponent createViewer(ExternalResource resource, URI uri, int maximumWidth, float zoom) {
        return new ViewerComponent(uri, canvas -> {
            float scaledZoom;
            Dimension originalSize = canvas.getOriginalSize();
            float r = resource.getZoom();
            int originalWidth = originalSize.width;
            ViewerLayoutManager viewerLayoutManager = new ViewerLayoutManager(zoom, resource, originalSize);
            canvas.setLayout((LayoutManager)viewerLayoutManager);
            if (r == -1.0f) {
                r = resource.setZoom(originalWidth, maximumWidth);
            }
            if ((scaledZoom = r * zoom) != 1.0f) {
                canvas.setFinalViewerSize(scaledZoom);
            }
        });
    }

    public ViewerComponent createViewer(URI uri, Dimension size) {
        return new ViewerComponent(uri, canvas -> canvas.setFinalViewerSize(size));
    }

    public ViewerComponent createViewer(URI uri, float zoom) throws MalformedURLException, IOException {
        return new ViewerComponent(uri, canvas -> canvas.setFinalViewerSize(zoom));
    }

    public ViewerComponent createViewer(URI uri, Dimension preferredSize, final Runnable callback) throws MalformedURLException, IOException {
        ViewerComponent viewer = this.createViewer(uri, preferredSize);
        viewer.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                callback.run();
            }
        });
        return viewer;
    }

    public ViewerComponent createViewer(URI uri, float zoom, final Runnable callback) throws MalformedURLException, IOException {
        ViewerComponent viewer = this.createViewer(uri, zoom);
        viewer.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                callback.run();
            }
        });
        return viewer;
    }

    private static class ViewerComponent
    extends JSVGComponent
    implements ScalableComponent {
        private static final long serialVersionUID = 1L;
        private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
        private Dimension originalSize = null;
        private Dimension maximumSize = null;

        public ViewerComponent(URI uri, final Consumer<ViewerComponent> initializer) {
            super(null, false, false);
            this.setPreferredSize(new Dimension(1, 1));
            this.setBackground(TRANSPARENT);
            this.setRecenterOnResize(false);
            this.setDocumentState(2);
            this.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

                public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                    this.removeGVTTreeBuilderListener((GVTTreeBuilderListener)this);
                    SVGDocument document = this.getSVGDocument();
                    SVGSVGElement svgElt = document.getRootElement();
                    String svgViewboxAttribute = svgElt.getAttributeNS(null, "viewBox");
                    if (svgViewboxAttribute.isEmpty()) {
                        SVGLength svgWidth = svgElt.getWidth().getBaseVal();
                        SVGLength svgHeight = svgElt.getHeight().getBaseVal();
                        float width = (float)Math.ceil(svgWidth.getValue());
                        float heigth = (float)Math.ceil(svgHeight.getValue());
                        if (width <= 1.0f && heigth <= 1.0f) {
                            width = ResourceController.getResourceController().getIntProperty("default_external_component_width", 200);
                            heigth = ResourceController.getResourceController().getIntProperty("default_external_component_height", 200);
                        }
                        originalSize = new Dimension((int)width, (int)heigth);
                        svgElt.setAttributeNS(null, "viewBox", "0 0 " + width + " " + heigth);
                    } else {
                        float[] vb = ViewBox.parseViewBoxAttribute((Element)svgElt, (String)svgViewboxAttribute, (BridgeContext)bridgeContext);
                        originalSize = new Dimension((int)vb[2], (int)vb[3]);
                    }
                    MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, (Component)((Object)this));
                    if (mapView != null) {
                        mapView.preserveSelectedNodeLocation();
                    }
                    initializer.accept(this);
                    this.revalidate();
                    this.repaint();
                }
            });
            this.loadSVGDocument(uri.toString());
        }

        public Dimension getOriginalSize() {
            return new Dimension(this.originalSize);
        }

        public void setFinalViewerSize(Dimension size) {
            Dimension sizeWithScaleCorrection = this.fitToMaximumSize(size);
            this.setMySize(sizeWithScaleCorrection);
            this.setSize(sizeWithScaleCorrection);
        }

        private Dimension fitToMaximumSize(Dimension size) {
            if (this.maximumSize == null || this.isUnderMaximumSize(size)) {
                return size;
            }
            return this.maximumSize;
        }

        private boolean isUnderMaximumSize(Dimension size) {
            return this.maximumSize.getWidth() >= (double)size.width || this.maximumSize.getHeight() >= (double)size.height;
        }

        public void setDraftViewerSize(Dimension size) {
            this.setFinalViewerSize(size);
        }

        public void setFinalViewerSize(float zoom) {
            if (this.originalSize != null) {
                int scaledWidth = (int)((float)this.originalSize.width * zoom);
                int scaledHeight = (int)((float)this.originalSize.height * zoom);
                this.setFinalViewerSize(new Dimension(scaledWidth, scaledHeight));
            }
        }

        public void setMaximumComponentSize(Dimension size) {
            this.maximumSize = size;
        }
    }
}

