/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.awt.PaintUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class ColorPickerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int MAX_SIZE = 325;
    private int mode = 1;
    private Point point = new Point(0, 0);
    private Vector changeListeners;
    float hue = -1.0f;
    float sat = -1.0f;
    float bri = -1.0f;
    int red = -1;
    int green = -1;
    int blue = -1;
    MouseInputListener mouseListener = new MouseInputAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            ColorPickerPanel.this.requestFocus();
            Point p = e.getPoint();
            int size = Math.min(MAX_SIZE, Math.min(ColorPickerPanel.this.getWidth() - ColorPickerPanel.this.imagePadding.left - ColorPickerPanel.this.imagePadding.right, ColorPickerPanel.this.getHeight() - ColorPickerPanel.this.imagePadding.top - ColorPickerPanel.this.imagePadding.bottom));
            p.translate(-(ColorPickerPanel.this.getWidth() / 2 - size / 2), -(ColorPickerPanel.this.getHeight() / 2 - size / 2));
            block0 : switch (ColorPickerPanel.this.mode) {
                case 1: 
                case 2: {
                    double radius = (double)size / 2.0;
                    double x = p.getX() - (double)size / 2.0;
                    double y = p.getY() - (double)size / 2.0;
                    double r = Math.sqrt(x * x + y * y) / radius;
                    double theta = Math.atan2(y, x) / (Math.PI * 2);
                    if (r > 1.0) {
                        r = 1.0;
                    }
                    if (ColorPickerPanel.this.mode == 1) {
                        ColorPickerPanel.this.setHSB((float)(theta + 0.25), (float)r, ColorPickerPanel.this.bri);
                        break;
                    }
                    ColorPickerPanel.this.setHSB((float)(theta + 0.25), ColorPickerPanel.this.sat, (float)r);
                    break;
                }
                case 0: {
                    float s = (float)p.x / (float)size;
                    float b = (float)p.y / (float)size;
                    if (s < 0.0f) {
                        s = 0.0f;
                    }
                    if (s > 1.0f) {
                        s = 1.0f;
                    }
                    if (b < 0.0f) {
                        b = 0.0f;
                    }
                    if (b > 1.0f) {
                        b = 1.0f;
                    }
                    ColorPickerPanel.this.setHSB(ColorPickerPanel.this.hue, s, b);
                    break;
                }
                default: {
                    int x2 = p.x * 255 / size;
                    int y2 = p.y * 255 / size;
                    if (x2 < 0) {
                        x2 = 0;
                    }
                    if (x2 > 255) {
                        x2 = 255;
                    }
                    if (y2 < 0) {
                        y2 = 0;
                    }
                    if (y2 > 255) {
                        y2 = 255;
                    }
                    switch (ColorPickerPanel.this.mode) {
                        case 3: {
                            ColorPickerPanel.this.setRGB(ColorPickerPanel.this.red, x2, y2);
                            break block0;
                        }
                        case 4: {
                            ColorPickerPanel.this.setRGB(x2, ColorPickerPanel.this.green, y2);
                            break block0;
                        }
                    }
                    ColorPickerPanel.this.setRGB(x2, y2, ColorPickerPanel.this.blue);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mousePressed(e);
        }
    };
    KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int dx = 0;
            int dy = 0;
            switch (e.getKeyCode()) {
                case 37: {
                    dx = -1;
                    break;
                }
                case 39: {
                    dx = 1;
                    break;
                }
                case 38: {
                    dy = -1;
                    break;
                }
                case 40: {
                    dy = 1;
                    break;
                }
            }
            int multiplier = 1;
            if (e.isShiftDown() && e.isAltDown()) {
                multiplier = 10;
            } else if (e.isShiftDown() || e.isAltDown()) {
                multiplier = 5;
            }
            if (dx != 0 || dy != 0) {
                int size = Math.min(MAX_SIZE, Math.min(ColorPickerPanel.this.getWidth() - ColorPickerPanel.this.imagePadding.left - ColorPickerPanel.this.imagePadding.right, ColorPickerPanel.this.getHeight() - ColorPickerPanel.this.imagePadding.top - ColorPickerPanel.this.imagePadding.bottom));
                int offsetX = ColorPickerPanel.this.getWidth() / 2 - size / 2;
                int offsetY = ColorPickerPanel.this.getHeight() / 2 - size / 2;
                ColorPickerPanel.this.mouseListener.mousePressed(new MouseEvent(ColorPickerPanel.this, 501, System.currentTimeMillis(), 0, ((ColorPickerPanel)ColorPickerPanel.this).point.x + multiplier * dx + offsetX, ((ColorPickerPanel)ColorPickerPanel.this).point.y + multiplier * dy + offsetY, 1, false));
            }
        }
    };
    FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            ColorPickerPanel.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ColorPickerPanel.this.repaint();
        }
    };
    ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            ColorPickerPanel.this.regeneratePoint();
            ColorPickerPanel.this.regenerateImage();
        }
    };
    BufferedImage image = new BufferedImage(MAX_SIZE, MAX_SIZE, 2);
    Insets imagePadding = new Insets(6, 6, 6, 6);
    private final int[] row = new int[MAX_SIZE];

    public ColorPickerPanel() {
        this.setMaximumSize(new Dimension(MAX_SIZE + this.imagePadding.left + this.imagePadding.right, MAX_SIZE + this.imagePadding.top + this.imagePadding.bottom));
        this.setPreferredSize(new Dimension((int)((double)MAX_SIZE * 0.75), (int)((double)MAX_SIZE * 0.75)));
        this.setRGB(0, 0, 0);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setFocusable(true);
        this.addKeyListener(this.keyListener);
        this.addFocusListener(this.focusListener);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addComponentListener(this.componentListener);
    }

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        if (this.changeListeners.contains(l)) {
            return;
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(l);
    }

    protected void fireChangeListeners() {
        if (this.changeListeners == null) {
            return;
        }
        for (int a = 0; a < this.changeListeners.size(); ++a) {
            ChangeListener l = (ChangeListener)this.changeListeners.get(a);
            try {
                l.stateChanged(new ChangeEvent(this));
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle r;
        RectangularShape shape;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        int size = Math.min(MAX_SIZE, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        g2.translate(this.getWidth() / 2 - size / 2, this.getHeight() / 2 - size / 2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mode == 2 || this.mode == 1) {
            shape = new Ellipse2D.Float(0.0f, 0.0f, size, size);
        } else {
            r = new Rectangle(0, 0, size, size);
            shape = r;
        }
        if (this.hasFocus()) {
            PaintUtils.paintFocus(g2, shape, 5);
        }
        if (!(shape instanceof Rectangle)) {
            g2.translate(2, 2);
            g2.setColor(new Color(0, 0, 0, 20));
            g2.fill(new Ellipse2D.Float(-2.0f, -2.0f, size + 4, size + 4));
            g2.setColor(new Color(0, 0, 0, 40));
            g2.fill(new Ellipse2D.Float(-1.0f, -1.0f, size + 2, size + 2));
            g2.setColor(new Color(0, 0, 0, 80));
            g2.fill(new Ellipse2D.Float(0.0f, 0.0f, size, size));
            g2.translate(-2, -2);
        }
        g2.drawImage(this.image, 0, 0, size, size, 0, 0, size, size, null);
        if (shape instanceof Rectangle) {
            r = (Rectangle)shape;
            PaintUtils.drawBevel(g2, r);
        } else {
            g2.setColor(new Color(0, 0, 0, 120));
            g2.draw(shape);
        }
        g2.setColor(Color.white);
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(new Ellipse2D.Float(this.point.x - 3, this.point.y - 3, 6.0f, 6.0f));
        g2.setColor(Color.black);
        g2.draw(new Ellipse2D.Float(this.point.x - 4, this.point.y - 4, 8.0f, 8.0f));
        g.translate(-this.imagePadding.left, -this.imagePadding.top);
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 2 && mode != 1 && mode != 3 && mode != 4 && mode != 5) {
            throw new IllegalArgumentException("The mode must be HUE, SAT, BRI, RED, GREEN, or BLUE.");
        }
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.regenerateImage();
        this.regeneratePoint();
    }

    public void setRGB(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("The red value (" + r + ") must be between [0,255].");
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("The green value (" + g + ") must be between [0,255].");
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("The blue value (" + b + ") must be between [0,255].");
        }
        if (this.red != r || this.green != g || this.blue != b) {
            if (this.mode == 3 || this.mode == 4 || this.mode == 5) {
                int lastR = this.red;
                int lastG = this.green;
                int lastB = this.blue;
                this.red = r;
                this.green = g;
                this.blue = b;
                switch (this.mode) {
                    case 3: {
                        if (lastR == r) break;
                        this.regenerateImage();
                        break;
                    }
                    case 4: {
                        if (lastG == g) break;
                        this.regenerateImage();
                        break;
                    }
                    case 5: {
                        if (lastB == b) break;
                        this.regenerateImage();
                        break;
                    }
                }
            } else {
                float[] hsb = new float[3];
                Color.RGBtoHSB(r, g, b, hsb);
                this.setHSB(hsb[0], hsb[1], hsb[2]);
                return;
            }
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    public float[] getHSB() {
        return new float[]{this.hue, this.sat, this.bri};
    }

    public int[] getRGB() {
        return new int[]{this.red, this.green, this.blue};
    }

    public void setHSB(float h, float s, float b) {
        if (Float.isInfinite(h) || Float.isNaN(h)) {
            throw new IllegalArgumentException("The hue value (" + h + ") is not a valid number.");
        }
        while (h < 0.0f) {
            h += 1.0f;
        }
        while (h > 1.0f) {
            h -= 1.0f;
        }
        if (s < 0.0f || s > 1.0f) {
            throw new IllegalArgumentException("The saturation value (" + s + ") must be between [0,1]");
        }
        if (b < 0.0f || b > 1.0f) {
            throw new IllegalArgumentException("The brightness value (" + b + ") must be between [0,1]");
        }
        if (this.hue != h || this.sat != s || this.bri != b) {
            if (this.mode == 0 || this.mode == 1 || this.mode == 2) {
                float lastHue = this.hue;
                float lastBri = this.bri;
                float lastSat = this.sat;
                this.hue = h;
                this.sat = s;
                this.bri = b;
                switch (this.mode) {
                    case 0: {
                        if (lastHue == this.hue) break;
                        this.regenerateImage();
                        break;
                    }
                    case 2: {
                        if (lastSat == this.sat) break;
                        this.regenerateImage();
                        break;
                    }
                    case 1: {
                        if (lastBri == this.bri) break;
                        this.regenerateImage();
                        break;
                    }
                }
            } else {
                Color c = new Color(Color.HSBtoRGB(h, s, b));
                this.setRGB(c.getRed(), c.getGreen(), c.getBlue());
                return;
            }
            Color c = new Color(Color.HSBtoRGB(this.hue, this.sat, this.bri));
            this.red = c.getRed();
            this.green = c.getGreen();
            this.blue = c.getBlue();
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    private void regeneratePoint() {
        int size = Math.min(MAX_SIZE, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        block0 : switch (this.mode) {
            case 0: 
            case 1: 
            case 2: {
                switch (this.mode) {
                    case 0: {
                        this.point = new Point((int)(this.sat * (float)size), (int)(this.bri * (float)size));
                        break block0;
                    }
                    case 2: {
                        double theta = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                        if (theta < 0.0) {
                            theta += Math.PI * 2;
                        }
                        double r = this.bri * (float)size / 2.0f;
                        this.point = new Point((int)(r * Math.cos(theta) + 0.5 + (double)size / 2.0), (int)(r * Math.sin(theta) + 0.5 + (double)size / 2.0));
                        break block0;
                    }
                    case 1: {
                        double theta = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                        if (theta < 0.0) {
                            theta += Math.PI * 2;
                        }
                        double r = this.sat * (float)size / 2.0f;
                        this.point = new Point((int)(r * Math.cos(theta) + 0.5 + (double)size / 2.0), (int)(r * Math.sin(theta) + 0.5 + (double)size / 2.0));
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                this.point = new Point((int)((float)(this.green * size) / 255.0f + 0.49f), (int)((float)(this.blue * size) / 255.0f + 0.49f));
                break;
            }
            case 4: {
                this.point = new Point((int)((float)(this.red * size) / 255.0f + 0.49f), (int)((float)(this.blue * size) / 255.0f + 0.49f));
                break;
            }
            case 5: {
                this.point = new Point((int)((float)(this.red * size) / 255.0f + 0.49f), (int)((float)(this.green * size) / 255.0f + 0.49f));
                break;
            }
        }
    }

    private synchronized void regenerateImage() {
        int size = Math.min(MAX_SIZE, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        switch (this.mode) {
            case 1: 
            case 2: {
                float bri2 = this.bri;
                float sat2 = this.sat;
                float radius = (float)size / 2.0f;
                float k = 1.2f;
                for (int y = 0; y < size; ++y) {
                    float y2 = (float)y - (float)size / 2.0f;
                    for (int x = 0; x < size; ++x) {
                        double r;
                        float x2 = (float)x - (float)size / 2.0f;
                        double theta = Math.atan2(y2, x2) - 4.71238898038469;
                        if (theta < 0.0) {
                            theta += Math.PI * 2;
                        }
                        if ((r = Math.sqrt(x2 * x2 + y2 * y2)) <= (double)radius) {
                            float hue2;
                            if (this.mode == 1) {
                                hue2 = (float)(theta / (Math.PI * 2));
                                sat2 = (float)(r / (double)radius);
                            } else {
                                hue2 = (float)(theta / (Math.PI * 2));
                                bri2 = (float)(r / (double)radius);
                            }
                            this.row[x] = Color.HSBtoRGB(hue2, sat2, bri2);
                            if (!(r > (double)(radius - k))) continue;
                            int alpha = (int)(255.0 - 255.0 * (r - (double)radius + (double)k) / (double)k);
                            if (alpha < 0) {
                                alpha = 0;
                            }
                            if (alpha > 255) {
                                alpha = 255;
                            }
                            int n = x;
                            this.row[n] = this.row[n] & 0xFFFFFF + (alpha << 24);
                            continue;
                        }
                        this.row[x] = 0;
                    }
                    this.image.getRaster().setDataElements(0, y, size, 1, this.row);
                }
                break;
            }
            case 0: {
                float hue2 = this.hue;
                for (int y = 0; y < size; ++y) {
                    float y2 = (float)y / (float)size;
                    for (int x = 0; x < size; ++x) {
                        float x2 = (float)x / (float)size;
                        this.row[x] = Color.HSBtoRGB(hue2, x2, y2);
                    }
                    this.image.getRaster().setDataElements(0, y, this.image.getWidth(), 1, this.row);
                }
                break;
            }
            default: {
                int red2 = this.red;
                int green2 = this.green;
                int blue2 = this.blue;
                for (int y = 0; y < size; ++y) {
                    float y2 = (float)y / (float)size;
                    for (int x = 0; x < size; ++x) {
                        float x2 = (float)x / (float)size;
                        switch (this.mode) {
                            case 3: {
                                green2 = (int)((double)(x2 * 255.0f) + 0.49);
                                blue2 = (int)((double)(y2 * 255.0f) + 0.49);
                                break;
                            }
                            case 4: {
                                red2 = (int)((double)(x2 * 255.0f) + 0.49);
                                blue2 = (int)((double)(y2 * 255.0f) + 0.49);
                                break;
                            }
                            default: {
                                red2 = (int)((double)(x2 * 255.0f) + 0.49);
                                green2 = (int)((double)(y2 * 255.0f) + 0.49);
                            }
                        }
                        this.row[x] = -16777216 + (red2 << 16) + (green2 << 8) + blue2;
                    }
                    this.image.getRaster().setDataElements(0, y, size, 1, this.row);
                }
            }
        }
        this.repaint();
    }
}

