/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class JPopupPane {
    private final HideAWTListener hideListener;
    private final JComponent ancestor;
    private boolean showingPopup = false;
    private JPopupPaneComponent pane;
    private JWindow popupWindow;
    private final JPanel view;

    public JPopupPane(JComponent ancestor, JPanel content) {
        this.ancestor = ancestor;
        this.view = content;
        this.hideListener = new HideAWTListener();
    }

    public void showPopupPane() {
        if (this.pane == null) {
            this.pane = new JPopupPaneComponent();
        }
        if (this.popupWindow == null) {
            this.popupWindow = new JWindow(WindowManager.getDefault().getMainWindow());
        }
        this.popupWindow.getContentPane().add(this.pane);
        this.showingPopup = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.hideListener, 16L);
        WindowManager.getDefault().getMainWindow().addWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().addComponentListener(this.hideListener);
        this.resizePopup();
        this.popupWindow.setVisible(true);
        this.pane.requestFocus();
    }

    private void resizePopup() {
        this.popupWindow.pack();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.ancestor);
        Dimension dim = this.popupWindow.getSize();
        Rectangle usableRect = Utilities.getUsableScreenBounds();
        int sepShift = 0;
        Point loc = new Point(point.x + this.ancestor.getSize().width - dim.width - sepShift - 10, point.y - dim.height - 5);
        if (!usableRect.contains(loc)) {
            loc = new Point(loc.x, point.y + 5 + this.ancestor.getSize().height);
        }
        this.popupWindow.setLocation(loc);
    }

    public void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeComponentListener(this.hideListener);
        this.showingPopup = false;
    }

    public boolean isPopupShown() {
        return this.showingPopup;
    }

    private class HideAWTListener
    extends ComponentAdapter
    implements AWTEventListener,
    WindowStateListener {
        private HideAWTListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mv;
            if (aWTEvent instanceof MouseEvent && (mv = (MouseEvent)aWTEvent).getClickCount() > 0) {
                if (!(aWTEvent.getSource() instanceof Component)) {
                    return;
                }
                Component comp = (Component)aWTEvent.getSource();
                Container par = SwingUtilities.getAncestorNamed("jpopuppane", comp);
                Container barpar = SwingUtilities.getAncestorOfClass(JPopupPane.this.ancestor.getClass(), comp);
                if (par == null && barpar == null) {
                    JPopupPane.this.hidePopup();
                }
            }
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            if (JPopupPane.this.showingPopup) {
                int oldState = windowEvent.getOldState();
                int newState = windowEvent.getNewState();
                if ((oldState & 1) == 0 && (newState & 1) == 1) {
                    JPopupPane.this.hidePopup();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            if (JPopupPane.this.showingPopup) {
                JPopupPane.this.resizePopup();
            }
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            if (JPopupPane.this.showingPopup) {
                JPopupPane.this.resizePopup();
            }
        }
    }

    private class JPopupPaneComponent
    extends JScrollPane {
        static final int ITEM_WIDTH = 400;

        public JPopupPaneComponent() {
            this.setName("jpopuppane");
            GridLayout grid = new GridLayout(0, 1);
            grid.setHgap(0);
            grid.setVgap(0);
            this.setVerticalScrollBarPolicy(20);
            this.setViewportView(JPopupPane.this.view);
            this.setFocusable(true);
            this.setRequestFocusEnabled(true);
            this.setHorizontalScrollBarPolicy(31);
        }

        @Override
        public Dimension getPreferredSize() {
            int count = JPopupPane.this.view.getComponentCount();
            int height = count > 0 ? JPopupPane.this.view.getComponent((int)0).getPreferredSize().height : 0;
            int offset = count > 6 ? height * 6 + 5 : count * height + 5;
            return new Dimension(count > 3 ? 422 : 402, offset);
        }

        private int findIndex(Component comp) {
            Component[] comps = JPopupPane.this.view.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] != comp) continue;
                return i;
            }
            return -1;
        }
    }

    private static class BottomLineBorder
    implements Border {
        private final Insets ins = new Insets(0, 0, 1, 0);
        private final Color col = new Color(221, 229, 248);

        @Override
        public Insets getBorderInsets(Component c) {
            return this.ins;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color old = g.getColor();
            g.setColor(this.col);
            g.drawRect(x, y + height - 2, width, 1);
            g.setColor(old);
        }
    }
}

