/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import tim.prune.config.ColourScheme;
import tim.prune.data.RecentFileList;
import tim.prune.data.UnitSet;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.colour.ColourerFactory;
import tim.prune.gui.colour.PointColourer;
import tim.prune.gui.map.MapSourceLibrary;

public abstract class Config {
    private static File _configFile = null;
    private static Properties _configValues = null;
    private static ColourScheme _colourScheme = new ColourScheme();
    private static PointColourer _pointColourer = null;
    private static RecentFileList _recentFiles = new RecentFileList();
    private static UnitSet _unitSet = UnitSetLibrary.getUnitSet(null);
    public static final File DEFAULT_CONFIG_FILE = new File(".pruneconfig");
    public static final File HOME_CONFIG_FILE = new File(System.getProperty("user.home"), ".pruneconfig");
    public static final String KEY_TRACK_DIR = "prune.trackdirectory";
    public static final String KEY_PHOTO_DIR = "prune.photodirectory";
    public static final String KEY_LANGUAGE_CODE = "prune.languagecode";
    public static final String KEY_LANGUAGE_FILE = "prune.languagefile";
    public static final String KEY_GPS_DEVICE = "prune.gpsdevice";
    public static final String KEY_GPS_FORMAT = "prune.gpsformat";
    public static final String KEY_GPSBABEL_FILTER = "prune.gpsbabelfilter";
    public static final String KEY_IMPORT_FILE_FORMAT = "prune.lastimportfileformat";
    public static final String KEY_POVRAY_FONT = "prune.povrayfont";
    public static final String KEY_UNITSET_KEY = "prune.unitsetkey";
    public static final String KEY_COORD_DISPLAY_FORMAT = "prune.coorddisplay";
    public static final String KEY_MAPSOURCE_INDEX = "prune.mapsource";
    public static final String KEY_NUM_FIXED_MAPS = "prune.numfixedmapsources";
    public static final String KEY_MAPSOURCE_LIST = "prune.mapsourcelist";
    public static final String KEY_SHOW_MAP = "prune.showmap";
    public static final String KEY_WINDOW_BOUNDS = "prune.windowbounds";
    public static final String KEY_DISK_CACHE = "prune.diskcache";
    public static final String KEY_ONLINE_MODE = "prune.onlinemode";
    public static final String KEY_KMZ_IMAGE_SIZE = "prune.kmzimagewidth";
    public static final String KEY_GPSBABEL_PATH = "prune.gpsbabelpath";
    public static final String KEY_GNUPLOT_PATH = "prune.gnuplotpath";
    public static final String KEY_EXIFTOOL_PATH = "prune.exiftoolpath";
    public static final String KEY_COLOUR_SCHEME = "prune.colourscheme";
    public static final String KEY_POINT_COLOURER = "prune.pointcolourer";
    public static final String KEY_LINE_WIDTH = "prune.linewidth";
    public static final String KEY_ANTIALIAS = "prune.antialias";
    public static final String KEY_OSSCALING = "prune.osscaling";
    public static final String KEY_KML_TRACK_COLOUR = "prune.kmltrackcolour";
    public static final String KEY_WINDOW_STYLE = "prune.windowstyle";
    public static final String KEY_AUTOSAVE_SETTINGS = "prune.autosavesettings";
    public static final String KEY_RECENT_FILES = "prune.recentfiles";
    public static final String KEY_ESTIMATION_PARAMS = "prune.estimationparams";
    public static final String KEY_HEIGHT_EXAGGERATION = "prune.heightexaggeration";
    public static final String KEY_TERRAIN_GRID_SIZE = "prune.terraingridsize";
    public static final String KEY_ALTITUDE_TOLERANCE = "prune.altitudetolerance";
    public static final String KEY_WAYPOINT_ICONS = "prune.waypointicons";
    public static final String KEY_WAYPOINT_ICON_SIZE = "prune.waypointiconsize";
    public static final String KEY_WPICON_SALT = "prune.waypointsalt";
    public static final String KEY_TIMEZONE_ID = "prune.timezoneid";
    public static final String KEY_LATLON_RANGE = "prune.latlonrange";
    public static final String KEY_EARTHDATA_AUTH = "prune.earthdataauth";
    public static final String KEY_COMPRESSION_SETTINGS = "prune.compression";

    static {
        _configValues = Config.getDefaultProperties();
    }

    public static boolean loadDefaultFile() {
        if (DEFAULT_CONFIG_FILE.exists() && Config.loadFile(DEFAULT_CONFIG_FILE)) {
            return true;
        }
        return HOME_CONFIG_FILE.exists() && Config.loadFile(HOME_CONFIG_FILE);
    }

    public static boolean loadFile(File file) {
        Properties properties = Config.getDefaultProperties();
        boolean bl = false;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
                bl = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        _configValues.putAll((Map<?, ?>)properties);
        _colourScheme.loadFromHex(_configValues.getProperty(KEY_COLOUR_SCHEME));
        _pointColourer = ColourerFactory.createColourer(_configValues.getProperty(KEY_POINT_COLOURER));
        _recentFiles = new RecentFileList(_configValues.getProperty(KEY_RECENT_FILES));
        _unitSet = UnitSetLibrary.getUnitSet(_configValues.getProperty(KEY_UNITSET_KEY));
        Config.adjustSelectedMap();
        Config.setConfigInt(KEY_COORD_DISPLAY_FORMAT, 0);
        if (bl) {
            _configFile = file;
        }
        return bl;
    }

    private static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put(KEY_GPS_DEVICE, "usb:");
        properties.put(KEY_GPS_FORMAT, "garmin");
        properties.put(KEY_POVRAY_FONT, "crystal.ttf");
        properties.put(KEY_SHOW_MAP, "1");
        properties.put(KEY_EXIFTOOL_PATH, "exiftool");
        properties.put(KEY_GNUPLOT_PATH, "gnuplot");
        properties.put(KEY_GPSBABEL_PATH, "gpsbabel");
        properties.put(KEY_IMPORT_FILE_FORMAT, "-1");
        properties.put(KEY_KMZ_IMAGE_SIZE, "240");
        properties.put(KEY_ANTIALIAS, "1");
        properties.put(KEY_OSSCALING, "0");
        properties.put(KEY_AUTOSAVE_SETTINGS, "1");
        properties.put(KEY_UNITSET_KEY, "unitset.kilometres");
        properties.put(KEY_COORD_DISPLAY_FORMAT, "0");
        properties.put(KEY_HEIGHT_EXAGGERATION, "100");
        properties.put(KEY_TERRAIN_GRID_SIZE, "50");
        properties.put(KEY_ALTITUDE_TOLERANCE, "0");
        properties.put(KEY_WAYPOINT_ICON_SIZE, "1");
        properties.put(KEY_WPICON_SALT, "-1");
        return properties;
    }

    private static void adjustSelectedMap() {
        int n;
        int n2 = Config.getConfigInt(KEY_MAPSOURCE_INDEX);
        int n3 = Config.getConfigInt(KEY_NUM_FIXED_MAPS);
        if (n3 == 0) {
            n3 = 6;
        }
        if ((n = MapSourceLibrary.getNumFixedSources()) != n3 && (n2 >= n3 || n2 >= n)) {
            Config.setConfigInt(KEY_MAPSOURCE_INDEX, n2 += n - n3);
        }
        Config.setConfigInt(KEY_NUM_FIXED_MAPS, n);
    }

    private static int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        return n;
    }

    public static File getConfigFile() {
        return _configFile;
    }

    public static void setConfigFile(File file) {
        _configFile = file;
    }

    public static Properties getAllConfig() {
        _configValues.setProperty(KEY_RECENT_FILES, _recentFiles.getConfigString());
        return _configValues;
    }

    public static ColourScheme getColourScheme() {
        return _colourScheme;
    }

    public static PointColourer getPointColourer() {
        return _pointColourer;
    }

    public static RecentFileList getRecentFileList() {
        return _recentFiles;
    }

    public static void setConfigString(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            _configValues.remove(string);
        } else {
            _configValues.put(string, string2);
        }
    }

    public static void setConfigBoolean(String string, boolean bl) {
        if (string != null && !string.equals("")) {
            _configValues.put(string, bl ? "1" : "0");
        }
    }

    public static void setConfigInt(String string, int n) {
        if (string != null && !string.equals("")) {
            _configValues.put(string, "" + n);
        }
    }

    public static String getConfigString(String string) {
        return _configValues.getProperty(string);
    }

    public static boolean getConfigBoolean(String string) {
        String string2 = _configValues.getProperty(string);
        return string2 == null || string2.equals("1");
    }

    public static int getConfigInt(String string) {
        return Config.parseInt(_configValues.getProperty(string));
    }

    public static boolean isKeyBoolean(String string) {
        return string != null && (string.equals(KEY_SHOW_MAP) || string.equals(KEY_AUTOSAVE_SETTINGS) || string.equals(KEY_ONLINE_MODE) || string.equals(KEY_ANTIALIAS) || string.equals(KEY_OSSCALING));
    }

    public static void updateColourScheme() {
        Config.setConfigString(KEY_COLOUR_SCHEME, _colourScheme.toString());
    }

    public static void updatePointColourer(PointColourer pointColourer) {
        _pointColourer = pointColourer;
        Config.setConfigString(KEY_POINT_COLOURER, ColourerFactory.pointColourerToString(_pointColourer));
    }

    public static UnitSet getUnitSet() {
        return _unitSet;
    }

    public static void selectUnitSet(int n) {
        _unitSet = UnitSetLibrary.getUnitSet(n);
        Config.setConfigString(KEY_UNITSET_KEY, _unitSet.getNameKey());
    }

    private static boolean hasString(String string) {
        String string2 = Config.getConfigString(string);
        return string2 != null && !string2.isEmpty();
    }

    public static boolean hasUnsavedChanges() {
        return _configFile == null && Config.getConfigBoolean(KEY_AUTOSAVE_SETTINGS) && (Config.getConfigInt(KEY_MAPSOURCE_INDEX) > 0 || Config.hasString(KEY_MAPSOURCE_LIST) || Config.hasString(KEY_DISK_CACHE) || Config.hasString(KEY_EARTHDATA_AUTH) || Config.getConfigInt(KEY_POINT_COLOURER) > 0 || Config.getConfigInt(KEY_WAYPOINT_ICONS) > 0);
    }
}

