/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.DescriptorBasedUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt$isAllowedFakeOverriddenDeclaration$;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0014\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0015\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0019"}, d2={"allReservedWords", "", "", "reservedWords", "strictModeReservedWords", "getStrictModeReservedWords", "()Ljava/util/Set;", "isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "getExportCandidate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldDeclarationBeExported", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isAllowedFakeOverriddenDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "isExported", "isOverriddenExported", "toExportedVisibility", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "backend.js"})
public final class ExportModelGeneratorKt {
    @NotNull
    private static final Set<String> reservedWords;
    @NotNull
    private static final Set<String> strictModeReservedWords;
    @NotNull
    private static final Set<String> allReservedWords;

    private static final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass2 = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass2 != null ? IrUtilsKt.isInterface(irClass2) : false;
    }

    private static final IrDeclarationWithName getExportCandidate(IrDeclaration declaration) {
        if (!(declaration instanceof IrDeclarationWithVisibility) || !(declaration instanceof IrDeclarationWithName) || !((IrDeclarationWithVisibility)declaration).getVisibility().isPublicAPI() || DescriptorBasedUtilsKt.isExpect(declaration)) {
            return null;
        }
        if (declaration instanceof IrSimpleFunction) {
            IrProperty property2;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
            IrProperty irProperty2 = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property2 != null) {
                return Intrinsics.areEqual((Object)property2.getGetter(), (Object)declaration) ? (IrDeclarationWithName)property2 : null;
            }
        }
        return (IrDeclarationWithName)declaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldDeclarationBeExported(IrDeclarationWithName declaration, JsIrBackendContext context) {
        boolean bl;
        if (CollectionsKt.contains((Iterable)context.getAdditionalExportedDeclarationNames(), (Object)IrUtilsKt.getFqNameWhenAvailable(declaration))) {
            return true;
        }
        if (context.getAdditionalExportedDeclarations().contains(declaration)) {
            return true;
        }
        if (declaration instanceof IrOverridableDeclaration) {
            boolean overriddenNonEmpty;
            boolean bl2 = overriddenNonEmpty = !((Collection)((IrOverridableDeclaration)declaration).getOverriddenSymbols()).isEmpty();
            if (overriddenNonEmpty) {
                boolean bl3;
                if (ExportModelGeneratorKt.isOverriddenExported((IrOverridableDeclaration)declaration, context)) return true;
                IrSimpleFunction irSimpleFunction = declaration instanceof IrSimpleFunction ? (IrSimpleFunction)declaration : null;
                if (irSimpleFunction != null) {
                    if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny(irSimpleFunction)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) return true;
                if (!ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)declaration, context)) return false;
                return true;
            }
        }
        if (AnnotationUtilsKt.isJsExport(declaration)) {
            return true;
        }
        IrDeclarationParent parent2 = declaration.getParent();
        if (parent2 instanceof IrDeclarationWithName) {
            bl = ExportModelGeneratorKt.shouldDeclarationBeExported((IrDeclarationWithName)((Object)parent2), context);
            return bl;
        } else {
            if (!(parent2 instanceof IrAnnotationContainer)) return false;
            bl = AnnotationUtilsKt.isJsExport((IrAnnotationContainer)((Object)parent2));
        }
        return bl;
    }

    public static final boolean isAllowedFakeOverriddenDeclaration(@NotNull IrOverridableDeclaration<?> $this$isAllowedFakeOverriddenDeclaration, @NotNull JsIrBackendContext context) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter($this$isAllowedFakeOverriddenDeclaration, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default($this$isAllowedFakeOverriddenDeclaration, true, null, 2, null);
            if (IrJsUtilsKt.isExportedInterface(irOverridableDeclaration != null ? IrUtilsKt.getParentClassOrNull(irOverridableDeclaration) : null, context)) {
                return true;
            }
            Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$isAllowedFakeOverriddenDeclaration.getOverriddenSymbols()), (Function1)isAllowedFakeOverriddenDeclaration.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isAllowedFakeOverriddenDeclaration$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$any$iv = SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)isAllowedFakeOverriddenDeclaration.2.INSTANCE), (Function1)isAllowedFakeOverriddenDeclaration.3.INSTANCE), (Function1)isAllowedFakeOverriddenDeclaration.4.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrClassSymbol it = (IrClassSymbol)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)context.getIrBuiltIns().getEnumClass())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isOverriddenExported(@NotNull IrOverridableDeclaration<?> $this$isOverriddenExported, @NotNull JsIrBackendContext context) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isOverriddenExported, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$any$iv = $this$isOverriddenExported.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl2 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
                    if (!ExportModelGeneratorKt.shouldDeclarationBeExported((IrDeclarationWithName)irSymbolOwner, context)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isExported(@NotNull IrDeclaration $this$isExported, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isExported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate($this$isExported);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        return ExportModelGeneratorKt.shouldDeclarationBeExported(candidate2, context);
    }

    private static final ExportedVisibility toExportedVisibility(DescriptorVisibility $this$toExportedVisibility) {
        return Intrinsics.areEqual((Object)$this$toExportedVisibility, (Object)DescriptorVisibilities.PROTECTED) ? ExportedVisibility.PROTECTED : ExportedVisibility.DEFAULT;
    }

    @NotNull
    public static final Set<String> getStrictModeReservedWords() {
        return strictModeReservedWords;
    }

    public static final /* synthetic */ IrDeclarationWithName access$getExportCandidate(IrDeclaration declaration) {
        return ExportModelGeneratorKt.getExportCandidate(declaration);
    }

    public static final /* synthetic */ boolean access$shouldDeclarationBeExported(IrDeclarationWithName declaration, JsIrBackendContext context) {
        return ExportModelGeneratorKt.shouldDeclarationBeExported(declaration, context);
    }

    public static final /* synthetic */ ExportedVisibility access$toExportedVisibility(DescriptorVisibility $receiver) {
        return ExportModelGeneratorKt.toExportedVisibility($receiver);
    }

    public static final /* synthetic */ Set access$getAllReservedWords$p() {
        return allReservedWords;
    }

    public static final /* synthetic */ boolean access$isInterface(IrClassifierSymbol $receiver) {
        return ExportModelGeneratorKt.isInterface($receiver);
    }

    static {
        Object[] objectArray = new String[]{"break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "null", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with"};
        reservedWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"as", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"};
        strictModeReservedWords = SetsKt.setOf((Object[])objectArray);
        allReservedWords = SetsKt.plus(reservedWords, (Iterable)strictModeReservedWords);
    }
}

