/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.context.ApplicationContextConfigurer;
import io.micronaut.context.annotation.ContextConfigurer;
import io.micronaut.context.visitor.ContextConfigurerVisitor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations"})
@Deprecated
public class ServiceDescriptionProcessor
extends AbstractInjectAnnotationProcessor {
    private static final Set<String> SUPPORTED_ANNOTATIONS = Collections.emptySet();
    private static final Set<String> SUPPORTED_SERVICE_TYPES = Collections.singleton(ApplicationContextConfigurer.class.getName());
    private final Map<String, Set<String>> serviceDescriptors = new HashMap<String, Set<String>>();

    @Override
    protected String getIncrementalProcessorType() {
        return "org.gradle.annotation.processing.aggregating";
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<Element> originatingElements = new ArrayList<Element>();
        for (TypeElement typeElement : annotations) {
            Set<? extends javax.lang.model.element.Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (javax.lang.model.element.Element element : elements) {
                String name;
                TypeElement typeElement2;
                if (!(element instanceof TypeElement) || this.processGeneratedAnnotation(originatingElements, element, typeElement2 = (TypeElement)element, name = typeElement2.getQualifiedName().toString())) continue;
                this.processContextConfigurerAnnotation(originatingElements, element, typeElement2);
            }
        }
        if (roundEnv.processingOver() && !this.serviceDescriptors.isEmpty()) {
            this.classWriterOutputVisitor.writeServiceEntries(this.serviceDescriptors, originatingElements.toArray(Element.EMPTY_ELEMENT_ARRAY));
        }
        return true;
    }

    private void processContextConfigurerAnnotation(List<Element> originatingElements, javax.lang.model.element.Element element, TypeElement typeElement) {
        AnnotationMetadata annotationMetadata = this.annotationUtils.getAnnotationMetadata(element);
        Optional ann = annotationMetadata.findAnnotation(ContextConfigurer.class);
        if (ann.isPresent()) {
            JavaClassElement javaClassElement = this.javaVisitorContext.getElementFactory().newClassElement(typeElement, annotationMetadata);
            ContextConfigurerVisitor.assertNoConstructorForContextAnnotation((ClassElement)javaClassElement);
            List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                String serviceName = this.modelUtils.resolveTypeName(typeMirror);
                String serviceImpl = this.modelUtils.resolveTypeName(element.asType());
                if (!SUPPORTED_SERVICE_TYPES.contains(serviceName)) continue;
                this.serviceDescriptors.computeIfAbsent(serviceName, s1 -> new HashSet()).add(serviceImpl);
                originatingElements.add(new JavaClassElement(typeElement, AnnotationMetadata.EMPTY_METADATA, null));
            }
        }
        AnnotationUtils.invalidateCache();
    }

    private boolean processGeneratedAnnotation(List<Element> originatingElements, javax.lang.model.element.Element element, TypeElement typeElement, String name) {
        Generated generated = element.getAnnotation(Generated.class);
        if (generated != null) {
            String serviceName = generated.service();
            if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
                this.serviceDescriptors.computeIfAbsent(serviceName, s1 -> new HashSet()).add(name);
                originatingElements.add(new JavaClassElement(typeElement, AnnotationMetadata.EMPTY_METADATA, null));
            }
            return true;
        }
        return false;
    }
}

