/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.annotation.beans;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import io.micronaut.inject.ast.beans.BeanMethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.runtime.http.scope.RequestScope;
import io.micronaut.spring.beans.ImportedBy;
import io.micronaut.spring.core.type.ClassElementSpringMetadata;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.context.annotation.Scope;
import org.springframework.core.type.AnnotationMetadata;

@Internal
public final class ImportAnnotationVisitor
implements TypeElementVisitor<Object, Object> {
    static final String IMPORT_ANNOTATION = "io.micronaut.spring.beans.SpringImport";

    public void visitClass(ClassElement element, VisitorContext context) {
        List values;
        Class annType = element.getAnnotationType(IMPORT_ANNOTATION).orElse(null);
        if (annType != null && element.hasStereotype(annType) && !(values = element.getAnnotationValuesByType(annType)).isEmpty()) {
            for (AnnotationValue av : values) {
                AnnotationClassValue[] acv;
                for (AnnotationClassValue a : acv = av.annotationClassValues("value")) {
                    String className = a.getName();
                    context.getClassElement(className).ifPresent(typeToImport -> this.handleImport(element, context, (ClassElement)typeToImport));
                }
            }
        }
    }

    private void handleImport(ClassElement originatingElement, VisitorContext context, ClassElement typeToImport) {
        if (typeToImport.isAssignable(ImportSelector.class)) {
            this.importSelector(originatingElement, typeToImport, context);
        } else if (typeToImport.isAssignable(ImportBeanDefinitionRegistrar.class)) {
            this.handleImportRegistrar(originatingElement, typeToImport, context);
        } else if (typeToImport.hasAnnotation(Configuration.class)) {
            this.handleConfigurationImport(originatingElement, typeToImport, context);
        } else {
            BeanElementBuilder beanElementBuilder = originatingElement.addAssociatedBean(typeToImport);
            beanElementBuilder.inject();
            this.handleScopesAndQualifiers((Element)originatingElement, beanElementBuilder, typeToImport);
        }
    }

    private void handleImportRegistrar(ClassElement originatingElement, ClassElement typeToImport, VisitorContext context) {
        if (typeToImport.isPublic()) {
            originatingElement.addAssociatedBean(typeToImport).scope(AnnotationValue.builder(Singleton.class).build()).annotate(ImportedBy.class, builder -> builder.member("value", new AnnotationClassValue[]{new AnnotationClassValue(originatingElement.getName())}));
        }
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedAnnotationNames() {
        return Collections.singleton(IMPORT_ANNOTATION);
    }

    private void handleConfigurationImport(ClassElement originatingElement, ClassElement typeToImport, VisitorContext context) {
        BeanElementBuilder beanBuilder = originatingElement.addAssociatedBean(typeToImport).inject();
        ElementQuery instanceMethods = ElementQuery.ALL_METHODS.onlyInstance();
        ElementQuery beanMethods = instanceMethods.annotated(ann -> ann.hasDeclaredAnnotation(Bean.class));
        this.handleScopesAndQualifiers((Element)originatingElement, beanBuilder, typeToImport);
        beanBuilder.produceBeans(beanMethods, childBuilder -> {
            AnnotationValue r;
            MethodElement me = (MethodElement)childBuilder.getProducingElement();
            this.handleScopesAndQualifiers((Element)originatingElement, (BeanElementBuilder)childBuilder, typeToImport);
            AnnotationValue av = me.getAnnotation(Bean.class);
            if (av != null) {
                childBuilder.annotate(av);
            }
            if ((r = me.getAnnotation(Role.class)) != null) {
                childBuilder.annotate(r);
            }
            String initMethod = me.stringValue(Bean.class, "initMethod").orElse(null);
            String destroyMethod = me.stringValue(Bean.class, "destroyMethod").orElse(null);
            if (initMethod != null) {
                childBuilder.withMethods(instanceMethods.named(n -> n.equals(initMethod)), BeanMethodElement::postConstruct);
            }
            if (destroyMethod != null) {
                childBuilder.withMethods(instanceMethods.named(n -> n.equals(destroyMethod)), BeanMethodElement::preDestroy);
            }
        });
    }

    private void handleScopesAndQualifiers(Element originatingElement, BeanElementBuilder beanBuilder, ClassElement typeToImport) {
        beanBuilder.annotate(ImportedBy.class, builder -> builder.member("value", new AnnotationClassValue[]{new AnnotationClassValue(originatingElement.getName())}));
        String scopeName = typeToImport.stringValue(Scope.class).orElse(null);
        if (typeToImport.hasAnnotation(Primary.class)) {
            beanBuilder.annotate(io.micronaut.context.annotation.Primary.class);
        }
        if (scopeName != null) {
            switch (scopeName) {
                case "prototype": {
                    beanBuilder.annotate(Prototype.class);
                    break;
                }
                case "request": {
                    beanBuilder.annotate(RequestScope.class);
                    break;
                }
                default: {
                    this.handleDefaultScope(beanBuilder, (Element)typeToImport);
                    break;
                }
            }
        } else {
            this.handleDefaultScope(beanBuilder, (Element)typeToImport);
        }
    }

    private void handleDefaultScope(BeanElementBuilder childBuilder, Element element) {
        if (element.hasAnnotation(Lazy.class)) {
            boolean lazy = element.booleanValue(Lazy.class).orElse(true);
            if (lazy) {
                childBuilder.annotate(Singleton.class);
            } else {
                childBuilder.annotate(Context.class);
            }
        } else {
            childBuilder.annotate(Context.class);
        }
    }

    private void importSelector(ClassElement originatingElement, ClassElement importSelectorElement, VisitorContext context) {
        try {
            Object selectorObject = null;
            if (!(importSelectorElement.isAssignable(BeanClassLoaderAware.class) || importSelectorElement.isAssignable(BeanFactoryAware.class) || importSelectorElement.isAssignable(ResourceLoaderAware.class) || importSelectorElement.isAssignable(EnvironmentAware.class) || importSelectorElement.isAssignable(DeferredImportSelector.class))) {
                selectorObject = InstantiationUtils.tryInstantiate((String)importSelectorElement.getName(), (ClassLoader)this.getClass().getClassLoader()).orElse(null);
            }
            if (selectorObject instanceof ImportSelector) {
                ImportSelector selector = selectorObject;
                Object[] importedTypes = selector.selectImports((AnnotationMetadata)new ClassElementSpringMetadata(originatingElement));
                if (ArrayUtils.isNotEmpty((Object[])importedTypes)) {
                    for (Object importedType : importedTypes) {
                        context.getClassElement((String)importedType).ifPresent(typeToImport -> this.handleImport(originatingElement, context, (ClassElement)typeToImport));
                    }
                }
            } else {
                context.warn("Spring ImportSelector [" + importSelectorElement.getName() + "] found in @Import declaration on element [" + originatingElement.getName() + "] was ignored. Ensure that the type is present on the annotation processor classpath. Note that only simple ImportSelector implementations that do no implement Aware interfaces (which cannot run at build time) are supported.", (Element)originatingElement);
            }
        }
        catch (InstantiationException e) {
            context.fail("Spring ImportSelector [" + importSelectorElement.getName() + "] found in @Import declaration on element [" + originatingElement.getName() + "] must be placed on the annotation processor classpath: " + e.getMessage(), (Element)originatingElement);
        }
        catch (Exception e) {
            context.fail("Spring ImportSelector [" + importSelectorElement.getName() + "] found in @Import declaration on element [" + originatingElement.getName() + "] failed to import: " + e.getMessage(), (Element)originatingElement);
        }
    }
}

