/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.Utils;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JMethod
extends JNode {
    private static final long serialVersionUID = 3834526867464663751L;
    private static final ImageIcon ICON_MTH_DEF = Utils.openIcon("methdef_obj");
    private static final ImageIcon ICON_MTH_PRI = Utils.openIcon("methpri_obj");
    private static final ImageIcon ICON_MTH_PRO = Utils.openIcon("methpro_obj");
    private static final ImageIcon ICON_MTH_PUB = Utils.openIcon("methpub_obj");
    private static final ImageIcon ICON_CONSTRUCTOR = Utils.openIcon("constr_ovr");
    private static final ImageIcon ICON_SYNC = Utils.openIcon("synch_co");
    private final JavaMethod mth;
    private final JClass jParent;

    public JMethod(JavaMethod javaMethod, JClass jClass) {
        this.mth = javaMethod;
        this.jParent = jClass;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.mth;
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    public ArgType getReturnType() {
        return this.mth.getReturnType();
    }

    @Override
    public JClass getRootClass() {
        return this.jParent.getRootClass();
    }

    @Override
    public int getLine() {
        return this.mth.getDecompiledLine();
    }

    @Override
    public Icon getIcon() {
        AccessInfo accessFlags = this.mth.getAccessFlags();
        OverlayIcon icon = Utils.makeIcon(accessFlags, ICON_MTH_PUB, ICON_MTH_PRI, ICON_MTH_PRO, ICON_MTH_DEF);
        if (accessFlags.isConstructor()) {
            icon.add(ICON_CONSTRUCTOR);
        }
        if (accessFlags.isSynchronized()) {
            icon.add(ICON_SYNC);
        }
        return icon;
    }

    String makeBaseString() {
        if (this.mth.isClassInit()) {
            return "{...}";
        }
        StringBuilder base = new StringBuilder();
        if (this.mth.isConstructor()) {
            base.append(this.mth.getDeclaringClass().getName());
        } else {
            base.append(this.mth.getName());
        }
        base.append('(');
        Iterator it = this.mth.getArguments().iterator();
        while (it.hasNext()) {
            base.append(Utils.typeStr((ArgType)it.next()));
            if (!it.hasNext()) continue;
            base.append(", ");
        }
        base.append(')');
        return base.toString();
    }

    @Override
    public String makeString() {
        return Utils.typeFormat(this.makeBaseString(), this.getReturnType());
    }

    @Override
    public String makeLongString() {
        String name = this.mth.getDeclaringClass().getFullName() + "." + this.makeBaseString();
        return Utils.typeFormat(name, this.getReturnType());
    }

    public int hashCode() {
        return this.mth.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JMethod && this.mth.equals((Object)((JMethod)o).mth);
    }
}

