/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XSegment
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 8;
    }

    @Override
    public int getDataSize() {
        return XSegment.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XSegment(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XSegment() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XSegment.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public short get_x1() {
        log.finest("");
        return Native.getShort(this.pData + 0L);
    }

    public void set_x1(short v) {
        log.finest("");
        Native.putShort(this.pData + 0L, v);
    }

    public short get_y1() {
        log.finest("");
        return Native.getShort(this.pData + 2L);
    }

    public void set_y1(short v) {
        log.finest("");
        Native.putShort(this.pData + 2L, v);
    }

    public short get_x2() {
        log.finest("");
        return Native.getShort(this.pData + 4L);
    }

    public void set_x2(short v) {
        log.finest("");
        Native.putShort(this.pData + 4L, v);
    }

    public short get_y2() {
        log.finest("");
        return Native.getShort(this.pData + 6L);
    }

    public void set_y2(short v) {
        log.finest("");
        Native.putShort(this.pData + 6L, v);
    }

    @Override
    String getName() {
        return "XSegment";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(160);
        ret.append("x1 = ").append(this.get_x1()).append(", ");
        ret.append("y1 = ").append(this.get_y1()).append(", ");
        ret.append("x2 = ").append(this.get_x2()).append(", ");
        ret.append("y2 = ").append(this.get_y2()).append(", ");
        return ret.toString();
    }
}

