/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.FinalizationRequest;
import com.intellij.util.io.Page;
import com.intellij.util.io.PoolPageKey;
import com.intellij.util.io.RandomAccessDataFile;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class PagePool {
    private final Map<PoolPageKey, Page> myProtectedQueue;
    private final Map<PoolPageKey, Page> myProbationalQueue;
    private int finalizationId = 0;
    private final SortedMap<PoolPageKey, FinalizationRequest> myFinalizationQueue = new TreeMap<PoolPageKey, FinalizationRequest>();
    private final Object lock = new Object();
    private PoolPageKey lastFinalizedKey = null;
    private static int hits = 0;
    private static int cache_misses = 0;
    private static int same_page_hits = 0;
    private static int protected_queue_hits = 0;
    private static int probational_queue_hits = 0;
    private static int finalization_queue_hits = 0;
    public static final PagePool SHARED = new PagePool(SystemProperties.getIntProperty("idea.io.protected.pool.size", 256), SystemProperties.getIntProperty("idea.io.probatonal.pool.size", 256));
    private RandomAccessDataFile lastOwner = null;
    private long lastOffset = 0L;
    private Page lastHit = null;

    public PagePool(final int protectedPagesLimit, final int probationalPagesLimit) {
        this.myProbationalQueue = new LinkedHashMap<PoolPageKey, Page>(probationalPagesLimit * 2, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<PoolPageKey, Page> eldest) {
                if (this.size() > probationalPagesLimit) {
                    PagePool.this.scheduleFinalization(eldest.getValue());
                    return true;
                }
                return false;
            }
        };
        this.myProtectedQueue = new LinkedHashMap<PoolPageKey, Page>(protectedPagesLimit, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<PoolPageKey, Page> eldest) {
                if (this.size() > protectedPagesLimit) {
                    PagePool.this.myProbationalQueue.put(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPages(RandomAccessDataFile owner) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastOwner == owner) {
                this.scheduleFinalization(this.lastHit);
                this.lastHit = null;
                this.lastOwner = null;
            }
            boolean hasFlushes = this.scanQueue(owner, this.myProtectedQueue);
        }
        if (hasFlushes |= this.scanQueue(owner, this.myProbationalQueue)) {
            this.flushFinalizationQueue();
        }
    }

    private void flushFinalizationQueue() {
        FinalizationRequest request;
        while ((request = this.retrieveFinalizationRequest()) != null) {
            this.processFinalizationRequest(request);
        }
        return;
    }

    private boolean scanQueue(RandomAccessDataFile owner, Map<?, Page> queue) {
        Iterator<Page> iterator2 = queue.values().iterator();
        boolean hasFlushes = false;
        while (iterator2.hasNext()) {
            Page page = iterator2.next();
            if (page.getOwner() != owner) continue;
            this.scheduleFinalization(page);
            iterator2.remove();
            hasFlushes = true;
        }
        return hasFlushes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFinalization(Page page) {
        int curFinalizationId;
        Object object = this.lock;
        synchronized (object) {
            curFinalizationId = ++this.finalizationId;
        }
        FinalizationRequest request = page.prepareForFinalization(curFinalizationId);
        if (request == null) {
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.myFinalizationQueue.put(page.getKey(), request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinalizationRequest(FinalizationRequest request) {
        Page page = request.page;
        try {
            page.flushIfFinalizationIdIsEqualTo(request.finalizationId);
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.myFinalizationQueue.remove(page.getKey());
            }
            page.recycleIfFinalizationIdIsEqualTo(request.finalizationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FinalizationRequest retrieveFinalizationRequest() {
        FinalizationRequest request = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.myFinalizationQueue.isEmpty()) {
                PoolPageKey key;
                if (this.lastFinalizedKey == null) {
                    key = this.myFinalizationQueue.firstKey();
                } else {
                    PoolPageKey k = this.lastFinalizedKey;
                    PoolPageKey kk = new PoolPageKey((RandomAccessDataFile)k.getOwner(), ((RandomAccessDataFile)k.getOwner()).physicalLength());
                    SortedMap<PoolPageKey, FinalizationRequest> tail = this.myFinalizationQueue.tailMap(kk);
                    if (tail.isEmpty()) {
                        tail = this.myFinalizationQueue.tailMap(k);
                    }
                    key = tail.isEmpty() ? this.myFinalizationQueue.firstKey() : tail.firstKey();
                }
                this.lastFinalizedKey = key;
                request = (FinalizationRequest)this.myFinalizationQueue.get(key);
            } else {
                this.lastFinalizedKey = null;
            }
        }
        return request;
    }
}

