/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\n"}, d2={"checkPluginsArguments", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "useK2", "pluginClasspaths", "", "", "pluginOptions", "pluginConfigurations", "cli"})
@SourceDebugExtension(value={"SMAP\nCLICompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLICompiler.kt\norg/jetbrains/kotlin/cli/common/CLICompilerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,303:1\n1855#2,2:304\n1855#2,2:306\n*S KotlinDebug\n*F\n+ 1 CLICompiler.kt\norg/jetbrains/kotlin/cli/common/CLICompilerKt\n*L\n289#1:304,2\n293#1:306,2\n*E\n"})
public final class CLICompilerKt {
    public static final boolean checkPluginsArguments(@NotNull MessageCollector messageCollector, boolean useK2, @NotNull List<String> pluginClasspaths, @NotNull List<String> pluginOptions, @NotNull List<String> pluginConfigurations) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(pluginClasspaths, "pluginClasspaths");
        Intrinsics.checkNotNullParameter(pluginOptions, "pluginOptions");
        Intrinsics.checkNotNullParameter(pluginConfigurations, "pluginConfigurations");
        boolean hasErrors = false;
        for (String classpath : pluginClasspaths) {
            if (new File(classpath).exists()) continue;
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Plugin classpath entry points to a non-existent location: " + classpath, null, 4, null);
        }
        if (!((Collection)pluginConfigurations).isEmpty()) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.WARNING, "Argument -Xcompiler-plugin is experimental", null, 4, null);
            if (!useK2) {
                hasErrors = true;
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "-Xcompiler-plugin argument is allowed only for language version 2.0. Please use -Xplugin argument for language version 1.9 and below", null, 4, null);
            }
            if (!((Collection)pluginClasspaths).isEmpty() || !((Collection)pluginOptions).isEmpty()) {
                String it;
                StringBuilder stringBuilder2;
                hasErrors = true;
                StringBuilder $this$checkPluginsArguments_u24lambda_u242 = stringBuilder2 = new StringBuilder();
                boolean bl = false;
                StringBuilder stringBuilder3 = $this$checkPluginsArguments_u24lambda_u242.append("Mixing legacy and modern plugin arguments is prohibited. Please use only one syntax");
                Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append(...)");
                StringBuilder stringBuilder4 = $this$checkPluginsArguments_u24lambda_u242.append("Legacy arguments:");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append(...)");
                if (!((Collection)pluginClasspaths).isEmpty()) {
                    StringBuilder stringBuilder5 = $this$checkPluginsArguments_u24lambda_u242.append("  -Xplugin=" + CollectionsKt.joinToString$default(pluginClasspaths, ",", null, null, 0, null, null, 62, null));
                    Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(...)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append(...)");
                }
                Iterable $this$forEach$iv = pluginOptions;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    StringBuilder stringBuilder6 = $this$checkPluginsArguments_u24lambda_u242.append("  -P " + it);
                    Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(...)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append(...)");
                }
                StringBuilder stringBuilder7 = $this$checkPluginsArguments_u24lambda_u242.append("Modern arguments:");
                Intrinsics.checkNotNullExpressionValue(stringBuilder7, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder7.append('\n'), "append(...)");
                $this$forEach$iv = pluginConfigurations;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl3 = false;
                    StringBuilder stringBuilder8 = $this$checkPluginsArguments_u24lambda_u242.append("  -Xcompiler-plugin=" + it);
                    Intrinsics.checkNotNullExpressionValue(stringBuilder8, "append(...)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder8.append('\n'), "append(...)");
                }
                String string2 = stringBuilder2.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                String message2 = string2;
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, message2, null, 4, null);
            }
        }
        return !hasErrors;
    }
}

