/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public abstract class AbstractAdvancedSynthesizerFilter
extends RuleFilter {
    protected abstract Synthesizer getSynthesizer();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        int lemmaFrom;
        int postagFrom;
        String postagSelect = this.getRequired("postagSelect", arguments);
        String lemmaSelect = this.getRequired("lemmaSelect", arguments);
        String postagFromStr = this.getRequired("postagFrom", arguments);
        String lemmaFromStr = this.getRequired("lemmaFrom", arguments);
        if (postagFromStr.startsWith("marker")) {
            for (postagFrom = 0; postagFrom < patternTokens.length && patternTokens[postagFrom].getStartPos() < match.getFromPos(); ++postagFrom) {
            }
            ++postagFrom;
            if (postagFromStr.length() > 6) {
                postagFrom += Integer.parseInt(postagFromStr.replace("marker", ""));
            }
        } else {
            postagFrom = Integer.parseInt(postagFromStr);
        }
        if (postagFrom < 1 || postagFrom > patternTokens.length) {
            throw new IllegalArgumentException("AdvancedSynthesizerFilter: Index out of bounds in " + match.getRule().getFullId() + ", value: " + postagFromStr);
        }
        if (lemmaFromStr.startsWith("marker")) {
            for (lemmaFrom = 0; lemmaFrom < patternTokens.length && patternTokens[lemmaFrom].getStartPos() < match.getFromPos(); ++lemmaFrom) {
            }
            ++lemmaFrom;
            if (lemmaFromStr.length() > 6) {
                lemmaFrom += Integer.parseInt(lemmaFromStr.replace("marker", ""));
            }
        } else {
            lemmaFrom = Integer.parseInt(lemmaFromStr);
        }
        if (lemmaFrom < 1 || lemmaFrom > patternTokens.length) {
            throw new IllegalArgumentException("AdvancedSynthesizerFilter: Index out of bounds in " + match.getRule().getFullId() + ", value: " + lemmaFromStr);
        }
        String postagReplace = this.getOptional("postagReplace", arguments);
        String desiredLemma = this.getAnalyzedToken(patternTokens[lemmaFrom - 1], lemmaSelect).getLemma();
        String originalPostag = this.getAnalyzedToken(patternTokens[lemmaFrom - 1], lemmaSelect).getPOSTag();
        String desiredPostag = this.getAnalyzedToken(patternTokens[postagFrom - 1], postagSelect).getPOSTag();
        if (desiredPostag == null) {
            throw new IllegalArgumentException("AdvancedSynthesizerFilter: undefined POS tag for rule " + match.getRule().getFullId() + " with POS regex '" + postagSelect + "' for token: " + patternTokens[postagFrom - 1]);
        }
        if (postagReplace != null) {
            desiredPostag = this.getCompositePostag(lemmaSelect, postagSelect, originalPostag, desiredPostag, postagReplace);
        }
        boolean isWordCapitalized = StringTools.isCapitalizedWord(patternTokens[lemmaFrom - 1].getToken());
        boolean isWordAllupper = StringTools.isAllUppercase(patternTokens[lemmaFrom - 1].getToken());
        AnalyzedToken token = new AnalyzedToken("", desiredPostag, desiredLemma);
        String[] replacements = this.getSynthesizer().synthesize(token, desiredPostag, true);
        if (replacements.length > 0) {
            RuleMatch newMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
            newMatch.setType(match.getType());
            ArrayList<String> replacementsList = new ArrayList<String>();
            boolean suggestionUsed = false;
            for (String r : match.getSuggestedReplacements()) {
                for (String nr : replacements) {
                    if (this.isSuggestionException(nr, desiredPostag)) continue;
                    if (r.contains("{suggestion}") || r.contains("{Suggestion}") || r.contains("{SUGGESTION}")) {
                        suggestionUsed = true;
                    }
                    if (isWordCapitalized) {
                        nr = StringTools.uppercaseFirstChar(nr);
                    }
                    if (isWordAllupper) {
                        nr = nr.toUpperCase();
                    }
                    String completeSuggestion = r.replace("{suggestion}", nr);
                    completeSuggestion = completeSuggestion.replace("{Suggestion}", StringTools.uppercaseFirstChar(nr));
                    if (replacementsList.contains(completeSuggestion = completeSuggestion.replace("{SUGGESTION}", nr.toUpperCase()))) continue;
                    replacementsList.add(completeSuggestion);
                }
            }
            if (!suggestionUsed) {
                replacementsList.addAll(Arrays.asList(replacements));
            }
            ArrayList<String> adjustedReplacementsList = new ArrayList<String>();
            Rule rule = match.getRule();
            if (rule instanceof AbstractPatternRule) {
                Language lang = ((AbstractPatternRule)rule).getLanguage();
                for (String replacement : replacementsList) {
                    adjustedReplacementsList.add(lang.adaptSuggestion(replacement));
                }
            } else {
                adjustedReplacementsList = replacementsList;
            }
            newMatch.setSuggestedReplacements(adjustedReplacementsList);
            return newMatch;
        }
        return match;
    }

    private String getCompositePostag(String lemmaSelect, String postagSelect, String originalPostag, String desiredPostag, String postagReplace) {
        Pattern aPattern = Pattern.compile(lemmaSelect, 64);
        Pattern bPattern = Pattern.compile(postagSelect, 64);
        Matcher aMatcher = aPattern.matcher(originalPostag);
        Matcher bMatcher = bPattern.matcher(desiredPostag);
        String result = postagReplace;
        if (aMatcher.matches() && bMatcher.matches()) {
            String toReplace;
            String groupStr;
            int i;
            for (i = 1; i <= aMatcher.groupCount(); ++i) {
                groupStr = aMatcher.group(i);
                toReplace = "\\\\a" + i;
                result = result.replaceAll(toReplace, groupStr);
            }
            for (i = 1; i <= bMatcher.groupCount(); ++i) {
                groupStr = bMatcher.group(i);
                toReplace = "\\\\b" + i;
                result = result.replaceAll(toReplace, groupStr);
            }
        }
        return result;
    }

    protected boolean isSuggestionException(String token, String desiredPostag) {
        return false;
    }

    private AnalyzedToken getAnalyzedToken(AnalyzedTokenReadings aToken, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return analyzedToken;
        }
        return aToken.getAnalyzedToken(0);
    }
}

