/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.websocket;

import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.lib.connections.websocket.ConnectionDescriptor;
import com.sun.star.uno.RuntimeException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebsocketConnection
extends WebSocketClient
implements XConnection,
XConnectionBroadcaster {
    public static final boolean DEBUG = false;
    static final byte[] outgoingPrefix = new byte[]{117, 114, 112, 32};
    protected String _description;
    protected InputStream _inputStream;
    protected OutputStream _inputStreamWriter;
    protected ByteArrayOutputStream _outputStream;
    protected ArrayList<XStreamListener> _listeners;

    public WebsocketConnection(String description, ConnectionDescriptor desc) throws IOException, URISyntaxException, InterruptedException {
        super(new URI(desc.getURL()));
        this._description = description;
        PipedOutputStream inputStreamWriter = new PipedOutputStream();
        PipedInputStream inputPipe = new PipedInputStream(inputStreamWriter);
        this._inputStream = new BufferedInputStream(inputPipe);
        this._inputStreamWriter = inputStreamWriter;
        this._outputStream = new ByteArrayOutputStream();
        this._listeners = new ArrayList();
        this.connectBlocking();
    }

    @Override
    public void addStreamListener(XStreamListener aListener) throws RuntimeException {
        this._listeners.add(aListener);
    }

    @Override
    public void removeStreamListener(XStreamListener aListener) throws RuntimeException {
        this._listeners.remove(aListener);
    }

    private void notifyListeners_open() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.started();
        }
    }

    private void notifyListeners_close() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.closed();
        }
    }

    private void notifyListeners_error(com.sun.star.uno.Exception exception) {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.error(exception);
        }
    }

    @Override
    public int read(byte[][] bytes, int nBytesToRead) throws com.sun.star.io.IOException, RuntimeException {
        String errMessage = null;
        int read_bytes = 0;
        bytes[0] = new byte[nBytesToRead];
        try {
            int count;
            this._inputStreamWriter.flush();
            do {
                if ((count = this._inputStream.read(bytes[0], read_bytes, nBytesToRead - read_bytes)) != -1) continue;
                errMessage = "EOF reached - " + this.getDescription();
            } while ((read_bytes += count) >= 0 && read_bytes < nBytesToRead && count >= 0);
        }
        catch (IOException ioException) {
            errMessage = ioException.toString();
        }
        if (errMessage != null) {
            com.sun.star.io.IOException unoIOException = new com.sun.star.io.IOException(errMessage);
            this.notifyListeners_error(unoIOException);
            throw unoIOException;
        }
        return read_bytes;
    }

    @Override
    public void write(byte[] aData) throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._outputStream.write(aData);
        }
        catch (IOException ioException) {
            com.sun.star.io.IOException unoIOException = new com.sun.star.io.IOException(ioException);
            this.notifyListeners_error(unoIOException);
            throw unoIOException;
        }
    }

    @Override
    public void flush() throws com.sun.star.io.IOException, RuntimeException {
        byte[] accumulatedBytes = this._outputStream.toByteArray();
        this._outputStream.reset();
        byte[] outputBytes = new byte[accumulatedBytes.length + outgoingPrefix.length];
        System.arraycopy(outgoingPrefix, 0, outputBytes, 0, outgoingPrefix.length);
        System.arraycopy(accumulatedBytes, 0, outputBytes, outgoingPrefix.length, accumulatedBytes.length);
        this.send(outputBytes);
    }

    @Override
    public void close() throws RuntimeException {
        super.close();
    }

    @Override
    public String getDescription() throws RuntimeException {
        return this._description;
    }

    @Override
    public void onOpen(ServerHandshake handshakedata) {
        this.notifyListeners_open();
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.notifyListeners_close();
    }

    @Override
    public void onMessage(String message) {
        String[] messageParts = message.split(": ", 2);
        if (messageParts.length != 2) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(new ProtocolException(String.format("Received URP/WS message (%s) without a type specifier. Messages must be proceeded by 'urp: '", message))));
            return;
        }
        String messageType = messageParts[0];
        if (!messageType.equals("urp")) {
            return;
        }
        byte[] messageBytes = messageParts[1].getBytes(StandardCharsets.UTF_8);
        try {
            this._inputStreamWriter.write(messageBytes);
            this._inputStreamWriter.flush();
        }
        catch (IOException e) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(e));
            return;
        }
    }

    @Override
    public void onMessage(ByteBuffer message) {
        int i;
        byte[] prefixedMessageBytes = message.array();
        StringBuffer messageTypeBuf = new StringBuffer();
        boolean hasType = false;
        for (i = 0; i < prefixedMessageBytes.length - 1; ++i) {
            if (prefixedMessageBytes[i] == 58 && prefixedMessageBytes[i + 1] == 32) {
                hasType = true;
                break;
            }
            messageTypeBuf.append((char)prefixedMessageBytes[i]);
        }
        if (!hasType) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(new ProtocolException(String.format("Received URP/WS message (%s) without a type specifier. Binary messages must be proceeded by 'urp: '", message))));
            return;
        }
        String messageType = messageTypeBuf.toString();
        int messageStartIndex = i + 2;
        if (!messageType.equals("urp")) {
            return;
        }
        byte[] messageBytes = Arrays.copyOfRange(prefixedMessageBytes, messageStartIndex, prefixedMessageBytes.length);
        try {
            this._inputStreamWriter.write(messageBytes);
            this._inputStreamWriter.flush();
        }
        catch (IOException e) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(e));
            return;
        }
    }

    @Override
    public void onError(Exception ex) {
        this.notifyListeners_error(new com.sun.star.uno.Exception(ex));
    }
}

