/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import java.awt.GridBagLayout;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class JIntegerTextField
extends JTextField {
    private int maximumValue = Integer.MAX_VALUE;
    private int minimumValue = Integer.MIN_VALUE;
    public IntegerTextFieldNumberChangeListener numberChangeListener = null;
    public boolean skipNotificationOfNumberChangeListenerWhileTrue = false;

    public JIntegerTextField() {
        this(10);
    }

    public JIntegerTextField(int preferredWidthFromColumnCount) {
        super(preferredWidthFromColumnCount);
        this.setText("" + this.getDefaultValue());
        this.selectAll();
        AbstractDocument document = (AbstractDocument)this.getDocument();
        document.setDocumentFilter(new IntegerFilter(this));
        this.getDocument().addDocumentListener(new NumberListener());
    }

    private boolean allowNegativeNumbers() {
        return this.minimumValue < 0;
    }

    public int getDefaultValue() {
        return this.minimumValue > 0 ? 1 : 0;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getValue() {
        int number;
        String text = this.getText();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            number = Integer.parseInt(text);
        }
        catch (Exception e) {
            throw new RuntimeException("JIntegerTextField.getValue(), The text value could not be parsed. This should never happen.");
        }
        return number;
    }

    public static void main(String[] args2) {
        final JIntegerTextField integerTextField = new JIntegerTextField();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                integerTextField.runDemo();
            }
        });
    }

    private void notifyListenerIfNeeded() {
        Integer integer;
        if (this.skipNotificationOfNumberChangeListenerWhileTrue) {
            return;
        }
        if (this.numberChangeListener != null && (integer = this.getValidIntegerOrNull(this.getText())) != null) {
            this.numberChangeListener.integerTextFieldNumberChanged(this, integer);
        }
    }

    private void runDemo() {
        JFrame frame = new JFrame();
        frame.setLayout(new GridBagLayout());
        frame.setSize(300, 300);
        frame.add(this);
        frame.setDefaultCloseOperation(3);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public void setMaximumValue(int maximumValue) {
        this.maximumValue = maximumValue >= 9 ? maximumValue : 9;
    }

    public void setMinimumValue(int minimumValue) {
        this.minimumValue = minimumValue <= 1 ? minimumValue : 1;
    }

    public void setValue(int value) {
        value = value < this.minimumValue ? this.minimumValue : value;
        value = value > this.maximumValue ? this.maximumValue : value;
        this.setText("" + value);
    }

    private boolean isValidInteger(String text) {
        return this.getValidIntegerOrNull(text) != null;
    }

    private Integer getValidIntegerOrNull(String text) {
        int number;
        try {
            number = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (number < this.minimumValue || number > this.maximumValue) {
            return null;
        }
        if (!this.allowNegativeNumbers() && text.contains("-")) {
            return null;
        }
        return number;
    }

    public static interface IntegerTextFieldNumberChangeListener {
        public void integerTextFieldNumberChanged(JIntegerTextField var1, int var2);
    }

    private class IntegerFilter
    extends DocumentFilter {
        private JIntegerTextField parentField;
        private boolean skipFiltersWhileTrue = false;

        public IntegerFilter(JIntegerTextField parentField) {
            if (parentField == null) {
                throw new RuntimeException("IntegerTextField.IntegerFilter, The parent text field cannot be null.");
            }
            this.parentField = parentField;
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (this.skipFiltersWhileTrue) {
                super.remove(fb, offset, length);
                return;
            }
            String oldText = fb.getDocument().getText(0, fb.getDocument().getLength());
            StringBuilder newTextBuilder = new StringBuilder(oldText);
            newTextBuilder.delete(offset, offset + length);
            String newText = newTextBuilder.toString();
            if (newText.trim().isEmpty() || oldText.equals("-1")) {
                this.setFieldToDefaultValue();
            } else if (JIntegerTextField.this.allowNegativeNumbers() && newText.trim().equals("-")) {
                this.setFieldToNegativeOne();
            } else if (JIntegerTextField.this.isValidInteger(newText)) {
                super.remove(fb, offset, length);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String newChars, AttributeSet a) throws BadLocationException {
            if (this.skipFiltersWhileTrue) {
                super.replace(fb, offset, length, newChars, a);
                return;
            }
            int oldTextLength = fb.getDocument().getLength();
            String oldText = fb.getDocument().getText(0, oldTextLength);
            StringBuilder newTextBuilder = new StringBuilder(oldText);
            newTextBuilder.delete(offset, offset + length);
            newTextBuilder.insert(offset, newChars);
            String newText = newTextBuilder.toString();
            if (newText.trim().isEmpty()) {
                this.setFieldToDefaultValue();
            } else if (JIntegerTextField.this.allowNegativeNumbers() && newText.trim().equals("-")) {
                this.setFieldToNegativeOne();
            } else if (length == oldTextLength && JIntegerTextField.this.isValidInteger(newText.trim())) {
                super.replace(fb, 0, length, newText.trim(), a);
            } else if (JIntegerTextField.this.isValidInteger(newText)) {
                super.replace(fb, offset, length, newChars, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String newChars, AttributeSet a) throws BadLocationException {
            if (this.skipFiltersWhileTrue) {
                super.insertString(fb, offset, newChars, a);
                return;
            }
            String oldText = fb.getDocument().getText(0, fb.getDocument().getLength());
            StringBuilder newTextBuilder = new StringBuilder(oldText);
            newTextBuilder.insert(offset, newChars);
            String newText = newTextBuilder.toString();
            if (newText.trim().isEmpty()) {
                this.setFieldToDefaultValue();
            } else if (JIntegerTextField.this.allowNegativeNumbers() && newText.trim().equals("-")) {
                this.setFieldToNegativeOne();
            } else if (JIntegerTextField.this.isValidInteger(newText)) {
                super.insertString(fb, offset, newChars, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void setFieldToDefaultValue() {
            this.skipFiltersWhileTrue = true;
            String defaultValue = "" + this.parentField.getDefaultValue();
            this.parentField.setText(defaultValue);
            this.parentField.selectAll();
            this.skipFiltersWhileTrue = false;
        }

        private void setFieldToNegativeOne() {
            this.skipFiltersWhileTrue = true;
            this.parentField.setText("-1");
            this.parentField.select(1, 2);
            this.skipFiltersWhileTrue = false;
        }
    }

    private class NumberListener
    implements DocumentListener {
        private NumberListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JIntegerTextField.this.notifyListenerIfNeeded();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JIntegerTextField.this.notifyListenerIfNeeded();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JIntegerTextField.this.notifyListenerIfNeeded();
        }
    }
}

