/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import java.util.Locale;
import net.osmand.Collator;
import net.osmand.OsmAndCollator;
import net.osmand.StringMatcher;

public class CollatorStringMatcher
implements StringMatcher {
    private final Collator collator = OsmAndCollator.primaryCollator();
    private final StringMatcherMode mode;
    private final String part;

    public CollatorStringMatcher(String part, StringMatcherMode mode) {
        this.part = part.toLowerCase(Locale.getDefault());
        this.mode = mode;
    }

    public Collator getCollator() {
        return this.collator;
    }

    @Override
    public boolean matches(String name) {
        return CollatorStringMatcher.cmatches(this.collator, name, this.part, this.mode);
    }

    public static boolean cmatches(Collator collator, String base, String part, StringMatcherMode mode) {
        switch (mode) {
            case CHECK_CONTAINS: {
                return CollatorStringMatcher.ccontains(collator, base, part);
            }
            case CHECK_STARTS_FROM_SPACE: {
                return CollatorStringMatcher.cstartsWith(collator, base, part, true, true);
            }
            case CHECK_STARTS_FROM_SPACE_NOT_BEGINNING: {
                return CollatorStringMatcher.cstartsWith(collator, base, part, false, true);
            }
            case CHECK_ONLY_STARTS_WITH: {
                return CollatorStringMatcher.cstartsWith(collator, base, part, true, false);
            }
        }
        return false;
    }

    public static boolean ccontains(Collator collator, String base, String part) {
        int pos = 0;
        if (part.length() > 3 && (pos = CollatorStringMatcher.cindexOf(collator, pos, part.substring(0, 3), base)) == -1) {
            return false;
        }
        return (pos = CollatorStringMatcher.cindexOf(collator, pos, part, base)) != -1;
    }

    private static int cindexOf(Collator collator, int start, String part, String base) {
        for (int pos = start; pos <= base.length() - part.length(); ++pos) {
            if (!collator.equals(base.substring(pos, pos + part.length()), part)) continue;
            return pos;
        }
        return -1;
    }

    public static boolean cstartsWith(Collator collator, String searchInParam, String theStart, boolean checkBeginning, boolean checkSpaces) {
        boolean starts;
        String searchIn = searchInParam.toLowerCase(Locale.getDefault());
        int startLength = theStart.length();
        int searchInLength = searchIn.length();
        if (startLength == 0) {
            return true;
        }
        if (startLength > searchInLength) {
            return false;
        }
        if (checkBeginning && (starts = collator.equals(searchIn.substring(0, startLength), theStart))) {
            return true;
        }
        if (checkSpaces) {
            for (int i = 1; i <= searchInLength - startLength; ++i) {
                if (!CollatorStringMatcher.isSpace(searchIn.charAt(i - 1)) || CollatorStringMatcher.isSpace(searchIn.charAt(i)) || !collator.equals(searchIn.substring(i, i + startLength), theStart)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSpace(char c) {
        return !Character.isLetter(c) && !Character.isDigit(c);
    }

    public static enum StringMatcherMode {
        CHECK_ONLY_STARTS_WITH,
        CHECK_STARTS_FROM_SPACE,
        CHECK_STARTS_FROM_SPACE_NOT_BEGINNING,
        CHECK_CONTAINS;

    }
}

