/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.analysis.kuromoji;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.opensearch.index.analysis.AnalyzerProvider;
import org.opensearch.index.analysis.CharFilterFactory;
import org.opensearch.index.analysis.JapaneseStopTokenFilterFactory;
import org.opensearch.index.analysis.KuromojiAnalyzerProvider;
import org.opensearch.index.analysis.KuromojiBaseFormFilterFactory;
import org.opensearch.index.analysis.KuromojiIterationMarkCharFilterFactory;
import org.opensearch.index.analysis.KuromojiKatakanaStemmerFactory;
import org.opensearch.index.analysis.KuromojiNumberFilterFactory;
import org.opensearch.index.analysis.KuromojiPartOfSpeechFilterFactory;
import org.opensearch.index.analysis.KuromojiReadingFormFilterFactory;
import org.opensearch.index.analysis.KuromojiTokenizerFactory;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.Plugin;

public class AnalysisKuromojiPlugin
extends Plugin
implements AnalysisPlugin {
    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Collections.singletonMap("kuromoji_iteration_mark", KuromojiIterationMarkCharFilterFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        extra.put("kuromoji_baseform", KuromojiBaseFormFilterFactory::new);
        extra.put("kuromoji_part_of_speech", KuromojiPartOfSpeechFilterFactory::new);
        extra.put("kuromoji_readingform", KuromojiReadingFormFilterFactory::new);
        extra.put("kuromoji_stemmer", KuromojiKatakanaStemmerFactory::new);
        extra.put("ja_stop", JapaneseStopTokenFilterFactory::new);
        extra.put("kuromoji_number", KuromojiNumberFilterFactory::new);
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.singletonMap("kuromoji_tokenizer", KuromojiTokenizerFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.singletonMap("kuromoji", KuromojiAnalyzerProvider::new);
    }
}

