"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WINDOW = exports.MILLIS_MULTIPLIER = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.DEFAULT_ROLLING_COUNTER = exports.COMPONENTS = exports.CAPACITY = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const WINDOW = 3600;
exports.WINDOW = WINDOW;
const INTERVAL = 60;
exports.INTERVAL = INTERVAL;
const CAPACITY = WINDOW / INTERVAL * 2;
exports.CAPACITY = CAPACITY;
const MILLIS_MULTIPLIER = 1000;
exports.MILLIS_MULTIPLIER = MILLIS_MULTIPLIER;
const commonRequests = ['create', 'get', 'update', 'delete', 'add_samples']; // object of each component and its specific requests

const COMPONENTS = {
  application_analytics: commonRequests,
  operational_panels: [...commonRequests, 'fetch_visualization'],
  event_analytics: commonRequests,
  notebooks: [...commonRequests, 'run_sql_query', 'run_ppl_query', 'fetch_visualization'],
  trace_analytics: commonRequests,
  metrics_analytics: commonRequests,
  integrations: commonRequests
};
exports.COMPONENTS = COMPONENTS;

const GLOBAL_BASIC_COUNTER = (() => {
  const counter = {};
  Object.entries(COMPONENTS).forEach(([component, requests]) => {
    requests.forEach(request => {
      _lodash.default.set(counter, [component, request, 'total'], 0);
    });
  });
  return counter;
})();

exports.GLOBAL_BASIC_COUNTER = GLOBAL_BASIC_COUNTER;

const DEFAULT_ROLLING_COUNTER = (() => {
  const counter = {};
  Object.entries(COMPONENTS).forEach(([component, requests]) => {
    requests.forEach(request => {
      _lodash.default.set(counter, [component, request, 'count'], 0);

      _lodash.default.set(counter, [component, request, 'system_error'], 0);

      _lodash.default.set(counter, [component, request, 'user_error'], 0);
    });
  });
  return counter;
})();

exports.DEFAULT_ROLLING_COUNTER = DEFAULT_ROLLING_COUNTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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