/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpamResourceType {
    VPC("vpc"),
    SUBNET("subnet"),
    EIP("eip"),
    PUBLIC_IPV4_POOL("public-ipv4-pool"),
    IPV6_POOL("ipv6-pool"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpamResourceType> VALUE_MAP;
    private final String value;

    private IpamResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpamResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpamResourceType> knownValues() {
        EnumSet<IpamResourceType> knownValues = EnumSet.allOf(IpamResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpamResourceType.class, IpamResourceType::toString);
    }
}

