/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.FlowLog;

public class DescribeFlowLogsIterable
implements SdkIterable<DescribeFlowLogsResponse> {
    private final Ec2Client client;
    private final DescribeFlowLogsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFlowLogsIterable(Ec2Client client, DescribeFlowLogsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFlowLogsResponseFetcher();
    }

    public Iterator<DescribeFlowLogsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowLog> flowLogs() {
        Function<DescribeFlowLogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowLogs() != null) {
                return response.flowLogs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFlowLogsResponseFetcher
    implements SyncPageFetcher<DescribeFlowLogsResponse> {
        private DescribeFlowLogsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFlowLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFlowLogsResponse nextPage(DescribeFlowLogsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFlowLogsIterable.this.client.describeFlowLogs(DescribeFlowLogsIterable.this.firstRequest);
            }
            return DescribeFlowLogsIterable.this.client.describeFlowLogs((DescribeFlowLogsRequest)((Object)DescribeFlowLogsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

