/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse;
import software.amazon.awssdk.services.ec2.model.SnapshotTierStatus;

public class DescribeSnapshotTierStatusIterable
implements SdkIterable<DescribeSnapshotTierStatusResponse> {
    private final Ec2Client client;
    private final DescribeSnapshotTierStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSnapshotTierStatusIterable(Ec2Client client, DescribeSnapshotTierStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSnapshotTierStatusResponseFetcher();
    }

    public Iterator<DescribeSnapshotTierStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SnapshotTierStatus> snapshotTierStatuses() {
        Function<DescribeSnapshotTierStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotTierStatuses() != null) {
                return response.snapshotTierStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSnapshotTierStatusResponseFetcher
    implements SyncPageFetcher<DescribeSnapshotTierStatusResponse> {
        private DescribeSnapshotTierStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotTierStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSnapshotTierStatusResponse nextPage(DescribeSnapshotTierStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotTierStatusIterable.this.client.describeSnapshotTierStatus(DescribeSnapshotTierStatusIterable.this.firstRequest);
            }
            return DescribeSnapshotTierStatusIterable.this.client.describeSnapshotTierStatus((DescribeSnapshotTierStatusRequest)((Object)DescribeSnapshotTierStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

