/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.imputation;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.returntypes.ConditionalTreeSample;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.INodeView;
import java.util.Arrays;
import java.util.Random;

public class ImputeVisitor
implements MultiVisitor<ConditionalTreeSample> {
    public static double DEFAULT_INIT_VALUE = Double.MAX_VALUE;
    protected final boolean[] missing;
    protected float[] queryPoint;
    protected double anomalyRank;
    protected double distance;
    protected double centrality;
    protected long randomSeed;
    protected double randomRank;
    protected boolean converged;
    protected int pointIndex;
    protected int[] dimensionsUsed;
    protected BoundingBox box;

    public ImputeVisitor(float[] liftedPoint, float[] queryPoint, int[] liftedMissingIndexes, int[] missingIndexes, double centrality, long randomSeed) {
        this.queryPoint = Arrays.copyOf(queryPoint, queryPoint.length);
        this.missing = new boolean[queryPoint.length];
        this.centrality = centrality;
        this.randomSeed = randomSeed;
        this.dimensionsUsed = new int[queryPoint.length];
        if (missingIndexes == null) {
            missingIndexes = new int[]{};
        }
        for (int i = 0; i < missingIndexes.length; ++i) {
            CommonUtils.checkArgument(0 <= missingIndexes[i] && missingIndexes[i] < queryPoint.length, "Missing value indexes must be between 0 (inclusive) and queryPoint.length (exclusive)");
            this.missing[missingIndexes[i]] = true;
        }
        this.anomalyRank = DEFAULT_INIT_VALUE;
        this.distance = DEFAULT_INIT_VALUE;
    }

    public ImputeVisitor(float[] queryPoint, int numberOfMissingIndices, int[] missingIndexes) {
        this(queryPoint, Arrays.copyOf(queryPoint, queryPoint.length), Arrays.copyOf(missingIndexes, Math.min(numberOfMissingIndices, missingIndexes.length)), Arrays.copyOf(missingIndexes, Math.min(numberOfMissingIndices, missingIndexes.length)), 1.0, 0L);
    }

    ImputeVisitor(ImputeVisitor original) {
        int length = original.queryPoint.length;
        this.queryPoint = Arrays.copyOf(original.queryPoint, length);
        this.missing = Arrays.copyOf(original.missing, length);
        this.dimensionsUsed = new int[original.dimensionsUsed.length];
        this.randomSeed = new Random(original.randomSeed).nextLong();
        this.centrality = original.centrality;
        this.anomalyRank = DEFAULT_INIT_VALUE;
        this.distance = DEFAULT_INIT_VALUE;
    }

    @Override
    public void accept(INodeView node, int depthOfNode) {
        double probabilityOfSeparation;
        if (this.box == null) {
            this.box = (BoundingBox)node.getBoundingBox();
            probabilityOfSeparation = CommonUtils.getProbabilityOfSeparation(this.box, this.queryPoint);
        } else {
            probabilityOfSeparation = node.probailityOfSeparation(this.queryPoint);
        }
        boolean bl = this.converged = probabilityOfSeparation == 0.0;
        if (probabilityOfSeparation <= 0.0) {
            return;
        }
        this.anomalyRank = probabilityOfSeparation * this.scoreUnseen(depthOfNode, node.getMass()) + (1.0 - probabilityOfSeparation) * this.anomalyRank;
    }

    @Override
    public void acceptLeaf(INodeView leafNode, int depthOfNode) {
        float[] leafPoint = leafNode.getLeafPoint();
        this.pointIndex = leafNode.getLeafPointIndex();
        double distance = 0.0;
        for (int i = 0; i < this.queryPoint.length; ++i) {
            if (this.missing[i]) {
                this.queryPoint[i] = leafPoint[i];
                continue;
            }
            double t = this.queryPoint[i] - leafPoint[i];
            distance += Math.abs(t);
        }
        if (this.centrality < 1.0) {
            Random rng = new Random(this.randomSeed);
            this.randomSeed = rng.nextLong();
            this.randomRank = rng.nextDouble();
        }
        this.distance = distance;
        if (distance <= 0.0) {
            this.converged = true;
            this.anomalyRank = depthOfNode == 0 ? 0.0 : this.scoreSeen(depthOfNode, leafNode.getMass());
        } else {
            this.anomalyRank = this.scoreUnseen(depthOfNode, leafNode.getMass());
        }
    }

    @Override
    public ConditionalTreeSample getResult() {
        return new ConditionalTreeSample(this.pointIndex, this.box, this.distance, this.queryPoint);
    }

    @Override
    public boolean trigger(INodeView node) {
        int index;
        int n = index = node.getCutDimension();
        this.dimensionsUsed[n] = this.dimensionsUsed[n] + 1;
        return this.missing[index];
    }

    protected double getAnomalyRank() {
        return this.anomalyRank;
    }

    protected double getDistance() {
        return this.distance;
    }

    @Override
    public MultiVisitor<ConditionalTreeSample> newCopy() {
        return new ImputeVisitor(this);
    }

    double adjustedRank() {
        return (1.0 - this.centrality) * this.randomRank + this.centrality * this.anomalyRank;
    }

    protected boolean updateCombine(ImputeVisitor other) {
        return other.adjustedRank() < this.adjustedRank();
    }

    @Override
    public void combine(MultiVisitor<ConditionalTreeSample> other) {
        ImputeVisitor visitor = (ImputeVisitor)other;
        if (this.updateCombine(visitor)) {
            this.updateFrom(visitor);
        }
    }

    protected void updateFrom(ImputeVisitor visitor) {
        System.arraycopy(visitor.queryPoint, 0, this.queryPoint, 0, this.queryPoint.length);
        this.pointIndex = visitor.pointIndex;
        this.anomalyRank = visitor.anomalyRank;
        this.box = visitor.box;
        this.converged = visitor.converged;
        this.distance = visitor.distance;
    }

    protected double scoreSeen(int depth, int mass) {
        return CommonUtils.defaultScoreSeenFunction(depth, mass);
    }

    protected double scoreUnseen(int depth, int mass) {
        return CommonUtils.defaultScoreUnseenFunction(depth, mass);
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }
}

