/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import org.jooq.exception.DetachedException;
import org.jooq.impl.R2DBC;
import org.reactivestreams.Publisher;

final class DefaultConnectionFactory
implements ConnectionFactory {
    Connection connection;
    final boolean finalize;

    DefaultConnectionFactory(Connection connection) {
        this(connection, false);
    }

    DefaultConnectionFactory(Connection connection, boolean finalize) {
        this.connection = connection;
        this.finalize = finalize;
    }

    final Connection connectionOrThrow() {
        if (this.connection == null) {
            throw new DetachedException("R2DBC Connection not available or already closed");
        }
        return this.connection;
    }

    public final Publisher<? extends Connection> create() {
        return s -> s.onSubscribe(R2DBC.AbstractSubscription.onRequest(s, x -> {
            x.onNext((Object)new NonClosingConnection());
            x.onComplete();
        }));
    }

    public final ConnectionFactoryMetadata getMetadata() {
        return () -> this.connectionOrThrow().getMetadata().getDatabaseProductName();
    }

    final class NonClosingConnection
    implements Connection {
        NonClosingConnection() {
        }

        public Publisher<Void> beginTransaction() {
            return DefaultConnectionFactory.this.connectionOrThrow().beginTransaction();
        }

        public Publisher<Void> beginTransaction(TransactionDefinition definition) {
            return DefaultConnectionFactory.this.connectionOrThrow().beginTransaction(definition);
        }

        public Publisher<Void> close() {
            return s -> s.onSubscribe(R2DBC.AbstractSubscription.onRequest(s, x -> x.onComplete()));
        }

        public Publisher<Void> commitTransaction() {
            return DefaultConnectionFactory.this.connectionOrThrow().commitTransaction();
        }

        public Batch createBatch() {
            return DefaultConnectionFactory.this.connectionOrThrow().createBatch();
        }

        public Publisher<Void> createSavepoint(String name) {
            return DefaultConnectionFactory.this.connectionOrThrow().createSavepoint(name);
        }

        public Statement createStatement(String sql) {
            return DefaultConnectionFactory.this.connectionOrThrow().createStatement(sql);
        }

        public boolean isAutoCommit() {
            return DefaultConnectionFactory.this.connectionOrThrow().isAutoCommit();
        }

        public ConnectionMetadata getMetadata() {
            return DefaultConnectionFactory.this.connectionOrThrow().getMetadata();
        }

        public IsolationLevel getTransactionIsolationLevel() {
            return DefaultConnectionFactory.this.connectionOrThrow().getTransactionIsolationLevel();
        }

        public Publisher<Void> releaseSavepoint(String name) {
            return DefaultConnectionFactory.this.connectionOrThrow().releaseSavepoint(name);
        }

        public Publisher<Void> rollbackTransaction() {
            return DefaultConnectionFactory.this.connectionOrThrow().rollbackTransaction();
        }

        public Publisher<Void> rollbackTransactionToSavepoint(String name) {
            return DefaultConnectionFactory.this.connectionOrThrow().rollbackTransactionToSavepoint(name);
        }

        public Publisher<Void> setAutoCommit(boolean autoCommit) {
            return DefaultConnectionFactory.this.connectionOrThrow().setAutoCommit(autoCommit);
        }

        public Publisher<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
            return DefaultConnectionFactory.this.connectionOrThrow().setTransactionIsolationLevel(isolationLevel);
        }

        public Publisher<Boolean> validate(ValidationDepth depth) {
            return DefaultConnectionFactory.this.connectionOrThrow().validate(depth);
        }

        public Publisher<Void> setLockWaitTimeout(Duration timeout) {
            return DefaultConnectionFactory.this.connectionOrThrow().setLockWaitTimeout(timeout);
        }

        public Publisher<Void> setStatementTimeout(Duration timeout) {
            return DefaultConnectionFactory.this.connectionOrThrow().setStatementTimeout(timeout);
        }
    }
}

