/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.hwnet;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.DiskMetrics;
import org.opensearch.performanceanalyzer.commons.metrics_generator.DiskMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.metrics_generator.linux.LinuxDiskMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.os.SchemaFileParser;
import org.opensearch.performanceanalyzer.commons.util.Util;

public class Disks {
    private static Map<String, Map<String, Object>> diskKVMap = new HashMap<String, Map<String, Object>>();
    private static Map<String, Map<String, Object>> olddiskKVMap = new HashMap<String, Map<String, Object>>();
    private static long kvTimestamp = 0L;
    private static long oldkvTimestamp = 0L;
    private static Set<String> diskList = new HashSet<String>();
    private static final Logger LOG = LogManager.getLogger(Disks.class);
    private static LinuxDiskMetricsGenerator linuxDiskMetricsHandler = new LinuxDiskMetricsGenerator();
    private static String[] statKeys = new String[]{"majno", "minno", "name", "rdone", "rmerged", "rsectors", "rtime", "wdone", "wmerged", "wsectors", "wtime", "inprogressIO", "IOtime", "weightedIOtime"};
    private static SchemaFileParser.FieldTypes[] statTypes = new SchemaFileParser.FieldTypes[]{SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.STRING, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG};
    private static StringBuilder value;

    private static void listDisks() {
        try {
            File file = new File("/sys/block");
            File[] files = file.listFiles();
            if (files != null) {
                for (File dfile : files) {
                    if (dfile == null || dfile.getCanonicalPath().contains("/virtual/")) continue;
                    diskList.add(dfile.getName());
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Exception in calling listDisks with details: {}", new Supplier[]{() -> e.toString()});
        }
    }

    public static DiskMetricsGenerator getDiskMetricsHandler() {
        return linuxDiskMetricsHandler;
    }

    public static void addSample() {
        olddiskKVMap.clear();
        olddiskKVMap.putAll(diskKVMap);
        diskKVMap.clear();
        SchemaFileParser parser = new SchemaFileParser("/proc/diskstats", statKeys, statTypes);
        List<Map<String, Object>> sampleList = parser.parseMultiple();
        for (Map<String, Object> sample : sampleList) {
            String diskname = (String)sample.get("name");
            if (diskList.contains(diskname)) continue;
            diskKVMap.put(diskname, sample);
        }
        oldkvTimestamp = kvTimestamp;
        kvTimestamp = System.currentTimeMillis();
        Disks.calculateDiskMetrics();
    }

    private static void calculateDiskMetrics() {
        linuxDiskMetricsHandler.setDiskMetricsMap(Disks.getMetricsMap());
    }

    public static Map<String, DiskMetrics> getMetricsMap() {
        HashMap<String, DiskMetrics> map = new HashMap<String, DiskMetrics>();
        if (kvTimestamp > oldkvTimestamp) {
            for (Map.Entry<String, Map<String, Object>> entry : diskKVMap.entrySet()) {
                String disk = entry.getKey();
                Map<String, Object> m = entry.getValue();
                Map<String, Object> mold = olddiskKVMap.get(disk);
                if (mold == null) continue;
                DiskMetrics dm = new DiskMetrics();
                dm.name = (String)m.get("name");
                double rwdeltatime = 1.0 * (double)((Long)m.get("rtime") + (Long)m.get("wtime") - (Long)mold.get("rtime") - (Long)mold.get("wtime"));
                double rwdeltaiops = 1.0 * (double)((Long)m.get("rdone") + (Long)m.get("wdone") - (Long)mold.get("rdone") - (Long)mold.get("wdone"));
                double rwdeltasectors = 1.0 * (double)((Long)m.get("rsectors") + (Long)m.get("wsectors") - (Long)mold.get("rsectors") - (Long)mold.get("wsectors"));
                dm.utilization = rwdeltatime / (double)(kvTimestamp - oldkvTimestamp);
                dm.await = rwdeltaiops > 0.0 ? rwdeltatime / rwdeltaiops : 0.0;
                dm.serviceRate = rwdeltatime > 0.0 ? rwdeltasectors * 512.0 * 0.001 / rwdeltatime : 0.0;
                map.put(disk, dm);
            }
        }
        return map;
    }

    public static void runOnce() {
        Disks.addSample();
        System.out.println("disks: " + Disks.getMetricsMap());
    }

    static {
        Util.invokePrivileged(() -> Disks.listDisks());
        kvTimestamp = oldkvTimestamp = System.currentTimeMillis();
        value = new StringBuilder();
    }
}

