/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.net.httpserver.HttpServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.ClientServers;
import org.opensearch.performanceanalyzer.LocalhostConnectionUtil;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerThreads;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerWebServer;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.ScheduledMetricCollectorsExecutor;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.config.ConfigStatus;
import org.opensearch.performanceanalyzer.commons.config.PluginSettings;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.collectors.SampleAggregator;
import org.opensearch.performanceanalyzer.commons.stats.emitters.ISampler;
import org.opensearch.performanceanalyzer.commons.stats.emitters.PeriodicSamplers;
import org.opensearch.performanceanalyzer.commons.stats.listeners.IListener;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.config.TroubleshootingConfig;
import org.opensearch.performanceanalyzer.core.Util;
import org.opensearch.performanceanalyzer.metrics.MetricsRestUtil;
import org.opensearch.performanceanalyzer.metrics.handler.MetricsServerHandler;
import org.opensearch.performanceanalyzer.net.GRPCConnectionManager;
import org.opensearch.performanceanalyzer.net.NetClient;
import org.opensearch.performanceanalyzer.net.NetServer;
import org.opensearch.performanceanalyzer.rca.RcaController;
import org.opensearch.performanceanalyzer.rca.framework.core.MetricsDBProvider;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.JvmMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import org.opensearch.performanceanalyzer.rca.framework.sys.AllJvmSamplers;
import org.opensearch.performanceanalyzer.rca.listener.MisbehavingGraphOperateMethodListener;
import org.opensearch.performanceanalyzer.rca.samplers.BatchMetricsEnabledSampler;
import org.opensearch.performanceanalyzer.rca.samplers.MetricsDBFileSampler;
import org.opensearch.performanceanalyzer.rca.samplers.RcaStateSamplers;
import org.opensearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import org.opensearch.performanceanalyzer.rest.QueryBatchRequestHandler;
import org.opensearch.performanceanalyzer.rest.QueryMetricsRequestHandler;
import org.opensearch.performanceanalyzer.threads.ThreadProvider;
import org.opensearch.performanceanalyzer.threads.exceptions.PAThreadException;

public class PerformanceAnalyzerApp {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerApp.class);
    public static final int READER_RESTART_MAX_ATTEMPTS = 12;
    private static final int EXCEPTION_QUEUE_LENGTH = 1;
    private static final ScheduledMetricCollectorsExecutor METRIC_COLLECTOR_EXECUTOR = new ScheduledMetricCollectorsExecutor(1, false);
    private static final ScheduledExecutorService netOperationsExecutor = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("network-thread-%d").build());
    private static RcaController rcaController = null;
    private static final ThreadProvider THREAD_PROVIDER = new ThreadProvider();
    public static PeriodicSamplers PERIODIC_SAMPLERS;
    public static final BlockingQueue<PAThreadException> exceptionQueue;

    public static void initAggregators() {
        ServiceMetrics.READER_METRICS_AGGREGATOR = new SampleAggregator((MeasurementSet[])ReaderMetrics.values());
        ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR = new SampleAggregator((MeasurementSet[])RcaGraphMetrics.values());
        ServiceMetrics.RCA_RUNTIME_METRICS_AGGREGATOR = new SampleAggregator((MeasurementSet[])RcaRuntimeMetrics.values());
        ServiceMetrics.RCA_VERTICES_METRICS_AGGREGATOR = new SampleAggregator((MeasurementSet[])RcaVerticesMetrics.values());
        MisbehavingGraphOperateMethodListener MISBEHAVING_NODES_LISTENER = new MisbehavingGraphOperateMethodListener();
        ServiceMetrics.ERRORS_AND_EXCEPTIONS_AGGREGATOR = new SampleAggregator(MISBEHAVING_NODES_LISTENER.getMeasurementsListenedTo(), (IListener)MISBEHAVING_NODES_LISTENER, (MeasurementSet[])ExceptionsAndErrors.values());
        ServiceMetrics.PERIODIC_SAMPLE_AGGREGATOR = new SampleAggregator(PerformanceAnalyzerApp.getPeriodicMeasurementSets());
        ServiceMetrics.initStatsReporter();
    }

    public static void main(String[] args) {
        StatsCollector.STATS_TYPE = "agent-stats-metadata";
        PluginSettings settings = PluginSettings.instance();
        if (ConfigStatus.INSTANCE.haveValidConfig()) {
            AppContext appContext = new AppContext();
            PERIODIC_SAMPLERS = new PeriodicSamplers(ServiceMetrics.PERIODIC_SAMPLE_AGGREGATOR, PerformanceAnalyzerApp.getAllSamplers(appContext), (long)(((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(StatsCollector.class)).samplingInterval / 2), TimeUnit.MILLISECONDS);
            METRIC_COLLECTOR_EXECUTOR.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)StatsCollector.instance());
            METRIC_COLLECTOR_EXECUTOR.setEnabled(true);
            METRIC_COLLECTOR_EXECUTOR.start();
            GRPCConnectionManager connectionManager = new GRPCConnectionManager(settings.getHttpsEnabled());
            ClientServers clientServers = PerformanceAnalyzerApp.createClientServers(connectionManager, appContext);
            PerformanceAnalyzerApp.addShutdownHook(clientServers);
            PerformanceAnalyzerApp.startErrorHandlingThread(THREAD_PROVIDER, exceptionQueue);
            PerformanceAnalyzerApp.startReaderThread(appContext, THREAD_PROVIDER);
            PerformanceAnalyzerApp.startGrpcServerThread(clientServers.getNetServer(), THREAD_PROVIDER);
            PerformanceAnalyzerApp.startWebServerThread(clientServers.getHttpServer(), THREAD_PROVIDER);
            PerformanceAnalyzerApp.startRcaTopLevelThread(clientServers, connectionManager, appContext, THREAD_PROVIDER);
        } else {
            LOG.error("Performance analyzer app stopped due to invalid config status.");
            StatsCollector.instance().logException(StatExceptionCode.INVALID_CONFIG_RCA_AGENT_STOPPED);
        }
    }

    private static void startRcaTopLevelThread(ClientServers clientServers, GRPCConnectionManager connectionManager, AppContext appContext, ThreadProvider threadProvider) {
        rcaController = new RcaController(threadProvider, netOperationsExecutor, connectionManager, clientServers, Util.DATA_DIR, 5000L, 60000L, appContext, new MetricsDBProvider());
        PerformanceAnalyzerApp.startRcaTopLevelThread(rcaController, threadProvider);
    }

    public static Thread startRcaTopLevelThread(RcaController rcaController1, ThreadProvider threadProvider) {
        return PerformanceAnalyzerApp.startRcaTopLevelThread(rcaController1, threadProvider, "");
    }

    public static Thread startRcaTopLevelThread(RcaController rcaController1, ThreadProvider threadProvider, String nodeName) {
        Thread rcaControllerThread = threadProvider.createThreadForRunnable(() -> rcaController1.run(), PerformanceAnalyzerThreads.RCA_CONTROLLER, nodeName);
        rcaControllerThread.start();
        return rcaControllerThread;
    }

    public static Thread startErrorHandlingThread(ThreadProvider threadProvider, BlockingQueue<PAThreadException> errorQueue) {
        Thread errorHandlingThread = threadProvider.createThreadForRunnable(() -> {
            try {
                while (true) {
                    PAThreadException exception = (PAThreadException)errorQueue.take();
                    PerformanceAnalyzerApp.handle(exception);
                }
            }
            catch (InterruptedException e) {
                LOG.error("Exception handling thread interrupted. Reason: {}", (Object)e.getMessage(), (Object)e);
                StatsCollector.instance().logException(StatExceptionCode.ERROR_HANDLER_THREAD_STOPPED);
                return;
            }
        }, PerformanceAnalyzerThreads.PA_ERROR_HANDLER);
        errorHandlingThread.start();
        return errorHandlingThread;
    }

    private static void handle(PAThreadException exception) {
        LOG.error("Thread: {} ran into an uncaught exception: {}", (Object)exception.getPaThreadName(), (Object)exception.getInnerThrowable(), (Object)exception);
        StatsCollector.instance().logException(StatExceptionCode.READER_METRICS_PROCESSOR_ERROR);
    }

    public static Thread startWebServerThread(HttpServer server, ThreadProvider threadProvider) {
        Thread webServerThread = threadProvider.createThreadForRunnable(server::start, PerformanceAnalyzerThreads.WEB_SERVER);
        webServerThread.setDaemon(true);
        webServerThread.start();
        return webServerThread;
    }

    public static Thread startGrpcServerThread(NetServer server, ThreadProvider threadProvider) {
        Thread grpcServerThread = threadProvider.createThreadForRunnable(server, PerformanceAnalyzerThreads.GRPC_SERVER);
        grpcServerThread.setDaemon(true);
        grpcServerThread.start();
        return grpcServerThread;
    }

    public static void startReaderThread(AppContext appContext, ThreadProvider threadProvider) {
        PluginSettings settings = PluginSettings.instance();
        Thread readerThread = threadProvider.createThreadForRunnable(() -> {
            int retryAttemptLeft = 12;
            while (retryAttemptLeft > 0) {
                try {
                    ReaderMetricsProcessor mp = new ReaderMetricsProcessor(settings.getMetricsLocation(), true, appContext);
                    ReaderMetricsProcessor.setCurrentInstance(mp);
                    mp.run();
                }
                catch (Throwable e) {
                    LOG.error("Error in ReaderMetricsProcessor...restarting, retryCount left: {}.Exception: {}", (Object)(--retryAttemptLeft), (Object)e.getMessage());
                    StatsCollector.instance().logException(StatExceptionCode.READER_RESTART_PROCESSING);
                    if (TroubleshootingConfig.getEnableDevAssert()) break;
                    if (retryAttemptLeft > 0) continue;
                    PerformanceAnalyzerApp.handleReaderThreadFailed();
                }
            }
        }, PerformanceAnalyzerThreads.PA_READER);
        readerThread.start();
    }

    private static void handleReaderThreadFailed() {
        try {
            LOG.info("Exhausted {} attempts - unable to start Reader Thread successfully; disable PA", (Object)12);
            LocalhostConnectionUtil.disablePA();
            LOG.info("PA disable succeeded. ");
            StatsCollector.instance().logException(StatExceptionCode.READER_ERROR_PA_DISABLE_SUCCESS);
        }
        catch (Throwable e) {
            LOG.error(e.getMessage());
            StatsCollector.instance().logException(StatExceptionCode.READER_ERROR_PA_DISABLE_FAILED);
        }
        finally {
            PerformanceAnalyzerApp.cleanupAndExit();
        }
    }

    private static void cleanupAndExit() {
        LOG.error("Reader thread not coming up successfully - Shutting down RCA Runtime");
        StatsCollector.instance().logException(StatExceptionCode.READER_ERROR_RCA_AGENT_STOPPED);
        System.exit(1);
    }

    public static ClientServers createClientServers(GRPCConnectionManager connectionManager, AppContext appContext) {
        PluginSettings settings = PluginSettings.instance();
        boolean useHttps = settings.getHttpsEnabled();
        return PerformanceAnalyzerApp.createClientServers(connectionManager, settings.getRpcPort(), new MetricsServerHandler(), new MetricsRestUtil(), useHttps, settings.getWebServicePort(), settings.getSettingValue("webservice-bind-host"), appContext);
    }

    public static ClientServers createClientServers(GRPCConnectionManager connectionManager, int rpcPort, MetricsServerHandler metricsServerHandler, MetricsRestUtil metricsRestUtil, boolean useHttps, int webServerPort, String hostFromSetting, AppContext appContext) {
        NetServer netServer = new NetServer(rpcPort, 1, useHttps);
        NetClient netClient = new NetClient(connectionManager);
        if (metricsServerHandler != null) {
            netServer.setMetricsHandler(metricsServerHandler);
        }
        HttpServer httpServer = PerformanceAnalyzerWebServer.createInternalServer(webServerPort, hostFromSetting, useHttps);
        if (metricsRestUtil != null) {
            QueryMetricsRequestHandler queryMetricsRequestHandler = new QueryMetricsRequestHandler(netClient, metricsRestUtil, appContext);
            httpServer.createContext("/_plugins/_performanceanalyzer/metrics", queryMetricsRequestHandler);
            httpServer.createContext("/_plugins/_performanceanalyzer/metrics", queryMetricsRequestHandler);
            QueryBatchRequestHandler queryBatchRequestHandler = new QueryBatchRequestHandler(netClient, metricsRestUtil);
            httpServer.createContext("/_plugins/_performanceanalyzer/batch", queryBatchRequestHandler);
            httpServer.createContext("/_plugins/_performanceanalyzer/batch", queryBatchRequestHandler);
        }
        return new ClientServers(httpServer, netServer, netClient);
    }

    public static List<ISampler> getAllSamplers(AppContext appContext) {
        ArrayList<ISampler> allSamplers = new ArrayList<ISampler>();
        allSamplers.addAll(AllJvmSamplers.getJvmSamplers());
        allSamplers.add(RcaStateSamplers.getRcaEnabledSampler(appContext));
        allSamplers.add(new BatchMetricsEnabledSampler(appContext));
        allSamplers.add(new MetricsDBFileSampler(appContext));
        return allSamplers;
    }

    private static MeasurementSet[] getPeriodicMeasurementSets() {
        ArrayList<Enum> measurementSets = new ArrayList<Enum>();
        measurementSets.addAll(Arrays.asList(JvmMetrics.values()));
        measurementSets.add(RcaRuntimeMetrics.RCA_ENABLED);
        measurementSets.add(ReaderMetrics.BATCH_METRICS_ENABLED);
        measurementSets.add(ReaderMetrics.METRICSDB_NUM_FILES);
        measurementSets.add(ReaderMetrics.METRICSDB_SIZE_FILES);
        measurementSets.add(ReaderMetrics.METRICSDB_NUM_UNCOMPRESSED_FILES);
        measurementSets.add(ReaderMetrics.METRICSDB_SIZE_UNCOMPRESSED_FILES);
        return measurementSets.toArray(new MeasurementSet[0]);
    }

    public static RcaController getRcaController() {
        return rcaController;
    }

    @VisibleForTesting
    public static void setRcaController(RcaController rcaController) {
        PerformanceAnalyzerApp.rcaController = rcaController;
    }

    private static void addShutdownHook(ClientServers clientServers) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("Trying to shutdown performance analyzer gracefully");
            PerformanceAnalyzerApp.shutDownGracefully(clientServers);
        }));
    }

    private static void shutDownGracefully(ClientServers clientServers) {
        rcaController.stop();
        clientServers.getNetServer().shutdown();
        clientServers.getHttpServer().stop(3);
        ReaderMetricsProcessor.getInstance().shutdown();
    }

    static {
        PerformanceAnalyzerApp.initAggregators();
        Objects.requireNonNull(ServiceMetrics.STATS_REPORTER, "Service Metrics(Stat) Reporter should not be null");
        exceptionQueue = new ArrayBlockingQueue<PAThreadException>(1);
    }
}

