/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import org.opensearch.performanceanalyzer.decisionmaker.actions.SuppressibleAction;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class AdmissionControlAction
extends SuppressibleAction {
    public static final String NAME = "AdmissionControlAction";
    public static final long DEFAULT_COOL_OFF_PERIOD_IN_MILLIS = TimeUnit.MINUTES.toMillis(15L);
    private final NodeKey esNode;
    private final String controllerName;
    private final boolean canUpdate;
    private final double desiredValue;
    private final double currentValue;

    public AdmissionControlAction(AppContext appContext, NodeKey esNode, String controllerName, boolean canUpdate, double desiredValue, double currentValue) {
        super(appContext);
        this.esNode = esNode;
        this.canUpdate = canUpdate;
        this.desiredValue = desiredValue;
        this.currentValue = currentValue;
        this.controllerName = controllerName;
    }

    public static Builder newBuilder(NodeKey esNode, String controllerName, AppContext appContext, RcaConf conf) {
        return new Builder(esNode, controllerName, appContext, conf);
    }

    public String getControllerName() {
        return this.controllerName;
    }

    @Override
    public boolean canUpdate() {
        return this.canUpdate;
    }

    @Override
    public long coolOffPeriodInMillis() {
        return DEFAULT_COOL_OFF_PERIOD_IN_MILLIS;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public List<NodeKey> impactedNodes() {
        return Collections.singletonList(this.esNode);
    }

    @Override
    public Map<NodeKey, ImpactVector> impact() {
        ImpactVector impactVector = new ImpactVector();
        if (this.desiredValue > this.currentValue) {
            impactVector.increasesPressure(ImpactVector.Dimension.ADMISSION_CONTROL);
        } else if (this.desiredValue < this.currentValue) {
            impactVector.decreasesPressure(ImpactVector.Dimension.ADMISSION_CONTROL);
        } else {
            impactVector.noImpact(ImpactVector.Dimension.ADMISSION_CONTROL);
        }
        return Collections.singletonMap(this.esNode, impactVector);
    }

    @Override
    public String summary() {
        Summary summary = new Summary(this.esNode.getNodeId().toString(), this.esNode.getHostAddress().toString(), this.desiredValue, this.currentValue, DEFAULT_COOL_OFF_PERIOD_IN_MILLIS, this.canUpdate);
        return summary.toJson();
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public double getDesiredValue() {
        return this.desiredValue;
    }

    public static class Summary {
        public static final String ID = "Id";
        public static final String IP = "Ip";
        public static final String DESIRED_VALUE = "desiredValue";
        public static final String CURRENT_VALUE = "currentValue";
        public static final String COOL_OFF_PERIOD = "coolOffPeriodInMillis";
        public static final String CAN_UPDATE = "canUpdate";
        @SerializedName(value="Id")
        private String id;
        @SerializedName(value="Ip")
        private String ip;
        @SerializedName(value="desiredValue")
        private double desiredValue;
        @SerializedName(value="currentValue")
        private double currentValue;
        @SerializedName(value="coolOffPeriodInMillis")
        private long coolOffPeriodInMillis;
        @SerializedName(value="canUpdate")
        private boolean canUpdate;

        public Summary(String id, String ip, double desiredValue, double currentValue, long coolOffPeriodInMillis, boolean canUpdate) {
            this.id = id;
            this.ip = ip;
            this.desiredValue = desiredValue;
            this.currentValue = currentValue;
            this.coolOffPeriodInMillis = coolOffPeriodInMillis;
            this.canUpdate = canUpdate;
        }

        public String toJson() {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            return gson.toJson((Object)this);
        }

        public String getId() {
            return this.id;
        }

        public String getIp() {
            return this.ip;
        }

        public double getCurrentValue() {
            return this.currentValue;
        }

        public double getDesiredValue() {
            return this.desiredValue;
        }

        public long getCoolOffPeriodInMillis() {
            return this.coolOffPeriodInMillis;
        }

        public boolean getCanUpdate() {
            return this.canUpdate;
        }
    }

    public static final class Builder {
        private final String controllerName;
        private final NodeKey esNode;
        private final AppContext appContext;
        private final RcaConf rcaConf;
        private Double currentValue;
        private Double desiredValue;

        private Builder(NodeKey esNode, String controllerName, AppContext appContext, RcaConf conf) {
            this.esNode = esNode;
            this.controllerName = controllerName;
            this.appContext = appContext;
            this.rcaConf = conf;
        }

        public Builder currentValue(Double currentValue) {
            this.currentValue = currentValue;
            return this;
        }

        public Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public AdmissionControlAction build() {
            boolean canUpdate = this.desiredValue != 0.0;
            return new AdmissionControlAction(this.appContext, this.esNode, this.controllerName, canUpdate, this.desiredValue, this.currentValue);
        }
    }
}

