/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.tools.democonfig;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.opensearch.security.tools.democonfig.Certificates;
import org.opensearch.security.tools.democonfig.Installer;

public class CertificateGenerator {
    private final Installer installer;

    public CertificateGenerator(Installer installer) {
        this.installer = installer;
    }

    public void createDemoCertificates() {
        for (Certificates cert : Certificates.values()) {
            String filePath = this.installer.OPENSEARCH_CONF_DIR + File.separator + cert.getFileName();
            CertificateGenerator.writeCertificateToFile(filePath, cert.getContent());
        }
    }

    static void writeCertificateToFile(String filePath, String content) {
        try {
            FileWriter fileWriter = new FileWriter(filePath, StandardCharsets.UTF_8);
            fileWriter.write(content);
            fileWriter.close();
        }
        catch (IOException e) {
            System.err.println("Error writing certificate file: " + filePath);
            System.exit(-1);
        }
    }
}

