/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.asyncquery.model;

import com.google.gson.Gson;
import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class AsyncQueryJobMetadata {
    private String applicationId;
    private String jobId;
    private boolean isDropIndexQuery;
    private String resultIndex;

    public AsyncQueryJobMetadata(String applicationId, String jobId, String resultIndex) {
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.isDropIndexQuery = false;
        this.resultIndex = resultIndex;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public static XContentBuilder convertToXContent(AsyncQueryJobMetadata metadata) throws Exception {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("jobId", metadata.getJobId());
        builder.field("applicationId", metadata.getApplicationId());
        builder.field("isDropIndexQuery", metadata.isDropIndexQuery());
        builder.field("resultIndex", metadata.getResultIndex());
        builder.endObject();
        return builder;
    }

    public static AsyncQueryJobMetadata toJobMetadata(String json) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, json);){
            AsyncQueryJobMetadata asyncQueryJobMetadata = AsyncQueryJobMetadata.toJobMetadata(parser);
            return asyncQueryJobMetadata;
        }
    }

    public static AsyncQueryJobMetadata toJobMetadata(XContentParser parser) throws IOException {
        String jobId = null;
        String applicationId = null;
        boolean isDropIndexQuery = false;
        String resultIndex = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "jobId": {
                    jobId = parser.textOrNull();
                    continue block12;
                }
                case "applicationId": {
                    applicationId = parser.textOrNull();
                    continue block12;
                }
                case "isDropIndexQuery": {
                    isDropIndexQuery = parser.booleanValue();
                    continue block12;
                }
                case "resultIndex": {
                    resultIndex = parser.textOrNull();
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        if (jobId == null || applicationId == null) {
            throw new IllegalArgumentException("jobId and applicationId are required fields.");
        }
        return new AsyncQueryJobMetadata(applicationId, jobId, isDropIndexQuery, resultIndex);
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public boolean isDropIndexQuery() {
        return this.isDropIndexQuery;
    }

    @Generated
    public String getResultIndex() {
        return this.resultIndex;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setDropIndexQuery(boolean isDropIndexQuery) {
        this.isDropIndexQuery = isDropIndexQuery;
    }

    @Generated
    public void setResultIndex(String resultIndex) {
        this.resultIndex = resultIndex;
    }

    @Generated
    public AsyncQueryJobMetadata(String applicationId, String jobId, boolean isDropIndexQuery, String resultIndex) {
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.isDropIndexQuery = isDropIndexQuery;
        this.resultIndex = resultIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncQueryJobMetadata)) {
            return false;
        }
        AsyncQueryJobMetadata other = (AsyncQueryJobMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDropIndexQuery() != other.isDropIndexQuery()) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$resultIndex = this.getResultIndex();
        String other$resultIndex = other.getResultIndex();
        return !(this$resultIndex == null ? other$resultIndex != null : !this$resultIndex.equals(other$resultIndex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncQueryJobMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDropIndexQuery() ? 79 : 97);
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $resultIndex = this.getResultIndex();
        result = result * 59 + ($resultIndex == null ? 43 : $resultIndex.hashCode());
        return result;
    }
}

