/*
 * Decompiled with CFR 0.152.
 */
package net.atmp;

import com.plantuml.api.cheerpj.WasmLog;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import net.sourceforge.plantuml.AnnotatedBuilder;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.braille.UGraphicBraille;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColorSimple;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.LimitFinder;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.debug.UGraphicDebug;
import net.sourceforge.plantuml.klimt.drawing.eps.EpsStrategy;
import net.sourceforge.plantuml.klimt.drawing.eps.UGraphicEps;
import net.sourceforge.plantuml.klimt.drawing.g2d.UGraphicG2d;
import net.sourceforge.plantuml.klimt.drawing.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.klimt.drawing.html5.UGraphicHtml5;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgOption;
import net.sourceforge.plantuml.klimt.drawing.svg.UGraphicSvg;
import net.sourceforge.plantuml.klimt.drawing.tikz.UGraphicTikz;
import net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import net.sourceforge.plantuml.klimt.drawing.visio.UGraphicVdx;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.preproc.OptionKey;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.CornerParam;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.text.SvgCharSizeHack;
import net.sourceforge.plantuml.url.CMapData;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.warning.Warning;

public class ImageBuilder {
    private boolean annotations;
    private HColor backcolor = ImageBuilder.getDefaultHBackColor();
    private XDimension2D dimension;
    private final FileFormatOption fileFormatOption;
    private UDrawable udrawable;
    private ClockwiseTopRightBottomLeft margin = ClockwiseTopRightBottomLeft.none();
    private String metadata;
    private long seed = 42L;
    private ISkinParam skinParam;
    private StringBounder stringBounder;
    private int status = 0;
    private TitledDiagram diagram;
    private boolean randomPixel;
    private String warningOrError;
    private final Collection<Warning> warnings = new LinkedHashSet<Warning>();
    private static final FontConfiguration fc = FontConfiguration.blackBlueTrue(UFont.monospaced(10));

    public static ImageBuilder create(FileFormatOption fileFormatOption) {
        return new ImageBuilder(fileFormatOption);
    }

    public static ImageBuilder create(FileFormatOption fileFormatOption, UDrawable drawable) {
        return ImageBuilder.create(fileFormatOption).drawable(drawable);
    }

    private ImageBuilder(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
        this.stringBounder = fileFormatOption.getDefaultStringBounder(SvgCharSizeHack.NO_HACK);
    }

    public ImageBuilder annotations(boolean annotations) {
        this.annotations = annotations;
        return this;
    }

    public ImageBuilder backcolor(HColor backcolor) {
        this.backcolor = backcolor;
        return this;
    }

    public ImageBuilder blackBackcolor() {
        return this.backcolor(HColors.BLACK);
    }

    public ImageBuilder dimension(XDimension2D dimension) {
        this.dimension = dimension;
        return this;
    }

    private int getDpi() {
        return this.skinParam == null ? 96 : this.skinParam.getDpi();
    }

    public ImageBuilder drawable(UDrawable drawable) {
        this.udrawable = drawable;
        if (this.backcolor == null && drawable instanceof TextBlock) {
            this.backcolor = ((TextBlock)drawable).getBackcolor();
        }
        return this;
    }

    public ImageBuilder margin(ClockwiseTopRightBottomLeft margin) {
        this.margin = margin;
        return this;
    }

    public ImageBuilder metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public ImageBuilder randomPixel() {
        this.randomPixel = true;
        return this;
    }

    public ImageBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public ImageBuilder status(int status) {
        this.status = status;
        return this;
    }

    private String getSvgLinkTarget() {
        if (this.fileFormatOption.getSvgLinkTarget() != null) {
            return this.fileFormatOption.getSvgLinkTarget();
        }
        if (this.skinParam != null) {
            return this.skinParam.getSvgLinkTarget();
        }
        return null;
    }

    public ImageBuilder warningOrError(String warningOrError) {
        this.warningOrError = warningOrError;
        return this;
    }

    public ImageBuilder styled(TitledDiagram fromDiagram) {
        this.skinParam = fromDiagram.getSkinParam();
        this.stringBounder = this.fileFormatOption.getDefaultStringBounder(this.skinParam);
        this.annotations = true;
        this.backcolor = fromDiagram.calculateBackColor();
        this.margin = ImageBuilder.calculateMargin(fromDiagram);
        this.metadata = this.fileFormatOption.isWithMetadata() ? fromDiagram.getMetadata() : null;
        this.seed = fromDiagram.seed();
        this.diagram = fromDiagram;
        this.warningOrError = fromDiagram.getWarningOrError();
        this.warnings.addAll(fromDiagram.getWarnings());
        return this;
    }

    public ImageData write(OutputStream os) throws IOException {
        if (this.annotations && this.diagram != null) {
            if (!(this.udrawable instanceof TextBlock)) {
                throw new IllegalStateException("udrawable is not a TextBlock");
            }
            AnnotatedBuilder builder = new AnnotatedBuilder(this.diagram, this.skinParam, this.stringBounder);
            AnnotatedWorker annotatedWorker = new AnnotatedWorker(this.diagram, this.skinParam, this.stringBounder, builder);
            this.udrawable = annotatedWorker.addAdd((TextBlock)this.udrawable);
        }
        return this.writeImageInternal(os);
    }

    public byte[] writeByteArray() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.write(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private ImageData writeImageInternal(OutputStream os) throws IOException {
        Set<Url> urls;
        Scale scale;
        double scaleFactor;
        XDimension2D dim = this.getFinalDimension();
        XDimension2D dimWarning = null;
        if (this.warnings.size() > 0) {
            dimWarning = this.getWarningDimension(this.fileFormatOption.getFileFormat().getDefaultStringBounder());
            dim = dim.atLeast(dimWarning.getWidth(), 0.0);
            dim = dim.delta(15.0, dimWarning.getHeight() + 20.0);
        }
        if ((scaleFactor = ((scale = this.diagram == null ? null : this.diagram.getScale()) == null ? 1.0 : scale.getScale(dim.getWidth(), dim.getHeight())) * (double)this.getDpi() / 96.0) <= 0.0) {
            throw new IllegalStateException("Bad scaleFactor");
        }
        WasmLog.log("...image drawing...");
        UGraphic ug = this.createUGraphic(dim, scaleFactor, this.diagram == null ? Pragma.createEmpty() : this.diagram.getPragma());
        if (this.warnings.size() > 0) {
            this.drawWarning(dimWarning, ug.apply(UTranslate.dy(5.0)), dim.getWidth());
            ug = ug.apply(UTranslate.dy(dimWarning.getHeight() + 20.0));
        }
        this.maybeDrawBorder(ug, dim);
        if (this.randomPixel) {
            this.drawRandomPoint(ug);
        }
        ug = this.handwritten(ug.apply(new UTranslate(this.margin.getLeft(), this.margin.getTop())));
        this.udrawable.drawU(ug);
        ug.flushUg();
        ug.writeToStream(os, this.metadata, 96);
        os.flush();
        if (ug instanceof UGraphicG2d && (urls = ((UGraphicG2d)ug).getAllUrlsEncountered()).size() > 0) {
            CMapData cmap = CMapData.cmapString(urls, scaleFactor);
            return new ImageDataComplex(dim, cmap, this.warningOrError, this.status);
        }
        return this.createImageData(dim);
    }

    private void drawWarning(XDimension2D dimWarning, UGraphic ug, double fullWidth) {
        HColorSet set = HColorSet.instance();
        HColor back = set.getColorOrWhite("ffffcc").withDark(set.getColorOrWhite("774400"));
        HColor border = set.getColorOrWhite("ffdd88").withDark(set.getColorOrWhite("aa5500"));
        ug = ug.apply(back.bg()).apply(border);
        URectangle rect = URectangle.build(fullWidth - 10.0, dimWarning.getHeight() + 10.0).rounded(5.0);
        ug.apply(new UTranslate(5.0, 0.0)).apply(UStroke.withThickness(3.0)).draw(rect);
        ug = ug.apply(HColors.BLACK);
        ug = ug.apply(new UTranslate(10.0, 15.0));
        for (Warning w : this.warnings) {
            for (String s2 : w.getMessage()) {
                UText text = UText.build(s2, fc);
                ug.draw(text);
                double height = text.calculateDimension(ug.getStringBounder()).getHeight();
                ug = ug.apply(UTranslate.dy(height));
            }
            ug = ug.apply(UTranslate.dy(10.0));
        }
    }

    private XDimension2D getWarningDimension(StringBounder stringBounder) {
        XDimension2D result = new XDimension2D(0.0, 0.0);
        for (Warning w : this.warnings) {
            for (String s2 : w.getMessage()) {
                UText text = UText.build(s2, fc);
                XDimension2D dim = text.calculateDimension(stringBounder);
                result = result.mergeTB(dim);
            }
        }
        return result.delta(10.0, 5 + 10 * (this.warnings.size() - 1));
    }

    private void maybeDrawBorder(UGraphic ug, XDimension2D dim) {
        if (this.skinParam == null) {
            return;
        }
        HColor color = new Rose().getHtmlColor(this.skinParam, ColorParam.diagramBorder);
        UStroke stroke = this.skinParam.getThickness(LineParam.diagramBorder, null);
        if (stroke == null && color != null) {
            stroke = UStroke.simple();
        }
        if (stroke == null) {
            return;
        }
        URectangle rectangle = URectangle.build(dim.getWidth() - stroke.getThickness(), dim.getHeight() - stroke.getThickness()).rounded(this.skinParam.getRoundCorner(CornerParam.diagramBorder, null));
        ug.apply(color == null ? HColors.BLACK : color).apply(stroke).draw(rectangle);
    }

    private void drawRandomPoint(UGraphic ug2) {
        Random rnd = new Random();
        int red = rnd.nextInt(40);
        int green = rnd.nextInt(40);
        int blue = rnd.nextInt(40);
        Color c = new Color(red, green, blue);
        HColor color = HColors.simple(c);
        ug2.apply(color).apply(color.bg()).draw(URectangle.build(1.0, 1.0));
    }

    private XDimension2D getFinalDimension() {
        if (this.dimension == null) {
            LimitFinder limitFinder = LimitFinder.create(this.stringBounder, true);
            this.udrawable.drawU(limitFinder);
            this.dimension = new XDimension2D(limitFinder.getMaxX() + 1.0 + this.margin.getLeft() + this.margin.getRight(), limitFinder.getMaxY() + 1.0 + this.margin.getTop() + this.margin.getBottom());
        }
        return this.dimension;
    }

    private UGraphic handwritten(UGraphic ug) {
        if (this.skinParam != null && this.skinParam.handwritten()) {
            return new UGraphicHandwritten(ug);
        }
        if (this.diagram != null && this.diagram.getPreprocessingArtifact().getOption().isDefine(OptionKey.HANDWRITTEN)) {
            return new UGraphicHandwritten(ug);
        }
        return ug;
    }

    private UGraphic createUGraphic(XDimension2D dim, double scaleFactor, Pragma pragma) {
        ColorMapper colorMapper = this.fileFormatOption.getColorMapper();
        switch (this.fileFormatOption.getFileFormat()) {
            case PNG: 
            case RAW: {
                return this.createUGraphicPNG(scaleFactor, dim, this.fileFormatOption.getWatermark(), this.fileFormatOption.getFileFormat());
            }
            case SVG: {
                return this.createUGraphicSVG(scaleFactor, dim, pragma);
            }
            case EPS: {
                return new UGraphicEps(this.backcolor, colorMapper, this.stringBounder, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.backcolor, colorMapper, this.stringBounder, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.backcolor, colorMapper, this.stringBounder);
            }
            case VDX: {
                return new UGraphicVdx(this.backcolor, colorMapper, this.stringBounder);
            }
            case LATEX: {
                return new UGraphicTikz(this.backcolor, colorMapper, this.stringBounder, scaleFactor, true, pragma);
            }
            case LATEX_NO_PREAMBLE: {
                return new UGraphicTikz(this.backcolor, colorMapper, this.stringBounder, scaleFactor, false, pragma);
            }
            case BRAILLE_PNG: {
                return new UGraphicBraille(this.backcolor, colorMapper, this.stringBounder);
            }
            case UTXT: 
            case ATXT: {
                return new UGraphicTxt();
            }
            case DEBUG: {
                return new UGraphicDebug(scaleFactor, dim, this.getSvgLinkTarget(), this.getHoverPathColorRGB(), this.seed, this.getPreserveAspectRatio());
            }
        }
        throw new UnsupportedOperationException(this.fileFormatOption.getFileFormat().toString());
    }

    private UGraphic createUGraphicSVG(double scaleFactor, XDimension2D dim, Pragma pragma) {
        SvgOption option = SvgOption.basic().withPreserveAspectRatio(this.getPreserveAspectRatio());
        option = option.withHoverPathColorRGB(this.getHoverPathColorRGB());
        option = option.withMinDim(dim);
        option = option.withBackcolor(this.backcolor);
        option = option.withScale(scaleFactor);
        option = option.withColorMapper(this.fileFormatOption.getColorMapper());
        option = option.withLinkTarget(this.getSvgLinkTarget());
        option = option.withFont(pragma.getValue(PragmaKey.SVG_FONT));
        option = option.withPragma(pragma);
        if (this.diagram != null) {
            option = option.withTitle(this.diagram.getTitleDisplay());
            option = option.withRootAttribute("data-diagram-type", this.diagram.getUmlDiagramType().name());
        }
        if (pragma.isTrue(PragmaKey.SVG_INTERACTIVE)) {
            String interactiveBaseFilename = "default";
            if (this.diagram != null && this.diagram.getUmlDiagramType() == UmlDiagramType.SEQUENCE) {
                interactiveBaseFilename = "sequencediagram";
            }
            option = option.withInteractive(interactiveBaseFilename);
        }
        if (this.skinParam != null) {
            option = option.withLengthAdjust(this.skinParam.getlengthAdjust());
            option = option.withSvgDimensionStyle(this.skinParam.svgDimensionStyle());
        }
        UGraphicSvg ug = UGraphicSvg.build(option, false, this.seed, this.stringBounder);
        return ug;
    }

    private UGraphic createUGraphicPNG(double scaleFactor, XDimension2D dim, String watermark, FileFormat format) {
        Color pngBackColor = new Color(0, 0, 0, 0);
        if (this.backcolor instanceof HColorSimple) {
            pngBackColor = this.backcolor.toColor(this.fileFormatOption.getColorMapper());
        }
        if (OptionFlags.getInstance().isReplaceWhiteBackgroundByTransparent() && (Color.WHITE.equals(pngBackColor) || Color.BLACK.equals(pngBackColor))) {
            pngBackColor = new Color(0, 0, 0, 0);
        }
        EmptyImageBuilder builder = new EmptyImageBuilder(watermark, (int)(dim.getWidth() * scaleFactor), (int)(dim.getHeight() * scaleFactor), pngBackColor, this.stringBounder);
        Graphics2D graphics2D = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(this.backcolor, this.fileFormatOption.getColorMapper(), this.stringBounder, graphics2D, scaleFactor, format);
        ug.setBufferedImage(builder.getBufferedImage());
        BufferedImage im = ug.getBufferedImage();
        if (this.backcolor instanceof HColorGradient) {
            ug.apply(this.backcolor.bg()).draw(URectangle.build((double)im.getWidth() / scaleFactor, (double)im.getHeight() / scaleFactor));
        }
        return ug;
    }

    private static HColor getDefaultHBackColor() {
        return HColors.WHITE;
    }

    private String getHoverPathColorRGB() {
        HColor color;
        if (this.fileFormatOption.getHoverColor() != null) {
            return this.fileFormatOption.getHoverColor();
        }
        if (this.skinParam != null && (color = this.skinParam.hoverPathColor()) != null) {
            return color.toRGB(this.fileFormatOption.getColorMapper());
        }
        return null;
    }

    private static ClockwiseTopRightBottomLeft calculateMargin(TitledDiagram diagram) {
        Style style = StyleSignatureBasic.of(SName.root, SName.document).getMergedStyle(diagram.getSkinParam().getCurrentStyleBuilder());
        if (style.hasValue(PName.Margin)) {
            return style.getMargin();
        }
        return diagram.getDefaultMargins();
    }

    public String getPreserveAspectRatio() {
        if (this.fileFormatOption.getPreserveAspectRatio() != null) {
            return this.fileFormatOption.getPreserveAspectRatio();
        }
        if (this.skinParam != null) {
            return this.skinParam.getPreserveAspectRatio();
        }
        return "none";
    }

    private ImageDataSimple createImageData(XDimension2D dim) {
        return new ImageDataSimple(dim, this.status);
    }
}

