/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regexdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.regexdiagram.ReToken;
import net.sourceforge.plantuml.regexdiagram.ReTokenType;
import net.sourceforge.plantuml.regexdiagram.RegexParsingException;
import net.sourceforge.plantuml.utils.CharInspector;

public class RegexExpression {
    public static List<ReToken> parse(CharInspector it) throws RegexParsingException {
        char current;
        ArrayList<ReToken> result = new ArrayList<ReToken>();
        while ((current = it.peek(0)) != '\u0000') {
            ReToken token;
            String s2;
            if (RegexExpression.isStartAnchor(it)) {
                s2 = RegexExpression.readAnchor(it);
                result.add(new ReToken(ReTokenType.ANCHOR, s2));
                continue;
            }
            if (RegexExpression.isEscapedChar(it)) {
                result.add(new ReToken(ReTokenType.ESCAPED_CHAR, "" + it.peek(1)));
                it.jump();
                it.jump();
                continue;
            }
            if (current == '|') {
                result.add(new ReToken(ReTokenType.ALTERNATIVE, "|"));
                it.jump();
                continue;
            }
            if (RegexExpression.isStartPosixGroup(it)) {
                s2 = RegexExpression.readGroupPosix(it);
                result.add(new ReToken(ReTokenType.CLASS, s2));
                continue;
            }
            if (current == '[') {
                s2 = RegexExpression.readGroup(it);
                result.add(new ReToken(ReTokenType.GROUP, s2));
                continue;
            }
            if (RegexExpression.isStartComment(it)) {
                RegexExpression.skipComment(it);
                continue;
            }
            if (RegexExpression.isStartLookAhead(it)) {
                token = RegexExpression.readLookAhead(it);
                result.add(token);
                result.add(new ReToken(ReTokenType.PARENTHESIS_OPEN, "("));
                continue;
            }
            if (RegexExpression.isStartLookBehind(it)) {
                token = RegexExpression.readLookBehind(it);
                result.add(token);
                result.add(new ReToken(ReTokenType.PARENTHESIS_OPEN, "("));
                continue;
            }
            if (RegexExpression.isStartNamedCapturingGroup(it)) {
                token = RegexExpression.readNamedGroup(it);
                result.add(token);
                result.add(new ReToken(ReTokenType.PARENTHESIS_OPEN, "("));
                continue;
            }
            if (RegexExpression.isStartOpenParenthesis(it)) {
                token = RegexExpression.readOpenParenthesis(it);
                result.add(token);
                continue;
            }
            if (current == ')') {
                result.add(new ReToken(ReTokenType.PARENTHESIS_CLOSE, ")"));
                it.jump();
                continue;
            }
            if (RegexExpression.isStartQuantifier(it)) {
                s2 = RegexExpression.readQuantifier(it);
                result.add(new ReToken(ReTokenType.QUANTIFIER, s2));
                continue;
            }
            if (RegexExpression.isStartOctalEscape(it)) {
                s2 = RegexExpression.readUnicodeOrOctalEscape(it, 4);
                result.add(new ReToken(ReTokenType.CLASS, s2));
                continue;
            }
            if (RegexExpression.isStartUnicodeEscape(it)) {
                s2 = RegexExpression.readUnicodeOrOctalEscape(it, 5);
                result.add(new ReToken(ReTokenType.CLASS, s2));
                continue;
            }
            if (RegexExpression.isStartUnicodeClass(it)) {
                s2 = RegexExpression.readUnicodeClass(it);
                result.add(new ReToken(ReTokenType.CLASS, s2));
                continue;
            }
            if (RegexExpression.isStartClass(it)) {
                s2 = RegexExpression.readClass(it);
                result.add(new ReToken(ReTokenType.CLASS, s2));
                continue;
            }
            if (RegexExpression.isSimpleLetter(current)) {
                result.add(new ReToken(ReTokenType.SIMPLE_CHAR, "" + current));
                it.jump();
                continue;
            }
            throw new IllegalStateException();
        }
        return result;
    }

    private static boolean isStartLookAhead(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '(' && it.peek(1) == '?' && (it.peek(2) == '=' || it.peek(2) == '!');
    }

    private static boolean isStartLookBehind(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '(' && it.peek(1) == '?' && it.peek(2) == '<' && (it.peek(3) == '=' || it.peek(3) == '!');
    }

    private static boolean isStartOpenParenthesis(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '(';
    }

    private static boolean isStartPosixGroup(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '[' && it.peek(1) == '[' && it.peek(2) == ':';
    }

    private static boolean isStartNamedCapturingGroup(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '(' && it.peek(1) == '?' && it.peek(2) == '<') {
            int i = 3;
            while (it.peek(i) != '\u0000') {
                if (it.peek(i) == '>' && i == 3) {
                    return false;
                }
                if (it.peek(i) == '>') {
                    return true;
                }
                if (!Character.isLetter(it.peek(i))) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isStartComment(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '(' && it.peek(1) == '?' && it.peek(2) == '#';
    }

    private static void skipComment(CharInspector it) throws RegexParsingException {
        it.jump();
        it.jump();
        it.jump();
        StringBuilder comment = new StringBuilder();
        while (true) {
            if (it.peek(0) == '\u0000') {
                throw new RegexParsingException("Unclosed comment");
            }
            if (it.peek(0) == ')') {
                it.jump();
                return;
            }
            comment.append(it.peek(0));
            it.jump();
        }
    }

    private static ReToken readLookAhead(CharInspector it) throws RegexParsingException {
        it.jump();
        it.jump();
        char ch = it.peek(0);
        it.jump();
        return new ReToken(ReTokenType.LOOK_AHEAD, "?" + ch);
    }

    private static ReToken readLookBehind(CharInspector it) throws RegexParsingException {
        it.jump();
        it.jump();
        it.jump();
        char ch = it.peek(0);
        it.jump();
        return new ReToken(ReTokenType.LOOK_BEHIND, "?<" + ch);
    }

    private static ReToken readNamedGroup(CharInspector it) throws RegexParsingException {
        it.jump();
        it.jump();
        it.jump();
        StringBuilder namedGroup = new StringBuilder();
        while (true) {
            if (it.peek(0) == '\u0000') {
                throw new RegexParsingException("Unclosed named capturing group");
            }
            if (it.peek(0) == '>') {
                it.jump();
                return new ReToken(ReTokenType.NAMED_GROUP, namedGroup.toString());
            }
            namedGroup.append(it.peek(0));
            it.jump();
        }
    }

    private static ReToken readOpenParenthesis(CharInspector it) {
        char current0 = it.peek(0);
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        if (it.peek(0) == '?' && it.peek(1) == ':') {
            it.jump();
            it.jump();
            result.append("?:");
        }
        if (it.peek(0) == '?' && it.peek(1) == '!') {
            it.jump();
            it.jump();
            result.append("?!");
        }
        return new ReToken(ReTokenType.PARENTHESIS_OPEN, result.toString());
    }

    private static boolean isStartQuantifier(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '*' || current0 == '+' || current0 == '?' || current0 == '{';
    }

    private static String readQuantifier(CharInspector it) throws RegexParsingException {
        String result;
        char current0 = it.peek(0);
        it.jump();
        StringBuilder tmp = new StringBuilder();
        tmp.append(current0);
        if (current0 == '{') {
            while (it.peek(0) != '\u0000') {
                char ch = it.peek(0);
                tmp.append(ch);
                it.jump();
                if (ch != '}') continue;
                break;
            }
        }
        if (it.peek(0) == '?') {
            tmp.append('?');
            it.jump();
        }
        if ((result = tmp.toString()).startsWith("{") && !result.matches("^\\{[0-9,]+\\}$")) {
            throw new RegexParsingException("Bad quantifier " + result);
        }
        return result;
    }

    private static boolean isEscapedChar(CharInspector it) {
        char current1;
        char current0 = it.peek(0);
        return current0 == '\\' && ((current1 = it.peek(1)) == '.' || current1 == '*' || current1 == '\\' || current1 == '?' || current1 == '^' || current1 == '$' || current1 == '|' || current1 == '(' || current1 == ')' || current1 == '[' || current1 == ']' || current1 == '{' || current1 == '}' || current1 == '<' || current1 == '>');
    }

    private static String readGroupPosix(CharInspector it) {
        it.jump();
        it.jump();
        it.jump();
        StringBuilder result = new StringBuilder(":");
        while (it.peek(0) != '\u0000') {
            char ch = it.peek(0);
            it.jump();
            result.append(ch);
            if (ch != ':') continue;
            break;
        }
        it.jump();
        it.jump();
        return result.toString();
    }

    private static String readGroup(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 != '[') {
            throw new IllegalStateException();
        }
        it.jump();
        StringBuilder result = new StringBuilder();
        while (it.peek(0) != '\u0000') {
            char ch = it.peek(0);
            it.jump();
            if (ch == ']') break;
            result.append(ch);
            if (ch != '\\') continue;
            ch = it.peek(0);
            it.jump();
            result.append(ch);
        }
        return result.toString();
    }

    private static String readUnicodeClass(CharInspector it) throws RegexParsingException {
        char current0 = it.peek(0);
        if (current0 != '\\') {
            throw new IllegalStateException();
        }
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        while (it.peek(0) != '\u0000') {
            char ch = it.peek(0);
            it.jump();
            result.append(ch);
            if (ch != '}') continue;
            return result.toString();
        }
        throw new RegexParsingException("Unexpected end of data");
    }

    private static String readUnicodeOrOctalEscape(CharInspector it, int nb) throws RegexParsingException {
        char current0 = it.peek(0);
        if (current0 != '\\') {
            throw new IllegalStateException();
        }
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        for (int i = 0; i < nb; ++i) {
            char ch = it.peek(0);
            if (ch == '\u0000') {
                throw new RegexParsingException("Unexpected end of data");
            }
            result.append(ch);
            it.jump();
        }
        return result.toString();
    }

    private static String readClass(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '.') {
            it.jump();
            return "" + current0;
        }
        if (current0 == '\\') {
            it.jump();
            String result = "" + current0 + it.peek(0);
            it.jump();
            return result;
        }
        throw new IllegalStateException();
    }

    private static boolean isStartClass(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '.') {
            return true;
        }
        return current0 == '\\';
    }

    private static boolean isStartUnicodeClass(CharInspector it) {
        if (it.peek(0) == '\\' && it.peek(1) == 'p' && it.peek(2) == '{') {
            return true;
        }
        return it.peek(0) == '\\' && it.peek(1) == 'x' && it.peek(2) == '{';
    }

    private static boolean isStartUnicodeEscape(CharInspector it) {
        return it.peek(0) == '\\' && it.peek(1) == 'u';
    }

    private static boolean isStartOctalEscape(CharInspector it) {
        return it.peek(0) == '\\' && it.peek(1) == '0';
    }

    private static boolean isSimpleLetter(char ch) {
        return ch != '\\' && ch != '.';
    }

    private static boolean isStartAnchor(CharInspector it) {
        char current1;
        char current0 = it.peek(0);
        if (current0 == '^' || current0 == '$') {
            return true;
        }
        return current0 == '\\' && ((current1 = it.peek(1)) == 'A' || current1 == 'Z' || current1 == 'z' || current1 == 'G' || current1 == 'b' || current1 == 'B');
    }

    private static String readAnchor(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '^' || current0 == '$') {
            it.jump();
            return "" + current0;
        }
        if (current0 == '\\') {
            it.jump();
            String result = "" + current0 + it.peek(0);
            it.jump();
            return result;
        }
        throw new IllegalStateException();
    }
}

