import { CloudFormationServiceException as __BaseException } from "./CloudFormationServiceException";
export const AccountFilterType = {
    DIFFERENCE: "DIFFERENCE",
    INTERSECTION: "INTERSECTION",
    NONE: "NONE",
    UNION: "UNION",
};
export const AccountGateStatus = {
    FAILED: "FAILED",
    SKIPPED: "SKIPPED",
    SUCCEEDED: "SUCCEEDED",
};
export class InvalidOperationException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOperationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOperationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOperationException.prototype);
        this.Message = opts.Message;
    }
}
export class OperationNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "OperationNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const ThirdPartyType = {
    HOOK: "HOOK",
    MODULE: "MODULE",
    RESOURCE: "RESOURCE",
};
export const VersionBump = {
    MAJOR: "MAJOR",
    MINOR: "MINOR",
};
export class CFNRegistryException extends __BaseException {
    constructor(opts) {
        super({
            name: "CFNRegistryException",
            $fault: "client",
            ...opts,
        });
        this.name = "CFNRegistryException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CFNRegistryException.prototype);
        this.Message = opts.Message;
    }
}
export class TypeNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "TypeNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "TypeNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TypeNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class AlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export class TypeConfigurationNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "TypeConfigurationNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "TypeConfigurationNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TypeConfigurationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const CallAs = {
    DELEGATED_ADMIN: "DELEGATED_ADMIN",
    SELF: "SELF",
};
export class TokenAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "TokenAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "TokenAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TokenAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export const Capability = {
    CAPABILITY_AUTO_EXPAND: "CAPABILITY_AUTO_EXPAND",
    CAPABILITY_IAM: "CAPABILITY_IAM",
    CAPABILITY_NAMED_IAM: "CAPABILITY_NAMED_IAM",
};
export const Category = {
    ACTIVATED: "ACTIVATED",
    AWS_TYPES: "AWS_TYPES",
    REGISTERED: "REGISTERED",
    THIRD_PARTY: "THIRD_PARTY",
};
export const ChangeAction = {
    Add: "Add",
    Dynamic: "Dynamic",
    Import: "Import",
    Modify: "Modify",
    Remove: "Remove",
};
export const ChangeSource = {
    Automatic: "Automatic",
    DirectModification: "DirectModification",
    ParameterReference: "ParameterReference",
    ResourceAttribute: "ResourceAttribute",
    ResourceReference: "ResourceReference",
};
export const EvaluationType = {
    Dynamic: "Dynamic",
    Static: "Static",
};
export const ResourceAttribute = {
    CreationPolicy: "CreationPolicy",
    DeletionPolicy: "DeletionPolicy",
    Metadata: "Metadata",
    Properties: "Properties",
    Tags: "Tags",
    UpdatePolicy: "UpdatePolicy",
    UpdateReplacePolicy: "UpdateReplacePolicy",
};
export const RequiresRecreation = {
    Always: "Always",
    Conditionally: "Conditionally",
    Never: "Never",
};
export const Replacement = {
    Conditional: "Conditional",
    False: "False",
    True: "True",
};
export const ChangeType = {
    Resource: "Resource",
};
export const HookFailureMode = {
    FAIL: "FAIL",
    WARN: "WARN",
};
export const HookInvocationPoint = {
    PRE_PROVISION: "PRE_PROVISION",
};
export const HookTargetType = {
    RESOURCE: "RESOURCE",
};
export const ChangeSetHooksStatus = {
    PLANNED: "PLANNED",
    PLANNING: "PLANNING",
    UNAVAILABLE: "UNAVAILABLE",
};
export class ChangeSetNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ChangeSetNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ChangeSetNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ChangeSetNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const ChangeSetStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    CREATE_PENDING: "CREATE_PENDING",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    DELETE_PENDING: "DELETE_PENDING",
    FAILED: "FAILED",
};
export const ExecutionStatus = {
    AVAILABLE: "AVAILABLE",
    EXECUTE_COMPLETE: "EXECUTE_COMPLETE",
    EXECUTE_FAILED: "EXECUTE_FAILED",
    EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS",
    OBSOLETE: "OBSOLETE",
    UNAVAILABLE: "UNAVAILABLE",
};
export const ChangeSetType = {
    CREATE: "CREATE",
    IMPORT: "IMPORT",
    UPDATE: "UPDATE",
};
export const OnStackFailure = {
    DELETE: "DELETE",
    DO_NOTHING: "DO_NOTHING",
    ROLLBACK: "ROLLBACK",
};
export class InsufficientCapabilitiesException extends __BaseException {
    constructor(opts) {
        super({
            name: "InsufficientCapabilitiesException",
            $fault: "client",
            ...opts,
        });
        this.name = "InsufficientCapabilitiesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InsufficientCapabilitiesException.prototype);
        this.Message = opts.Message;
    }
}
export class LimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export const OnFailure = {
    DELETE: "DELETE",
    DO_NOTHING: "DO_NOTHING",
    ROLLBACK: "ROLLBACK",
};
export const ConcurrencyMode = {
    SOFT_FAILURE_TOLERANCE: "SOFT_FAILURE_TOLERANCE",
    STRICT_FAILURE_TOLERANCE: "STRICT_FAILURE_TOLERANCE",
};
export const RegionConcurrencyType = {
    PARALLEL: "PARALLEL",
    SEQUENTIAL: "SEQUENTIAL",
};
export class OperationIdAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "OperationIdAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationIdAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationIdAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export class OperationInProgressException extends __BaseException {
    constructor(opts) {
        super({
            name: "OperationInProgressException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationInProgressException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationInProgressException.prototype);
        this.Message = opts.Message;
    }
}
export class StackSetNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "StackSetNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackSetNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackSetNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class StaleRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "StaleRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "StaleRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StaleRequestException.prototype);
        this.Message = opts.Message;
    }
}
export class CreatedButModifiedException extends __BaseException {
    constructor(opts) {
        super({
            name: "CreatedButModifiedException",
            $fault: "client",
            ...opts,
        });
        this.name = "CreatedButModifiedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CreatedButModifiedException.prototype);
        this.Message = opts.Message;
    }
}
export const PermissionModels = {
    SELF_MANAGED: "SELF_MANAGED",
    SERVICE_MANAGED: "SERVICE_MANAGED",
};
export class NameAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "NameAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "NameAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NameAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidChangeSetStatusException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidChangeSetStatusException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidChangeSetStatusException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidChangeSetStatusException.prototype);
        this.Message = opts.Message;
    }
}
export class StackSetNotEmptyException extends __BaseException {
    constructor(opts) {
        super({
            name: "StackSetNotEmptyException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackSetNotEmptyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackSetNotEmptyException.prototype);
        this.Message = opts.Message;
    }
}
export const RegistryType = {
    HOOK: "HOOK",
    MODULE: "MODULE",
    RESOURCE: "RESOURCE",
};
export const OrganizationStatus = {
    DISABLED: "DISABLED",
    DISABLED_PERMANENTLY: "DISABLED_PERMANENTLY",
    ENABLED: "ENABLED",
};
export const IdentityProvider = {
    AWS_Marketplace: "AWS_Marketplace",
    Bitbucket: "Bitbucket",
    GitHub: "GitHub",
};
export const PublisherStatus = {
    UNVERIFIED: "UNVERIFIED",
    VERIFIED: "VERIFIED",
};
export const StackDriftDetectionStatus = {
    DETECTION_COMPLETE: "DETECTION_COMPLETE",
    DETECTION_FAILED: "DETECTION_FAILED",
    DETECTION_IN_PROGRESS: "DETECTION_IN_PROGRESS",
};
export const StackDriftStatus = {
    DRIFTED: "DRIFTED",
    IN_SYNC: "IN_SYNC",
    NOT_CHECKED: "NOT_CHECKED",
    UNKNOWN: "UNKNOWN",
};
export const HookStatus = {
    HOOK_COMPLETE_FAILED: "HOOK_COMPLETE_FAILED",
    HOOK_COMPLETE_SUCCEEDED: "HOOK_COMPLETE_SUCCEEDED",
    HOOK_FAILED: "HOOK_FAILED",
    HOOK_IN_PROGRESS: "HOOK_IN_PROGRESS",
};
export const ResourceStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    DELETE_SKIPPED: "DELETE_SKIPPED",
    IMPORT_COMPLETE: "IMPORT_COMPLETE",
    IMPORT_FAILED: "IMPORT_FAILED",
    IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
    IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
    IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
    IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
    ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
    ROLLBACK_FAILED: "ROLLBACK_FAILED",
    ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
    UPDATE_COMPLETE: "UPDATE_COMPLETE",
    UPDATE_FAILED: "UPDATE_FAILED",
    UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
    UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
    UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
    UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS",
};
export const StackInstanceDetailedStatus = {
    CANCELLED: "CANCELLED",
    FAILED: "FAILED",
    INOPERABLE: "INOPERABLE",
    PENDING: "PENDING",
    RUNNING: "RUNNING",
    SKIPPED_SUSPENDED_ACCOUNT: "SKIPPED_SUSPENDED_ACCOUNT",
    SUCCEEDED: "SUCCEEDED",
};
export const StackInstanceStatus = {
    CURRENT: "CURRENT",
    INOPERABLE: "INOPERABLE",
    OUTDATED: "OUTDATED",
};
export class StackInstanceNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "StackInstanceNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackInstanceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackInstanceNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const StackResourceDriftStatus = {
    DELETED: "DELETED",
    IN_SYNC: "IN_SYNC",
    MODIFIED: "MODIFIED",
    NOT_CHECKED: "NOT_CHECKED",
};
export const DifferenceType = {
    ADD: "ADD",
    NOT_EQUAL: "NOT_EQUAL",
    REMOVE: "REMOVE",
};
export const StackStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    IMPORT_COMPLETE: "IMPORT_COMPLETE",
    IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
    IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
    IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
    IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
    REVIEW_IN_PROGRESS: "REVIEW_IN_PROGRESS",
    ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
    ROLLBACK_FAILED: "ROLLBACK_FAILED",
    ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
    UPDATE_COMPLETE: "UPDATE_COMPLETE",
    UPDATE_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS",
    UPDATE_FAILED: "UPDATE_FAILED",
    UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
    UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
    UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS",
    UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
    UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS",
};
export const StackSetDriftDetectionStatus = {
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    PARTIAL_SUCCESS: "PARTIAL_SUCCESS",
    STOPPED: "STOPPED",
};
export const StackSetDriftStatus = {
    DRIFTED: "DRIFTED",
    IN_SYNC: "IN_SYNC",
    NOT_CHECKED: "NOT_CHECKED",
};
export const StackSetStatus = {
    ACTIVE: "ACTIVE",
    DELETED: "DELETED",
};
export const StackSetOperationAction = {
    CREATE: "CREATE",
    DELETE: "DELETE",
    DETECT_DRIFT: "DETECT_DRIFT",
    UPDATE: "UPDATE",
};
export const StackSetOperationStatus = {
    FAILED: "FAILED",
    QUEUED: "QUEUED",
    RUNNING: "RUNNING",
    STOPPED: "STOPPED",
    STOPPING: "STOPPING",
    SUCCEEDED: "SUCCEEDED",
};
export const DeprecatedStatus = {
    DEPRECATED: "DEPRECATED",
    LIVE: "LIVE",
};
export const ProvisioningType = {
    FULLY_MUTABLE: "FULLY_MUTABLE",
    IMMUTABLE: "IMMUTABLE",
    NON_PROVISIONABLE: "NON_PROVISIONABLE",
};
export const TypeTestsStatus = {
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    NOT_TESTED: "NOT_TESTED",
    PASSED: "PASSED",
};
export const Visibility = {
    PRIVATE: "PRIVATE",
    PUBLIC: "PUBLIC",
};
export const RegistrationStatus = {
    COMPLETE: "COMPLETE",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
export const TemplateStage = {
    Original: "Original",
    Processed: "Processed",
};
export class StackNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "StackNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const StackInstanceFilterName = {
    DETAILED_STATUS: "DETAILED_STATUS",
    DRIFT_STATUS: "DRIFT_STATUS",
    LAST_OPERATION_ID: "LAST_OPERATION_ID",
};
export const OperationResultFilterName = {
    OPERATION_RESULT_STATUS: "OPERATION_RESULT_STATUS",
};
export const StackSetOperationResultStatus = {
    CANCELLED: "CANCELLED",
    FAILED: "FAILED",
    PENDING: "PENDING",
    RUNNING: "RUNNING",
    SUCCEEDED: "SUCCEEDED",
};
export class InvalidStateTransitionException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidStateTransitionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidStateTransitionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidStateTransitionException.prototype);
        this.Message = opts.Message;
    }
}
export class OperationStatusCheckFailedException extends __BaseException {
    constructor(opts) {
        super({
            name: "OperationStatusCheckFailedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationStatusCheckFailedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationStatusCheckFailedException.prototype);
        this.Message = opts.Message;
    }
}
export const OperationStatus = {
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    PENDING: "PENDING",
    SUCCESS: "SUCCESS",
};
export const HandlerErrorCode = {
    AccessDenied: "AccessDenied",
    AlreadyExists: "AlreadyExists",
    GeneralServiceException: "GeneralServiceException",
    HandlerInternalFailure: "HandlerInternalFailure",
    InternalFailure: "InternalFailure",
    InvalidCredentials: "InvalidCredentials",
    InvalidRequest: "InvalidRequest",
    InvalidTypeConfiguration: "InvalidTypeConfiguration",
    NetworkFailure: "NetworkFailure",
    NonCompliant: "NonCompliant",
    NotFound: "NotFound",
    NotUpdatable: "NotUpdatable",
    ResourceConflict: "ResourceConflict",
    ServiceInternalError: "ServiceInternalError",
    ServiceLimitExceeded: "ServiceLimitExceeded",
    ServiceTimeout: "NotStabilized",
    Throttling: "Throttling",
    Unknown: "Unknown",
    UnsupportedTarget: "UnsupportedTarget",
};
export const ResourceSignalStatus = {
    FAILURE: "FAILURE",
    SUCCESS: "SUCCESS",
};
