import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DescribeStackDriftDetectionStatusInput,
  DescribeStackDriftDetectionStatusOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DescribeStackDriftDetectionStatusCommandInput
  extends DescribeStackDriftDetectionStatusInput {}
export interface DescribeStackDriftDetectionStatusCommandOutput
  extends DescribeStackDriftDetectionStatusOutput,
    __MetadataBearer {}
export declare class DescribeStackDriftDetectionStatusCommand extends $Command<
  DescribeStackDriftDetectionStatusCommandInput,
  DescribeStackDriftDetectionStatusCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DescribeStackDriftDetectionStatusCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeStackDriftDetectionStatusCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeStackDriftDetectionStatusCommandInput,
    DescribeStackDriftDetectionStatusCommandOutput
  >;
  private serialize;
  private deserialize;
}
