/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.renderer;

import org.sunflow.core.Display;
import org.sunflow.core.ImageSampler;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.Options;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public class SimpleRenderer
implements ImageSampler {
    private Scene scene;
    private Display display;
    private int imageWidth;
    private int imageHeight;
    private int numBucketsX;
    private int numBucketsY;
    private int bucketCounter;
    private int numBuckets;

    public boolean prepare(Options options, Scene scene, int n, int n2) {
        this.scene = scene;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.numBucketsX = this.imageWidth + 31 >>> 5;
        this.numBucketsY = this.imageHeight + 31 >>> 5;
        this.numBuckets = this.numBucketsX * this.numBucketsY;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Display display) {
        int n;
        this.display = display;
        display.imageBegin(this.imageWidth, this.imageHeight, 32);
        this.bucketCounter = 0;
        Timer timer = new Timer();
        timer.start();
        BucketThread[] bucketThreadArray = new BucketThread[this.scene.getThreads()];
        for (n = 0; n < bucketThreadArray.length; ++n) {
            bucketThreadArray[n] = new BucketThread();
            bucketThreadArray[n].start();
        }
        try {
            for (n = 0; n < bucketThreadArray.length; ++n) {
                try {
                    bucketThreadArray[n].join();
                    continue;
                }
                finally {
                    bucketThreadArray[n].updateStats();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            for (int i = 0; i < bucketThreadArray.length; ++i) {
                bucketThreadArray[i].interrupt();
            }
            UI.printError(UI.Module.BCKT, "Bucket processing was interrupted", new Object[0]);
        }
        UI.taskStop();
        timer.end();
        UI.printInfo(UI.Module.BCKT, "Render time: %s", timer.toString());
        display.imageEnd();
    }

    public void renderBucket(int n, int n2, IntersectionState intersectionState) {
        int n3 = n * 32;
        int n4 = n2 * 32;
        int n5 = Math.min(32, this.imageWidth - n3);
        int n6 = Math.min(32, this.imageHeight - n4);
        Color[] colorArray = new Color[n5 * n6];
        float[] fArray = new float[n5 * n6];
        int n7 = 0;
        for (int i = 0; i < n6; ++i) {
            int n8 = 0;
            while (n8 < n5) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ShadingState shadingState = this.scene.getRadiance(intersectionState, n3 + n8, this.imageHeight - 1 - (n4 + i), 0.0, 0.0, 0.0, 0, 0, null);
                colorArray[n7] = shadingState != null ? shadingState.getResult() : Color.BLACK;
                fArray[n7] = shadingState != null ? 1.0f : 0.0f;
                ++n8;
                ++n7;
            }
        }
        this.display.imageUpdate(n3, n4, n5, n6, colorArray, fArray);
    }

    private class BucketThread
    extends Thread {
        private final IntersectionState istate = new IntersectionState();

        private BucketThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                int n;
                int n2;
                SimpleRenderer simpleRenderer = SimpleRenderer.this;
                synchronized (simpleRenderer) {
                    if (SimpleRenderer.this.bucketCounter >= SimpleRenderer.this.numBuckets) {
                        return;
                    }
                    n2 = SimpleRenderer.this.bucketCounter / SimpleRenderer.this.numBucketsX;
                    n = SimpleRenderer.this.bucketCounter % SimpleRenderer.this.numBucketsX;
                    SimpleRenderer.this.bucketCounter++;
                }
                SimpleRenderer.this.renderBucket(n, n2, this.istate);
            }
        }

        void updateStats() {
            SimpleRenderer.this.scene.accumulateStats(this.istate);
        }
    }
}

