/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import java.io.IOException;

public class CsvList
extends DataObjectList {
    public CsvList() {
    }

    public CsvList(int n) {
        super(n);
    }

    @Override
    public TeXObjectList createList() {
        return new CsvList(this.capacity());
    }

    public static CsvList getList(TeXParser teXParser, TeXObject teXObject) throws IOException {
        CsvList csvList = new CsvList();
        csvList.parseList(teXParser, teXObject);
        return csvList;
    }

    public void parseList(TeXParser teXParser, TeXObject teXObject) throws IOException {
        if (teXObject instanceof TeXObjectList) {
            if (((TeXObjectList)teXObject).isEmpty()) {
                return;
            }
            TeXObjectList teXObjectList = new TeXObjectList();
            for (TeXObject teXObject2 : (TeXObjectList)teXObject) {
                if (this.isSeparator(teXObject2)) {
                    this.add(teXObjectList);
                    teXObjectList = new TeXObjectList();
                    continue;
                }
                teXObjectList.add(teXObject2);
            }
            this.add(teXObjectList);
        } else if (!this.isSeparator(teXObject)) {
            this.add(teXObject);
        }
    }

    public TeXObject getSeparator(TeXParser teXParser) {
        return teXParser.getListener().getOther(44);
    }

    public boolean isSeparator(TeXObject teXObject) {
        return CsvList.isComma(teXObject);
    }

    public static boolean isComma(TeXObject teXObject) {
        TeXObjectList teXObjectList;
        if (teXObject instanceof CharObject) {
            return ((CharObject)teXObject).getCharCode() == 44;
        }
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group) && (teXObjectList = (TeXObjectList)teXObject).size() == 1) {
            return CsvList.isComma((TeXObject)teXObjectList.firstElement());
        }
        return false;
    }

    public TeXObject getValue(int n) {
        TeXObject teXObject;
        int n2;
        TeXObject teXObject2 = (TeXObject)this.get(n);
        if (!(teXObject2 instanceof TeXObjectList)) {
            return teXObject2;
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject2;
        int n3 = teXObjectList.size();
        if (n3 == 0) {
            return teXObject2;
        }
        if (n3 == 1) {
            teXObject2 = (TeXObject)teXObjectList.get(0);
            if (teXObject2 instanceof Group && !(teXObject2 instanceof MathGroup)) {
                return ((Group)teXObject2).toList();
            }
            return teXObject2;
        }
        int n4 = 0;
        int n5 = n3 - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            teXObject = (TeXObject)teXObjectList.get(n2);
            if (teXObject instanceof Ignoreable) continue;
            n4 = n2;
            break;
        }
        for (n2 = n5; n2 >= 0; --n2) {
            teXObject = (TeXObject)teXObjectList.get(n2);
            if (teXObject instanceof Ignoreable) continue;
            n5 = n2;
            break;
        }
        if (n4 == n5) {
            teXObject2 = (TeXObject)teXObjectList.get(n4);
            if (teXObject2 instanceof Group && !(teXObject2 instanceof MathGroup)) {
                return ((Group)teXObject2).toList();
            }
            return teXObject2;
        }
        TeXObjectList teXObjectList2 = new TeXObjectList();
        for (int i = n4; i <= n5; ++i) {
            teXObjectList2.add((TeXObject)teXObjectList.get(i));
        }
        return teXObjectList2;
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList(this.capacity());
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                teXObjectList.add(this.getSeparator(teXParser));
            }
            teXObjectList.add((TeXObject)((TeXObject)this.get(i)).clone());
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        boolean bl = true;
        StackMarker stackMarker = null;
        if (teXObjectList != teXParser && teXObjectList != null) {
            stackMarker = new StackMarker();
            this.add(stackMarker);
            this.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (this.size() > 0 && !(teXObject = (TeXObject)this.remove(0)).equals(stackMarker)) {
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Ignoreable) continue;
            if (bl) {
                bl = false;
            } else {
                this.getSeparator(teXParser).process(teXParser, teXObjectList);
            }
            teXObject.process(teXParser, this);
        }
        if (!this.isEmpty()) {
            teXObjectList.addAll(this);
            this.clear();
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        boolean bl = true;
        while (this.size() > 0) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Ignoreable) continue;
            if (bl) {
                bl = false;
            } else {
                this.getSeparator(teXParser).process(teXParser);
            }
            teXObject.process(teXParser, this);
        }
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (TeXObject teXObject : this) {
            if (!(teXObject instanceof Ignoreable)) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(this.getSeparator(teXParser).toString(teXParser));
                }
            }
            stringBuilder.append(teXObject.toString(teXParser));
        }
        return stringBuilder.toString();
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (TeXObject teXObject : this) {
            if (!(teXObject instanceof Ignoreable)) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
            }
            stringBuilder.append(teXObject.format());
        }
        return stringBuilder.toString();
    }

    @Override
    public String purified() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (TeXObject teXObject : this) {
            if (!(teXObject instanceof Ignoreable)) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
            }
            stringBuilder.append(teXObject.purified());
        }
        return stringBuilder.toString();
    }
}

