/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.Arrays;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    protected final int targetOffset;
    protected final String methodName;
    protected final int paramCount;
    protected Class<?>[] paramTypes = null;
    protected boolean useExactMatch = false;

    public CallMethodRule(String string, int n) {
        this(0, string, n);
    }

    public CallMethodRule(int n, String string, int n2) {
        this.targetOffset = n;
        this.methodName = string;
        this.paramCount = n2;
        if (n2 == 0) {
            this.paramTypes = new Class[]{String.class};
        } else {
            this.paramTypes = new Class[n2];
            Arrays.fill(this.paramTypes, String.class);
        }
    }

    public CallMethodRule(String string) {
        this(0, string, 0, null);
    }

    public CallMethodRule(int n, String string, int n2, Class<?>[] classArray) {
        this.targetOffset = n;
        this.methodName = string;
        this.paramCount = n2;
        if (classArray == null) {
            this.paramTypes = new Class[n2];
            Arrays.fill(this.paramTypes, String.class);
        } else {
            this.paramTypes = new Class[classArray.length];
            System.arraycopy(classArray, 0, this.paramTypes, 0, this.paramTypes.length);
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean bl) {
        this.useExactMatch = bl;
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] objectArray = new Object[this.paramCount];
            this.digester.pushParams(objectArray);
        }
    }

    @Override
    public void body(String string, String string2, String string3) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = string3.trim().intern();
        }
    }

    @Override
    public void end(String string, String string2) throws Exception {
        Object object;
        int n;
        Object[] objectArray = null;
        if (this.paramCount > 0) {
            objectArray = (Object[])this.digester.popParams();
            if (this.digester.log.isTraceEnabled()) {
                n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.digester.log.trace((Object)("[CallMethodRule](" + i + ")" + objectArray[i]));
                }
            }
            if (this.paramCount == 1 && objectArray[0] == null) {
                return;
            }
        } else if (this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            objectArray = new Object[]{this.bodyText};
        }
        Object[] objectArray2 = new Object[this.paramTypes.length];
        for (n = 0; n < this.paramTypes.length; ++n) {
            object = objectArray[n];
            objectArray2[n] = null == object && !this.paramTypes[n].isPrimitive() ? null : (object instanceof String && !String.class.isAssignableFrom(this.paramTypes[n]) ? IntrospectionUtils.convert((String)((String)objectArray[n]), this.paramTypes[n]) : objectArray[n]);
        }
        Object object2 = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (object2 == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("[CallMethodRule]{");
            ((StringBuilder)object).append(this.digester.match);
            ((StringBuilder)object).append("} Call target is null (");
            ((StringBuilder)object).append("targetOffset=");
            ((StringBuilder)object).append(this.targetOffset);
            ((StringBuilder)object).append(",stackdepth=");
            ((StringBuilder)object).append(this.digester.getCount());
            ((StringBuilder)object).append(')');
            throw new SAXException(((StringBuilder)object).toString());
        }
        if (this.digester.log.isDebugEnabled()) {
            object = new StringBuilder("[CallMethodRule]{");
            ((StringBuilder)object).append(this.digester.match);
            ((StringBuilder)object).append("} Call ");
            ((StringBuilder)object).append(object2.getClass().getName());
            ((StringBuilder)object).append('.');
            ((StringBuilder)object).append(this.methodName);
            ((StringBuilder)object).append('(');
            for (int i = 0; i < objectArray2.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)object).append(',');
                }
                if (objectArray2[i] == null) {
                    ((StringBuilder)object).append("null");
                } else {
                    ((StringBuilder)object).append(objectArray2[i].toString());
                }
                ((StringBuilder)object).append('/');
                if (this.paramTypes[i] == null) {
                    ((StringBuilder)object).append("null");
                    continue;
                }
                ((StringBuilder)object).append(this.paramTypes[i].getName());
            }
            ((StringBuilder)object).append(')');
            this.digester.log.debug((Object)((StringBuilder)object).toString());
        }
        object = IntrospectionUtils.callMethodN((Object)object2, (String)this.methodName, (Object[])objectArray2, (Class[])this.paramTypes);
        this.processMethodCallResult(object);
        StringBuilder stringBuilder = this.digester.getGeneratedCode();
        if (stringBuilder != null) {
            stringBuilder.append(this.digester.toVariableName(object2)).append('.').append(this.methodName);
            stringBuilder.append('(');
            for (int i = 0; i < objectArray2.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (this.bodyText != null) {
                    stringBuilder.append("\"").append(IntrospectionUtils.escape((String)this.bodyText)).append("\"");
                    continue;
                }
                if (objectArray2[i] instanceof String) {
                    stringBuilder.append("\"").append(IntrospectionUtils.escape((String)objectArray2[i].toString())).append("\"");
                    continue;
                }
                stringBuilder.append(this.digester.toVariableName(objectArray2[i]));
            }
            stringBuilder.append(");");
            stringBuilder.append(System.lineSeparator());
        }
    }

    @Override
    public void finish() throws Exception {
        this.bodyText = null;
    }

    protected void processMethodCallResult(Object object) {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CallMethodRule[");
        stringBuilder.append("methodName=");
        stringBuilder.append(this.methodName);
        stringBuilder.append(", paramCount=");
        stringBuilder.append(this.paramCount);
        stringBuilder.append(", paramTypes={");
        if (this.paramTypes != null) {
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.paramTypes[i].getName());
            }
        }
        stringBuilder.append('}');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

